// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/driver/board.c $
// $Rev: 53095 $
// $Date: 2023-06-13 10:42:41 -0500 (Tue, 13 Jun 2023) $

// SIO4: Device Driver: source file

#include "main.h"



/******************************************************************************
*
*	Function:	board_init_ioctl
*
*	Purpose:
*
*		Implement the Initialize Board IOCTL service.
*
*	Arguments:
*
*		chan	The structure for the chanel being accessed.
*
*		arg		The argument passed by the user.
*
*	Returned:
*
*		0		All went well.
*		< 0		An appropriate error status.
*
******************************************************************************/

s32 board_init_ioctl(chan_data_t* chan, void* arg)
{
	dev_data_t*	dev		= chan->dev;
	sio4_mp_t	mp;
	sio4_osc_t	osc;

	device_reset(dev);

	// Initialize the programmable oscillator.
	osc_init_ioctl(&dev->channel[0], &osc);
	osc_init_ioctl(&dev->channel[1], &osc);
	osc_init_ioctl(&dev->channel[2], &osc);
	osc_init_ioctl(&dev->channel[3], &osc);

	// Initialize the Multi-Protocol transceiver support.
	mp_init_ioctl(&dev->channel[0], &mp);
	mp_init_ioctl(&dev->channel[1], &mp);
	mp_init_ioctl(&dev->channel[2], &mp);
	mp_init_ioctl(&dev->channel[3], &mp);

	return(0);
}



/******************************************************************************
*
*	Function:	board_jumpers_ioctl
*
*	Purpose:
*
*		Implement the Board Jumpers IOCTL service.
*
*	Arguments:
*
*		chan	The structure for the chanel being accessed.
*
*		arg		The argument passed by the user.
*
*	Returned:
*
*		0		All went well.
*		< 0		An appropriate error status.
*
******************************************************************************/

s32 board_jumpers_ioctl(chan_data_t* chan, s32* arg)
{
	arg[0]	= chan->dev->cache.user_jumper_val;
	return(0);
}



