#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "sio4_dsl.h"

int sio4_reg_read(int fd, u32 reg, u32* value)
{
	REGISTER_PARAMS	parm;
	int				status;

	parm.u32RegisterNumber	= reg;
	parm.u32Value			= 0xDEADBEEF;
	status		= ioctl(fd, SIO4_READ_REGISTER, &parm);
	value[0]	= parm.u32Value;

	if (status == -1)
		printf("ioctl() failure, errno = %d\n", errno);

	return(status);
}
