#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "sio4_dsl.h"

int sio4_osc_reset(int fd, s32* freq_got, int verbose)
{
	sio4_osc_t	osc;
	int			status;

	status	= ioctl(fd, SIO4_OSC_RESET, &osc);

	if (freq_got)
		freq_got[0]	= osc.freq_got;

	if ((verbose) && (status == -1))
		printf("ioctl() failure, errno = %d\n", errno);

	return(status);
}
