#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "sio4_dsl.h"

int sio4_mp_test(int fd, s32 want, s32* got, int verbose)
{
	sio4_mp_t	mp;
	int			status;

	mp.prot_want	= want;
	status			= ioctl(fd, SIO4_MP_TEST, &mp);
	got[0]			= mp.prot_got;

	if ((verbose) && (status == -1))
		printf("ioctl() failure, errno = %d\n", errno);

	return(status);
}
