#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "sio4_dsl.h"

int sio4_mp_info(int fd, u32* chip, s32* got, int verbose)
{
	sio4_mp_t	mp;
	int			status;

	status	= ioctl(fd, SIO4_MP_INFO, &mp);

	if (chip)
		chip[0]	= mp.chip;

	if (got)
		got[0]	= mp.prot_got;

	if ((verbose) && (status == -1))
		printf("ioctl() failure, errno = %d\n", errno);

	return(status);
}
