#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "sio4_dsl.h"

int sio4_hdlc_setup_tx(int fd, int verbose)
{
	XMT_HDLC_PROTOCOL	parm;
	int					status;

	parm.u8SharedZeroFlags	= 0;
	parm.u8TxPreambleEnable	= 0;
	parm.eTxUnderrun		= ABORT_COND;
	status	= ioctl(fd, SIO4_SET_XMT_HDLC_PROT, &parm);

	if ((verbose) && (status == -1))
		printf("ioctl() failure, errno = %d\n", errno);

	return(status);
}
