#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "sio4_dsl.h"

int sio4_dpll_set_resync(int fd, DPLL_RESYNC resync, int verbose)
{
	int	status;

	status	= ioctl(fd, SIO4_SELECT_DPLL_RESYNC, resync);

	if ((verbose) && (status == -1))
		printf("ioctl() failure, errno = %d\n", errno);

	return(status);
}
