#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "sio4_dsl.h"

int sio4_dpll_set_divisor(int fd, DPLL_DIVISOR divisor, int verbose)
{
	int	status;

	status	= ioctl(fd, SIO4_SET_DPLL_DIVISOR, divisor);

	if ((verbose) && (status == -1))
		printf("ioctl() failure, errno = %d\n", errno);

	return(status);
}
