#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "sio4_dsl.h"

int sio4_dma_set_options(
	int						fd,
	STATUS_BLOCK_OPTIONS	tx_opts,
	u8						tx_wait,
	STATUS_BLOCK_OPTIONS	rx_opts,
	u8						rx_wait,
	int						verbose)
{
	USC_DMA_OPTIONS	parm;
	int				status;

	parm.eTxStatusBlockOptions	= tx_opts;
	parm.u8TxDMAWaitForTrigger	= tx_wait;
	parm.eRxStatusBlockOptions	= rx_opts;
	parm.u8RxDMAWaitForTrigger	= rx_wait;
	status	= ioctl(fd, SIO4_SET_USC_DMA_OPTIONS, &parm);

	if ((verbose) && (status == -1))
		printf("ioctl() failure, errno = %d\n", errno);

	return(status);
}
