// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/utils/util_tx_fifo_status.c $
// $Rev: 53094 $
// $Date: 2023-06-13 10:21:23 -0500 (Tue, 13 Jun 2023) $

// SIO4: Utilities: source file

#include "main.h"

// Useless code for the validation script.
//	if (verbose
//	if (verbose



//*****************************************************************************
int sio4_tx_fifo_status_quiet(int fd, s32* get)
{
	int	errs	= 0;
	s32	fifo;
	int	status;

	status	= ioctl(fd, SIO4_TX_FIFO_STATUS, &fifo);

	if (status)
	{
		errs	= 1;
		printf(	"FAIL <---  (%d. SIO4_TX_FIFO_STATUS: errno %d)\n",
				__LINE__,
				errno);
	}

	if (get)
		get[0]	= fifo;

	return(errs);
}



//*****************************************************************************
int sio4_tx_fifo_status(int fd, s32* get)
{
	int	errs;
	s32	fifo;

	gsc_label("Tx FIFO Status");
	errs	= sio4_tx_fifo_status_quiet(fd, &fifo);

	if (errs == 0)
	{
		switch (fifo)
		{
			default:

				errs	= 1;
				printf(	"FAIL <---  (%d. invalid status: 0x%lX)\n",
						__LINE__,
						(long) fifo);
				break;

			case SIO4_FIFO_STATUS_EMPTY:		printf("Empty\n");			break;
			case SIO4_FIFO_STATUS_ALMOST_EMPTY:	printf("Almost Empty\n");	break;
			case SIO4_FIFO_STATUS_MEDIAN:		printf("Median\n");			break;
			case SIO4_FIFO_STATUS_ALMOST_FULL:	printf("Almost Full\n");	break;
			case SIO4_FIFO_STATUS_FULL:			printf("Full\n");			break;
		}
	}

	if (get)
		get[0]	= fifo;

	return(errs);
}



