// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/utils/util_tx.c $
// $Rev: 53094 $
// $Date: 2023-06-13 10:21:23 -0500 (Tue, 13 Jun 2023) $

// SIO4: Utilities: source file

#include "main.h"

// Useless code for the validation script.
//	if (verbose
//	if (verbose



/******************************************************************************
*
*	Function:	tx_cable_clock_config
*
*	Purpose:
*
*		Put a wrapper around the sio4_tx_cable_clock_config() call.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		set		The value to apply.
*
*		get		The setting afterwards.
*
*		loud	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int tx_cable_clock_config(int fd, s32 set, s32* get, int loud)
{
	int	errs;
	int	ret;

	ret		= sio4_tx_cable_clock_config(fd, set, get, 0);
	errs	= (ret < 0) ? 1 : 0;
	gsc_label_fail_func(errs, loud, "sio4_tx_cable_clock_config");
	return(errs);
}



/******************************************************************************
*
*	Function:	tx_cable_config
*
*	Purpose:
*
*		Put a wrapper around the sio4_tx_cable_config() call.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		set		The value to apply.
*
*		get		The setting afterwards.
*
*		loud	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int tx_cable_config(int fd, s32 set, s32* get, int loud)
{
	int	errs;
	int	ret;

	ret		= sio4_tx_cable_config(fd, set, get, 0);
	errs	= (ret < 0) ? 1 : 0;
	gsc_label_fail_func(errs, loud, "sio4_tx_cable_config");
	return(errs);
}



/******************************************************************************
*
*	Function:	tx_cable_data_config
*
*	Purpose:
*
*		Put a wrapper around the sio4_tx_cable_data_config() call.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		set		The value to apply.
*
*		get		The setting afterwards.
*
*		loud	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int tx_cable_data_config(int fd, s32 set, s32* get, int loud)
{
	int	errs;
	int	ret;

	ret		= sio4_tx_cable_data_config(fd, set, get, 0);
	errs	= (ret < 0) ? 1 : 0;
	gsc_label_fail_func(errs, loud, "sio4_tx_cable_data_config");
	return(errs);
}



/******************************************************************************
*
*	Function:	tx_fifo_ae_config
*
*	Purpose:
*
*		Put a wrapper around the sio4_tx_fifo_ae_config() call.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		set		The value to apply.
*
*		get		The setting afterwards.
*
*		loud	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int tx_fifo_ae_config(int fd, s32 set, s32* get, int loud)
{
	int	errs;
	int	ret;

	ret		= sio4_tx_fifo_ae_config(fd, set, get, 0);
	errs	= (ret < 0) ? 1 : 0;
	gsc_label_fail_func(errs, loud, "sio4_tx_fifo_ae_config");
	return(errs);
}



/******************************************************************************
*
*	Function:	tx_fifo_af_config
*
*	Purpose:
*
*		Put a wrapper around the sio4_tx_fifo_af_config() call.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		set		The value to apply.
*
*		get		The setting afterwards.
*
*		loud	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int tx_fifo_af_config(int fd, s32 set, s32* get, int loud)
{
	int	errs;
	int	ret;

	ret		= sio4_tx_fifo_af_config(fd, set, get, 0);
	errs	= (ret < 0) ? 1 : 0;
	gsc_label_fail_func(errs, loud, "sio4_tx_fifo_af_config");
	return(errs);
}



/******************************************************************************
*
*	Function:	tx_fifo_size_compute
*
*	Purpose:
*
*		Compute the Tx FIFO. This is done by writing data to the FIFO until it
*		registers as full.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		size	The computed size is recorded here.
*
*		loud	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int tx_fifo_size_compute(int fd, s32* size, int loud)
{
	u32	csr;
	int	errs	= 0;
	s32	qty		= 0;
	s32	tx		= 0;

	for (;;)	// A convenience loop.
	{
		size[0]	= 0;
		errs	+= fifo_reset(fd, TX_AND_RX_FIFO, loud);
		errs	+= channel_reset(fd, loud);
		errs	+= reg_read(fd, -1, 0, SIO4_GSC_CSR, &csr);

		if (errs)
			break;

		if ((csr & 0xF00) == 0xF00)
		{
			qty	= 0;
			gsc_label_fail_text(errs, loud, "No Tx FIFO");
			break;
		}

		for (; (errs == 0) && (tx != SIO4_FIFO_STATUS_FULL); qty++)
		{
			errs	+= reg_write(fd, SIO4_GSC_FDR, 0);
			errs	+= sio4_tx_fifo_status_quiet(fd, &tx);
		}

		errs	+= fifo_reset(fd, TX_FIFO, loud);
		break;
	}

	if (errs)
		qty	= 0;

	size[0]	= qty;
	return(errs);
}



/******************************************************************************
*
*	Function:	tx_fifo_size
*
*	Purpose:
*
*		Put a wrapper around the sio4_tx_fifo_size() call.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		size	The size is reported here.
*
*		loud	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int tx_fifo_size(int fd, s32* size, int loud)
{
	int	errs;
	int	ret;

	ret	= sio4_tx_fifo_size(fd, size, 0);

	if (ret >= 0)
	{
		errs	= 0;
	}
	else
	{
		errs	= 1;
		gsc_label_fail_func(errs, loud, "sio4_tx_fifo_size");
	}

	return(errs);
}



/******************************************************************************
*
*	Function:	tx_io_mode_config
*
*	Purpose:
*
*		Put a wrapper around the sio4_tx_io_mode_config() call.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		set		The value to apply.
*
*		get		The setting afterwards.
*
*		loud	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int tx_io_mode_config(int fd, s32 set, s32* get, int loud)
{
	int	errs;
	int	ret;

	ret		= sio4_tx_io_mode_config(fd, set, get, 0);
	errs	= (ret < 0) ? 1 : 0;
	gsc_label_fail_func(errs, loud, "sio4_tx_io_mode_config");
	return(errs);
}



/******************************************************************************
*
*	Function:	txc_usc_config
*
*	Purpose:
*
*		Put a wrapper around the sio4_txc_usc_config() call.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		set		The value to apply.
*
*		get		The setting afterwards.
*
*		loud	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int txc_usc_config(int fd, s32 set, s32* get, int loud)
{
	int	errs;
	int	ret;

	ret		= sio4_txc_usc_config(fd, set, get, 0);
	errs	= (ret < 0) ? 1 : 0;
	gsc_label_fail_func(errs, loud, "sio4_txc_usc_config");
	return(errs);
}



