// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/utils/util_osc.c $
// $Rev: 53094 $
// $Date: 2023-06-13 10:21:23 -0500 (Tue, 13 Jun 2023) $

// SIO4: Utilities: source file

#include "main.h"

// Useless code for the validation script.
//	if (verbose
//	if (verbose



/******************************************************************************
*
*	Function:	osc_init
*
*	Purpose:
*
*		Put a wrapper around the sio4_osc_init() call.
*
*	Arguments:
*
*		fd		The handles to access all four channels.
*
*		got		The programmed output frequency afterwards.
*
*		loud	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int osc_init(int fd, s32* got, int loud)
{
	int	errs;
	int	ret;

	ret		= sio4_osc_init(fd, got, 0);
	errs	= (ret < 0) ? 1 : 0;
	gsc_label_fail_func(errs, loud, "sio4_osc_init");
	return(errs);
}



/******************************************************************************
*
*	Function:	osc_measure
*
*	Purpose:
*
*		Put a wrapper around the sio4_osc_measure() call.
*
*	Arguments:
*
*		fd		The handles to access all four channels.
*
*		got		The results.
*
*		loud	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int osc_measure(int fd, s32* got, int loud)
{
	int	errs;
	int	ret;

	ret		= sio4_osc_measure(fd, got, 0);
	errs	= (ret < 0) ? 1 : 0;
	gsc_label_fail_func(errs, loud, "sio4_osc_measure");
	return(errs);
}



/******************************************************************************
*
*	Function:	osc_program
*
*	Purpose:
*
*		Put a wrapper around the sio4_osc_program() call.
*
*	Arguments:
*
*		fd		The handles to access all four channels.
*
*		want	The frequency desired.
*
*		got		The frequency obtained.
*
*		loud	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int osc_program(int fd, s32 want, s32* got, int loud)
{
	int	errs;
	int	ret;

	ret		= sio4_osc_program(fd, want, got, 0);
	errs	= (ret < 0) ? 1 : 0;
	gsc_label_fail_func(errs, loud, "sio4_osc_program");
	return(errs);
}



/******************************************************************************
*
*	Function:	osc_ref_compute
*
*	Purpose:
*
*		Compute the reference frequency that should be used.
*
*	Arguments:
*
*		fd		The device handle to access.
*
*		ref		We report the computed reference clock to use.
*
*		baud	The desired baud rate.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int osc_ref_compute(int fd, s32* ref, s32 baud, int loud)
{
	int	errs;
	int	i;
	s32	prog;
	s32	res;

	errs	= feature_test__osc_program(fd, &prog, loud);

	if ((errs == 0) && (prog == SIO4_FEATURE_YES))
	{
		for (i = 4; i; i /= 2)
		{
			res	= 16 * i;
			res	= (ref[0] / baud / res) * baud * res;

			if (res)
			{
				ref[0]	= res;
				break;
			}
		}
	}

	return(errs);
}



/******************************************************************************
*
*	Function:	osc_setup
*
*	Purpose:
*
*		Programm the oscillator to produce the requested frequency. Afterwards,
*		measute what was produced, as possible, to make sure we got it.
*
*	Arguments:
*
*		fd		The handles to access all four channels.
*
*		want	The frequency desired.
*
*		got		The frequency obtained.
*
*		loud	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int osc_setup(int fd, s32 want, s32* got, int loud)
{
	long	delta;
	int		errs;
	int		i;
	s32		meas;
	s32		prg;
	u32		use;

	for (;;)
	{
		errs	= feature_test(fd, SIO4_FEATURE_OSC_PROGRAM, &prg, loud);

		if ((errs) || (prg == SIO4_FEATURE_NO))
			break;

		errs	= feature_test(fd, SIO4_FEATURE_OSC_MEASURE, &meas, loud);

		if (errs)
			break;

		for (i = 0;; i++)
		{
			errs	= osc_program(fd, want, got, loud);

			if ((errs) || (meas == SIO4_FEATURE_NO))
				break;

			errs	= osc_measure(fd, got, loud);

			if (errs)
				break;

			delta	= labs(labs(want) - labs(got[0]));

			if (((float) delta / want) <= 0.01)
			{
				got[0]	= want;
				break;
			}

			if (i >= 100)
				break;

			errs	+= osc_init(fd, got, loud);
			use		= (want >= 100000L) ? 9999 : 1222222L;
			errs	+= osc_program(fd, use, got, loud);

			if (errs)
				break;
		}

		break;
	}

	return(errs);
}



