// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/utils/util_host.c $
// $Rev: 53094 $
// $Date: 2023-06-13 10:21:23 -0500 (Tue, 13 Jun 2023) $

// SIO4: Utilities: source file

#include "main.h"

// Useless code for the validation script.
//	if (verbose
//	if (verbose



// macros *********************************************************************

#define	ISSPACE(c)		(((c) == ' ') ? 1 : ((c) == '\t') ? 1 : 0)



//*****************************************************************************
static char* _skipws(char* psz)
{
	for (; (psz) && (ISSPACE(psz[0]));)
		psz++;

	return(psz);
}



//*****************************************************************************
static long _get_total_mb(void)
{
	char	buf[1024];
	int		end;
	char	factor	= 0;
	FILE*	file;
	int		i;
	long	total	= 0;

	file	= fopen("/proc/meminfo", "r");

	if (file)
	{
		for (;;)
		{
			end	= feof(file);

			if (end)
				break;

			fgets(buf, sizeof(buf), file);
			i	= sscanf(buf, "MemTotal: %ld %c", &total, &factor);

			if (i == 2)
				break;
		}

		fclose(file);
	}

	if (factor == 0)
	{
		total	= (total + 1023) / 1024;
		factor	= 'k';
	}

	if ((factor == 'k') || (factor == 'K'))
	{
		total	= (total + 1023) / 1024;
		factor	= 'm';
	}

	if ((factor == 't') || (factor == 'T'))
	{
		total	*= 1024;
		factor	= 'm';
	}

	if ((factor == 'g') || (factor == 'G'))
	{
		total	*= 1024;
		// factor	= 'm';
	}

	return(total);
}



//*****************************************************************************
static void _id_host_memory_physical(void)
{
	long	mb;
	long	total;

	gsc_label("Physical Memory");
	mb	= _get_total_mb();

	if (mb == 0)
	{
		printf("Unknown\n");
	}
	else if (mb <= 512)
	{
		total	= (((mb + 63) / 64) * 64);
		printf("%ld MB\n", total);
	}
	else if (mb <= 1024)
	{
		total	= (((mb + 127) / 128) * 128);
		printf("%ld MB\n", total);
	}
	else
	{
		total	= (((mb + 255) / 256) * 256);
		printf("%ld MB\n", total);
	}
}



//*****************************************************************************
static void _id_host_memory_total(void)
{
	long	total;

	gsc_label("Total Memory");
	total	= _get_total_mb();

	if (total == 0)
		printf("Unknown\n");
	else
		printf("%ld MB\n", total);
}



//*****************************************************************************
static void _id_host_os(void)
{
	struct utsname	uts;

	memset(&uts, 0, sizeof(uts));
	uname(&uts);

	gsc_label("Operating System");
	printf("%s\n", uts.sysname);
	gsc_label("Kernel");
	printf("%s\n", uts.release);
}



//*****************************************************************************
static void _id_host_processor(void)
{
	char			buf[1024];
	int				end;
	FILE*			file;
	int				i;
	int				index;
	char*			psz;
	char			tmp[1024];
	struct utsname	uts;

	memset(&uts, 0, sizeof(uts));
	uname(&uts);

	gsc_label("Processor");
	printf("%s\n", uts.machine);
	gsc_label_level_inc();

	file	= fopen("/proc/cpuinfo", "r");

	if (file)
	{
		for (;;)
		{
			end	= feof(file);

			if (end)
				break;

			fgets(buf, sizeof(buf), file);
			i	= sscanf(buf, "processor : %d", &index);

			if (i == 1)
			{
				gsc_label_level_dec();
				sprintf(buf, "Processor #%d", index);
				gsc_label(buf);
				printf("\n");
				gsc_label_level_inc();
				continue;
			}

			i	= sscanf(buf, "model name : %s", tmp);

			if (i == 1)
			{
				gsc_label("CPU Model");
				psz	= strchr(buf, ':');

				if (psz)
				{
					psz	+= 2;
					psz	= _skipws(psz);
					printf("%s", psz);
				}

				continue;
			}

			i	= sscanf(buf, "cpu MHz : %s", tmp);

			if (i == 1)
			{
				gsc_label("CPU Speed");
				printf("%s MHz\n", tmp);
				continue;
			}
		}

		fclose(file);
	}

	gsc_label_level_dec();
}



/******************************************************************************
*
*	Function:	id_host
*
*	Purpose:
*
*		Identify the operating system.
*
*	Arguments:
*
*		None.
*
*	Returned:
*
*		None.
*
******************************************************************************/

void id_host(void)
{
	gsc_label("Host");
	printf("\n");
	gsc_label_level_inc();

	_id_host_os();
	_id_host_processor();
	_id_host_memory_total();
	_id_host_memory_physical();

	gsc_label_level_dec();
}


