// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/utils/util_count.c $
// $Rev: 53094 $
// $Date: 2023-06-13 10:21:23 -0500 (Tue, 13 Jun 2023) $

// SIO4: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	count_boards
*
*	Purpose:
*
*		Count the number of installed SIO4 devices.
*
*	Arguments:
*
*		None.
*
*	Returned:
*
*		> 0		The number of devices found.
*		== 0	No devices were found.
*		< 0		The number of errors encounterred here.
*
******************************************************************************/

int count_boards(void)
{
	char		buf[1024];
	int			fd;
	const char*	key			= "boards: ";
	char*		ptr;
	int			qty			= 0;

	for (;;)	// A convenience loop.
	{
		gsc_label("Board Count");
		fd	= open("/proc/sio4", S_IRUSR);

		if (fd == -1)
		{
			qty	= -1;
			sprintf(buf, "open() on /proc/sio4, errno %d", errno);
			gsc_label_fail_text(1, 1, buf);
			break;
		}

		memset(buf, 0, sizeof(buf));
		read(fd, buf, sizeof(buf));
		buf[sizeof(buf) - 1]	= 0;
		close(fd);
		ptr	= strstr(buf, key);

		if (ptr)
		{
			ptr	+= strlen(key);
			qty	= atoi(ptr);
		}

		if (qty <= 0)
		{
			qty	= -1;
			gsc_label_fail_text(1, 1, "No boards found.");
		}
		else
		{
			printf("%d\n", qty);
		}

		break;
	}

	return(qty);
}



