// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/utils/util_close.c $
// $Rev: 53094 $
// $Date: 2023-06-13 10:21:23 -0500 (Tue, 13 Jun 2023) $

// SIO4: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	chan_close
*
*	Purpose:
*
*		Implement a close service.
*
*	Arguments:
*
*		chan	The index of the device channel to access.
*
*		fd		The file descriptor to use.
*
*		verbose	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int chan_close(int chan, int fd, int verbose)
{
	int		brd		= (chan - 1) / 4;
	char	buf[64];
	int		chn		= ((chan - 1) % 4) + 1;
	int		errs;
	int		ret;

	if (verbose)
	{
		sprintf(buf, "Closing SIO4 #%d", chan);
		gsc_label(buf);
	}

	ret		= close(fd);
	errs	= (ret < 0) ? 1 : 0;

	if (verbose)
	{
		printf(	"%s  (device %d, channel %d)\n",
				(errs == 0) ? "PASS" : "FAIL <---",
				brd,
				chn);
	}

	return(errs);
}


