// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/sync/samples/txrate/main.h $
// $Rev: 53087 $
// $Date: 2023-06-13 10:12:24 -0500 (Tue, 13 Jun 2023) $

// SIO4: SYNC Protocol Library: Sample Application: header file

#ifndef	__MAIN_H__
#define	__MAIN_H__

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <asm/types.h>
#include <sys/ioctl.h>

#include "sio4_main.h"



// macros *********************************************************************

#define	_8MHZ								(8000000L)
#define	_20MHZ								(20L * 1000 * 1000)
#define	_30MHZ								(30L * 1000 * 1000)
#define	VADDR_T								unsigned long	// driver/kernel_2_4.h
#define	SIO4_GSC_POCSR_PRG_DONE				0x00000001		// Programming is done.

#define	ERESTARTSYS							1

#define	OSC_FREQ_MAX						200000000L	// Max PLL based output from the oscillator.
#define	OSC_FREQ_MIN						8000L
#define	SIO4_FREQ_MAX						10000000L	// Max Tx Clock for the SYNC device.
#define	SIO4_FREQ_MIN						1L
#define	FREQ_REF_MAX						30000000L
#define	FREQ_REF_MIN						8000000L



// data types *****************************************************************

typedef struct _dev_data_t	dev_data_t;

#include "osc_cy22393.h"
#include "osc_cy22393_sio4.h"

typedef struct
{
	// Application Settings

	s32	begin;			// sequental scan begin
	s32	bit_rate[4];
	s32	index;			// Board number
	s32	end;			// sequential scan end
	s32	fref;			// oscillator reference frequency
	s32	init;
	s32	pd_max;			// post divider width in bits
	int	qty;			// number of boards installed
	s32	reset;
	s32	scan;			// performa sequential scan

	int	fd[4];			// File descriptor for devices to access.

	// Device Settings

} args_t;

struct _dev_data_t
{

	struct
	{
		VADDR_T				gsc_pocsr_32;	// Prog Osc Ctrl/Status Reg
		VADDR_T				gsc_porar_32;	// Prog Osc RAM Adrs Reg
		VADDR_T				gsc_pordr_32;	// Prog Osc RAM Data Reg
		VADDR_T				gsc_pord2r_32;	// Prog Osc RAM Data 2 Reg
	} vaddr;

	struct
	{
		sio4_osc_chip_t		osc_chip;
		u32					osc_pd_max;		// Maximum post divider value.
	} cache;

	union
	{
		osc_cy22393_sio4_t	cy22393;
	} osc;
};



// variables ******************************************************************

extern	u32	poscr;



// prototypes *****************************************************************

float	calc_measure(dev_data_t* dev, int chan, int verbose, long tx_hz);
int		channels_close(const args_t* args);
int		channels_open(const args_t* args, int* fd);

int		firmware_types(const args_t* args, int* skip);

u32		os_reg_mem_rx_u32(dev_data_t* dev, VADDR_T va);
void	os_reg_mem_tx_u32(dev_data_t* dev, VADDR_T va, u32 value);
int		os_time_tick_rate(void);
void	os_time_tick_sleep(int ticks);
void	os_time_us_delay(long us);
int		osc_info(dev_data_t* dev, int index, sio4_osc_t* arg);
int		osc_reset(dev_data_t* dev, int index, sio4_osc_t* arg);
int		osc_types(const args_t* args, int* skip);

int		perform_tests(const args_t* args);
void	print_long(long l);



#endif
