// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/sync/samples/syncc2c/main.h $
// $Rev: 53085 $
// $Date: 2023-06-13 10:11:43 -0500 (Tue, 13 Jun 2023) $

// SIO4: SYNC Protocol Library: Sample Application: header file

#ifndef	__MAIN_H__
#define	__MAIN_H__

#include <ctype.h>
#include <errno.h>
#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "sio4_main.h"



// data types *****************************************************************

typedef struct
{
	// Application Settings

	s32	continuous;		// > 0 = ignore errors, < 0 = stop on errors
	s32	index_rx;		// receive device index
	s32	index_tx;		// transmit device index
	s32	minute_limit;	// for continuous testing
	int	qty;			// Number of devices detected.
	s32	seconds;		// transfer data for this long
	int	skip;			// skip testing?
	s32	test_limit;		// for continuous testing

	int	fd_rx;			// File descriptor for receive device to access.
	int	fd_tx;			// File descriptor for transmit device to access.

	// Device Settings

	s32	baud;			// data transfer bit rate

} args_t;

typedef struct
{
	s32	mp;
	s32	_232;
	s32	_422;
	s32	_423;
} mp_t;



// prototypes *****************************************************************

int		channels_reset(const args_t* args);
void	connection_type(const args_t* args);

int		fifo_sizes_compute(const args_t* args, int* fifo);
int		fw_type_validate(const args_t* args, int* skip);

int		perform_tests(const args_t* args, int* skip);

int		rx_setup(const args_t* args, int lb, sio4_mp_prot_t mp);

int		tx_setup(const args_t* args, int lb, sio4_mp_prot_t mp);

int		xcvr_compute(const args_t* args, sio4_mp_prot_t* mp);



#endif
