// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/sync/lib/gpio.c $
// $Rev: 48522 $
// $Date: 2020-11-23 18:13:34 -0600 (Mon, 23 Nov 2020) $

// SIO4: SYNC Protocol Library: source file

#include "main.h"



/******************************************************************************
*
*	Function:	sio4_sync_gpio_rx
*
*	Purpose:
*
*		Read the GPIO input.
*
*	Arguments:
*
*		fd		The file rescriptor for the SIO4 to access.
*
*		value	The value read is put here. All unused bits are cleared.
*
*	Returned:
*
*		0		All went well.
*		> 0		An appropriate error status.
*
******************************************************************************/

int sio4_sync_gpio_rx(int fd, __u32* value)
{
	__u32	pstsr;
	int		ret;

	ret	= sync_reg_read(fd, SIO4_GSC_PSTSR, &pstsr);

	if ((ret == 0) && (value))
		value[0]	= pstsr & SIO4_SYNC_PSTSR_GPIO;

	return(ret);
}



/******************************************************************************
*
*	Function:	sio4_sync_gpio_tx
*
*	Purpose:
*
*		Write GPIO output. This is applied only to those signals configured as
*		GPIO. All other bits are ignored.
*
*	Arguments:
*
*		fd		The file rescriptor for the SIO4 to access.
*
*		value	The value to write.
*
*	Returned:
*
*		0		All went well.
*		> 0		An appropriate error status.
*
******************************************************************************/

int sio4_sync_gpio_tx(int fd, __u32 value)
{
	static const struct
	{
		__u32	gpio;	// If this PSRCR bit is set, then its GPIO.
		__u32	mask;	// PSRCR bits to modify.
		__u32	high;	// PSRCR bit to set for GPIO output.
		__u32	value;	// If set, then HIGH else LOW.
	} list[]	=
	{
		// Signal			gpio	mask	high	value
		{ /* Tx Clock	*/	0x0004, 0x0006, 0x0001, 0x0010	},
		{ /* Tx Data	*/	0x0100,	0x0180,	0x0040,	0x0020	},
		{ /* Tx Env		*/	0x0020,	0x0020,	0x0010,	0x0040	},
		{ /* Tx Aux Clk	*/	0x0400,	0x0400,	0x0200,	0x0080	},
		{ /* Tx Spare	*/	0x1000,	0x1000,	0x0800,	0x0200	},
		{ /* End List	*/	0,		0,		0,		0		}
	};

	int		i;
	__u32	reg;
	__u32	mask	= 0;
	int		ret;

	ret	= sync_reg_read(fd, SIO4_GSC_PSRCR, &reg);

	for (i = 0; list[i].value; i++)
	{
		if ((reg & list[i].gpio) == 0)
			continue;

		mask	|= list[i].mask | list[i].high;
		reg		= (reg & ~list[i].mask) | list[i].mask;

		if (value & list[i].value)
			reg	|= list[i].high;
		else
			reg	&= ~list[i].high;
	}

	if ((ret == 0) && (mask))
		ret	= sync_reg_mod(fd, SIO4_GSC_PSRCR, reg, mask);

	return(ret);
}



