#include <errno.h>
#include <stdio.h>

#include "sio4_sync_dsl.h"

int sio4_sync_tx_data_set(int fd, int data, int high, int verbose)
{
	sio4_sync_tx_t	tx;
	int				status;
	const char*		str	= "sio4_sync_tx_get";

	status	= sio4_sync_tx_get(fd, &tx);

	if (status == 0)
	{
		tx.data.data	= data;
		tx.data.high	= high;
		status			= sio4_sync_tx_set(fd, &tx);
		str				= "sio4_sync_tx_set";
	}

	if ((verbose) && (status == -1))
		printf("%s() failure, errno = %d\n", str, errno);

	return(status);
}
