#include <errno.h>
#include <stdio.h>

#include "sio4_sync_dsl.h"

int sio4_sync_rx_env_set(int fd, int enable, int high, int verbose)
{
	sio4_sync_rx_t	rx;
	int				status;
	const char*		str	= "sio4_sync_rx_get";

	status	= sio4_sync_rx_get(fd, &rx);

	if (status == 0)
	{
		rx.env.enable	= enable;
		rx.env.high		= high;
		status			= sio4_sync_rx_set(fd, &rx);
		str				= "sio4_sync_rx_set";
	}

	if ((verbose) && (status == -1))
		printf("%s() failure, errno = %d\n", str, errno);

	return(status);
}
