#include <errno.h>
#include <stdio.h>

#include "sio4_sync_dsl.h"

int sio4_sync_dce_set(int fd, int enable, int verbose)
{
	sio4_sync_t	sync;
	int			status;
	const char*	str	= "sio4_sync_get";

	status	= sio4_sync_get(fd, &sync);

	if (status == 0)
	{
		sync.dce_enable	= enable;
		status			= sio4_sync_set(fd, &sync);
		str				= "sio4_sync_set";
	}

	if ((verbose) && (status == -1))
		printf("%s() failure, errno = %d\n", str, errno);

	return(status);
}
