// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/tx_fifo_size.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	int	errs	= 0;
	u32	fsr;
	s32	size;
	int	status;

	errs	+= reg_read(fd, -1, 0, SIO4_GSC_FSR, &fsr);
	fsr		= SIO4_DECODE(fsr, 15, 0);
	status	= ioctl(fd, SIO4_TX_FIFO_SIZE, &size);

	if (status)
	{
		errs++;
		printf(	"FAIL <---  (%d. SIO4_TX_FIFO_SIZE: errno %d)\n",
				__LINE__,
				errno);
	}
	else if (fsr != size)
	{
		errs++;
		printf(	"FAIL <---  (%d. expect %ld, got %ld)\n",
				__LINE__,
				(long) fsr,
				(long) size);
	}

	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	return(0);
}



//*****************************************************************************
int tx_fifo_size_tests(int fd, const data_t* data)
{
	int	errs	= 0;

	gsc_label("SIO4_TX_FIFO_SIZE");

	if (data->reg_fsr)
	{
		errs	+= _service_test(fd);
		errs	+= _function_test(fd);

		if (errs == 0)
			printf("PASS\n");
	}
	else
	{
		printf("SKIPPED  (Not supported.)\n");
	}

	errs	= errs ? 1 : 0;
	return(errs);
}


