// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/tx_fifo_count.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	return(0);
}



//*****************************************************************************
static int _function_test(int fd)
{
	static const service_data_t	list_1[]	=
	{
		// service				cmd	arg	reg				mask	value
		{ SERVICE_REG_WRITE,	0,	1,	SIO4_GSC_FDR,	0,		0	},
		{ SERVICE_SLEEP_MS,		0,	1,	0,				0,		0	},
		{ SERVICE_END_LIST }
	};

	static service_data_t	list_2[]	=
	{
		// service				cmd	arg	reg				mask	value
		{ SERVICE_REG_WRITE,	0,	1,	SIO4_GSC_FDR,	0,		0	},
		{ SERVICE_SLEEP_MS,		0,	1,	0,				0,		0	},
		{ SERVICE_REG_TEST,		0,	0,	SIO4_GSC_FCR,	0xFFFF,	-1	},
		{ SERVICE_END_LIST }
	};

	s32	count;
	int	errs	= 0;
	int	i;
	int	status;

	errs	+= sio4_reset_channel(fd, 0);

	// Fill any intermediate firmware buffering. May be SYNC only.

	for (; errs == 0;)
	{
		errs	+= service_ioctl_set_reg_list(fd, list_1);
		status	= ioctl(fd, SIO4_TX_FIFO_COUNT, &count);

		if (status)
		{
			errs++;
			printf(	"FAIL <---  (%d. SIO4_TX_FIFO_COUNT: errno %d)\n",
					__LINE__,
					errno);
			break;
		}
		else if (count == 1)
		{
			break;
		}
	}

	for (i = 2; (errs == 0) && (i <= 64); i++)
	{
		list_2[2].value	= i;
		errs			+= service_ioctl_set_reg_list(fd, list_2);
		status			= ioctl(fd, SIO4_TX_FIFO_COUNT, &count);

		if (status)
		{
			errs++;
			printf(	"FAIL <---  (%d. SIO4_TX_FIFO_COUNT: errno %d)\n",
					__LINE__,
					errno);
			break;
		}
		else if (count != i)
		{
			errs++;
			printf(	"FAIL <---  (%d. SIO4_TX_FIFO_COUNT: expected %ld, got %ld)\n",
					__LINE__,
					(long) i,
					(long) count);
			break;
		}
	}

	return(errs);
}



//*****************************************************************************
int tx_fifo_count_tests(int fd, const data_t* data)
{
	int	errs	= 0;

	gsc_label("SIO4_TX_FIFO_COUNT");

	if (data->reg_fcr)
	{
		errs	+= _service_test(fd);
		errs	+= _function_test(fd);

		if (errs == 0)
			printf("PASS\n");
	}
	else
	{
		printf("SKIPPED  (Not supported.)\n");
	}

	errs	= errs ? 1 : 0;
	return(errs);
}


