// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/tx_fifo_af_config.c $
// $Rev: 43033 $
// $Date: 2018-06-22 17:41:58 -0500 (Fri, 22 Jun 2018) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _subtest(int fd, u32 value)
{
	int	errs	= 0;
	int	status;
	u32	tar;

	status	= ioctl(fd, SIO4_TX_FIFO_AF_CONFIG, (void*) &value);

	if (status)
	{
		errs++;
		printf(	"FAIL <---  (%d. SIO4_TX_FIFO_AF_CONFIG, "
				"value 0x%04lX, errno %d)\n",
				__LINE__,
				(long) value,
				errno);
	}

	errs	+= reg_read(fd, -1, 0, SIO4_GSC_TAR, &tar);

	if ((errs == 0) && (((tar & 0xFFFF0000) >> 16) != value))
	{
		errs++;
		printf(	"FAIL <---  (%d. expected 0x%04lX, got 0x%04lX)\n",
				__LINE__,
				(long) value,
				(long) ((tar & 0xFFFF0000) >> 16));
	}

	return(errs);
}



//*****************************************************************************
static int _service_test(int fd)
{
	int	errs	= 0;
	int	i;

	errs	+= sio4_reset_channel(fd, 0);

	for (i = 0; i <= 16; i++)
	{
		errs	+= _subtest(fd, 0xFFFF & (0x1 << i));
		errs	+= _subtest(fd, 0xFFFF0000 & ((0x1 << (i + 16)) ^ 0xFFFF0000));
	}

	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	return(0);
}



//*****************************************************************************
int tx_fifo_af_config_tests(int fd)
{
	int	errs	= 0;

	gsc_label("SIO4_TX_FIFO_AF_CONFIG");

	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	errs	= errs ? 1 : 0;
	return(errs);
}


