// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/tx_cable_clock_config.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	service_data_t	list[]	=
	{
		// service			cmd							arg										reg				mask	value
		{ SERVICE_BY_PTR,	SIO4_TX_CABLE_CLOCK_CONFIG, SIO4_TX_CABLE_CLOCK_CONFIG_PRG_CLK,		SIO4_GSC_PSRCR,	0x1C0,	0x000	},
		{ SERVICE_BY_PTR,	SIO4_TX_CABLE_CLOCK_CONFIG, SIO4_TX_CABLE_CLOCK_CONFIG_PRG_CLK_INV,	SIO4_GSC_PSRCR,	0x1C0,	0x040	},
		{ SERVICE_BY_PTR,	SIO4_TX_CABLE_CLOCK_CONFIG, SIO4_TX_CABLE_CLOCK_CONFIG_DRV_LOW,		SIO4_GSC_PSRCR,	0x1C0,	0x080	},
		{ SERVICE_BY_PTR,	SIO4_TX_CABLE_CLOCK_CONFIG, SIO4_TX_CABLE_CLOCK_CONFIG_DRV_HI,		SIO4_GSC_PSRCR,	0x1C0,	0x0C0	},
		{ SERVICE_BY_PTR,	SIO4_TX_CABLE_CLOCK_CONFIG, SIO4_TX_CABLE_CLOCK_CONFIG_USC_TC,		SIO4_GSC_PSRCR,	0x1C0,	0x100	},
		{ SERVICE_BY_PTR,	SIO4_TX_CABLE_CLOCK_CONFIG, SIO4_TX_CABLE_CLOCK_CONFIG_USC_RC,		SIO4_GSC_PSRCR,	0x1C0,	0x140	},
		{ SERVICE_BY_PTR,	SIO4_TX_CABLE_CLOCK_CONFIG, SIO4_TX_CABLE_CLOCK_CONFIG_CBL_RC,		SIO4_GSC_PSRCR,	0x1C0,	0x180	},
		{ SERVICE_BY_PTR,	SIO4_TX_CABLE_CLOCK_CONFIG, SIO4_TX_CABLE_CLOCK_CONFIG_CBL_RAC,		SIO4_GSC_PSRCR,	0x1C0,	0x1C0	},
		{ SERVICE_END_LIST }
	};

	int	errs	= 0;

	errs	+= sio4_reset_channel(fd, 0);
	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_set_reg_list(fd, list);
	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	return(0);
}



//*****************************************************************************
int tx_cable_clock_config_tests(int fd, const data_t* data)
{
	int	errs	= 0;

	gsc_label("SIO4_TX_CABLE_CLOCK_CONFIG");

	if ((data->fw_type == SIO4_FW_TYPE_CONFIG_Z16C30) && (data->reg_psrcr))
	{
		errs	+= _service_test(fd);
		errs	+= _function_test(fd);

		if (errs == 0)
			printf("PASS\n");
	}
	else
	{
		printf("SKIPPED  (Not supported.)\n");
	}

	errs	= errs ? 1 : 0;
	return(errs);
}


