// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/set_read_timeout.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	service_data_t	list[]	=
	{
		// service			cmd						arg	reg	mask	value
		{ SERVICE_BY_VAL,	SIO4_SET_READ_TIMEOUT,	0,	0,	0,		0	},
		{ SERVICE_END_LIST }
	};

	int	errs	= 0;
	int	i;

	errs	+= sio4_reset_channel(fd, 0);

	for (i = -1; i <= 31; i++)
	{
		list[0].arg	= 0x1 << i;
		errs		+= service_ioctl_set_reg_list(fd, list);
	}

	for (i = -1; i <= 31; i++)
	{
		list[0].arg	= 0xFFFFFFFF ^ (0x1 << i);
		errs		+= service_ioctl_set_reg_list(fd, list);
	}

	list[0].arg	= SIO4_TIMEOUT_DEFAULT;
	errs		+= service_ioctl_set_reg_list(fd, list);
	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	return(0);
}



//*****************************************************************************
int set_read_timeout_tests(int fd)
{
	int	errs	= 0;

	gsc_label("SIO4_SET_READ_TIMEOUT");

	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	errs	= errs ? 1 : 0;
	return(errs);
}


