// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/set_rcv_async_prot.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	service_data_t	list[]	=
	{
		// service			cmd							arg	reg				mask	value
		{ SERVICE_BY_VAL,	SIO4_SET_RCV_ASYNC_PROT,	0,	SIO4_USC_CMR,	0x3F,	0	},
		{ SERVICE_END_LIST }
	};

	static const struct
	{
		int	arg;
		u32	value;
	} data[]	=
	{
		// arg			value
		{ RATE_X16,		0x00	},
		{ RATE_X32,		0x10	},
		{ RATE_X64,		0x20	},
		{ LOCK_RATE,	0x30	},
		{ -1, 0 }
	};

	int					errs	= 0;
	int					i;
	RCV_ASYNC_PROTOCOL	prot;

	errs	+= sio4_reset_channel(fd, 0);

	for (i = 0; data[i].arg >= 0; i++)
	{
		memset(&prot, 0, sizeof(prot));
		prot.eRxClockRate	= (CLOCK_RATE) data[i].arg;
		list[0].arg			= (unsigned long) &prot;
		list[0].value		= data[i].value;

		errs	+= service_ioctl_set_reg_list(fd, list);
		errs	+= service_ioctl_set_reg_list(fd, list);
	}

	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	return(0);
}



//*****************************************************************************
int set_rcv_async_prot_tests(int fd, const data_t* data)
{
	int	errs	= 0;

	gsc_label("SIO4_SET_RCV_ASYNC_PROT");

	if (data->fw_type == SIO4_FW_TYPE_CONFIG_Z16C30)
	{
		errs	+= _service_test(fd);
		errs	+= _function_test(fd);

		if (errs == 0)
			printf("PASS\n");
	}
	else
	{
		printf("SKIPPED  (Not supported.)\n");
	}

	errs	= errs ? 1 : 0;
	return(errs);
}


