// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/send_channel_command.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		// service			cmd							arg							reg	mask	value
		{ SERVICE_BY_VAL,	SIO4_SEND_CHANNEL_COMMAND,	NULL_CMD,					0,	0,		0	},
		{ SERVICE_BY_VAL,	SIO4_SEND_CHANNEL_COMMAND,	RESET_HIGHEST_IUS,			0,	0,		0	},
		{ SERVICE_BY_VAL,	SIO4_SEND_CHANNEL_COMMAND,	RX_FIFO_PURGE_CMD,			0,	0,		0	},
		{ SERVICE_BY_VAL,	SIO4_SEND_CHANNEL_COMMAND,	TX_FIFO_PURGE_CMD,			0,	0,		0	},
		{ SERVICE_BY_VAL,	SIO4_SEND_CHANNEL_COMMAND,	TRIG_CHAN_LOAD_DMA_CMD,		0,	0,		0	},
		{ SERVICE_BY_VAL,	SIO4_SEND_CHANNEL_COMMAND,	RX_TX_FIFO_PURGE_CMD,		0,	0,		0	},
		{ SERVICE_BY_VAL,	SIO4_SEND_CHANNEL_COMMAND,	LOAD_RX_CHAR_CNT_CMD,		0,	0,		0	},
		{ SERVICE_BY_VAL,	SIO4_SEND_CHANNEL_COMMAND,	LOAD_TX_CHAR_CNT_CMD,		0,	0,		0	},
		{ SERVICE_BY_VAL,	SIO4_SEND_CHANNEL_COMMAND,	LOAD_RX_TX_CHAR_CNT_CMD,	0,	0,		0	},
		{ SERVICE_BY_VAL,	SIO4_SEND_CHANNEL_COMMAND,	LOAD_TC0_CMD,				0,	0,		0	},
		{ SERVICE_BY_VAL,	SIO4_SEND_CHANNEL_COMMAND,	LOAD_TC1_CMD,				0,	0,		0	},
		{ SERVICE_BY_VAL,	SIO4_SEND_CHANNEL_COMMAND,	LOAD_TC0_TC1_CMD,			0,	0,		0	},
		{ SERVICE_BY_VAL,	SIO4_SEND_CHANNEL_COMMAND,	SEL_LSB_FIRST_CMD,			0,	0,		0	},
		{ SERVICE_BY_VAL,	SIO4_SEND_CHANNEL_COMMAND,	SEL_MSB_FIRST_CMD,			0,	0,		0	},
		{ SERVICE_BY_VAL,	SIO4_SEND_CHANNEL_COMMAND,	SEL_STRAIGHT_CMD,			0,	0,		0	},
		{ SERVICE_BY_VAL,	SIO4_SEND_CHANNEL_COMMAND,	SEL_SWAPPED_CMD,			0,	0,		0	},
		{ SERVICE_BY_VAL,	SIO4_SEND_CHANNEL_COMMAND,	RX_PURGE_CMD,				0,	0,		0	},
		{ SERVICE_END_LIST }
	};

	int	errs	= 0;

	errs	+= sio4_reset_channel(fd, 0);
	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_set_reg_list(fd, list);
	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	return(0);
}



//*****************************************************************************
int send_channel_command_tests(int fd, const data_t* data)
{
	int	errs	= 0;

	gsc_label("SIO4_SEND_CHANNEL_COMMAND");

	if (data->fw_type == SIO4_FW_TYPE_CONFIG_Z16C30)
	{
		errs	+= _service_test(fd);
		errs	+= _function_test(fd);

		if (errs == 0)
			printf("PASS\n");
	}
	else
	{
		printf("SKIPPED  (Not supported.)\n");
	}

	errs	= errs ? 1 : 0;
	return(errs);
}


