// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/rxc_usc_config.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		// service			cmd						arg								reg				mask	value
		{ SERVICE_BY_PTR,	SIO4_RXC_USC_CONFIG,	SIO4_RXC_USC_CONFIG_IN_LOW,		0,				0,		0		},
		{ SERVICE_REG_TEST,	0,						0,								SIO4_GSC_PSRCR,	0x38,	0x10	},
		{ SERVICE_REG_TEST,	0,						0,								SIO4_USC_IOCR,	0x07,	0x00	},

		{ SERVICE_BY_PTR,	SIO4_RXC_USC_CONFIG,	SIO4_RXC_USC_CONFIG_IN_HI,		0,				0,		0		},
		{ SERVICE_REG_TEST,	0,						0,								SIO4_GSC_PSRCR,	0x38,	0x18	},
		{ SERVICE_REG_TEST,	0,						0,								SIO4_USC_IOCR,	0x07,	0x00	},

		{ SERVICE_BY_PTR,	SIO4_RXC_USC_CONFIG,	SIO4_RXC_USC_CONFIG_IN_PRG_CLK,	0,				0,		0		},
		{ SERVICE_REG_TEST,	0,						0,								SIO4_GSC_PSRCR,	0x38,	0x00	},
		{ SERVICE_REG_TEST,	0,						0,								SIO4_USC_IOCR,	0x07,	0x00	},

		{ SERVICE_BY_PTR,	SIO4_RXC_USC_CONFIG,	SIO4_RXC_USC_CONFIG_IN_CBL_RC,	0,				0,		0		},
		{ SERVICE_REG_TEST,	0,						0,								SIO4_GSC_PSRCR,	0x38,	0x20	},
		{ SERVICE_REG_TEST,	0,						0,								SIO4_USC_IOCR,	0x07,	0x00	},

		{ SERVICE_BY_PTR,	SIO4_RXC_USC_CONFIG,	SIO4_RXC_USC_CONFIG_OUT_TCLK,	0,				0,		0		},
		{ SERVICE_REG_TEST,	0,						0,								SIO4_GSC_PSRCR,	0x38,	0x38	},
		{ SERVICE_REG_TEST,	0,						0,								SIO4_USC_IOCR,	0x07,	0x01	},

		{ SERVICE_BY_PTR,	SIO4_RXC_USC_CONFIG,	SIO4_RXC_USC_CONFIG_OUT_TCC,	0,				0,		0		},
		{ SERVICE_REG_TEST,	0,						0,								SIO4_GSC_PSRCR,	0x38,	0x38	},
		{ SERVICE_REG_TEST,	0,						0,								SIO4_USC_IOCR,	0x07,	0x02	},

		{ SERVICE_BY_PTR,	SIO4_RXC_USC_CONFIG,	SIO4_RXC_USC_CONFIG_OUT_TCOMP,	0,				0,		0		},
		{ SERVICE_REG_TEST,	0,						0,								SIO4_GSC_PSRCR,	0x38,	0x38	},
		{ SERVICE_REG_TEST,	0,						0,								SIO4_USC_IOCR,	0x07,	0x03	},

		{ SERVICE_BY_PTR,	SIO4_RXC_USC_CONFIG,	SIO4_RXC_USC_CONFIG_OUT_BRG0,	0,				0,		0		},
		{ SERVICE_REG_TEST,	0,						0,								SIO4_GSC_PSRCR,	0x38,	0x38	},
		{ SERVICE_REG_TEST,	0,						0,								SIO4_USC_IOCR,	0x07,	0x04	},

		{ SERVICE_BY_PTR,	SIO4_RXC_USC_CONFIG,	SIO4_RXC_USC_CONFIG_OUT_BRG1,	0,				0,		0		},
		{ SERVICE_REG_TEST,	0,						0,								SIO4_GSC_PSRCR,	0x38,	0x38	},
		{ SERVICE_REG_TEST,	0,						0,								SIO4_USC_IOCR,	0x07,	0x05	},

		{ SERVICE_BY_PTR,	SIO4_RXC_USC_CONFIG,	SIO4_RXC_USC_CONFIG_OUT_CTR1,	0,				0,		0		},
		{ SERVICE_REG_TEST,	0,						0,								SIO4_GSC_PSRCR,	0x38,	0x38	},
		{ SERVICE_REG_TEST,	0,						0,								SIO4_USC_IOCR,	0x07,	0x06	},

		{ SERVICE_BY_PTR,	SIO4_RXC_USC_CONFIG,	SIO4_RXC_USC_CONFIG_OUT_DPLL,	0,				0,		0		},
		{ SERVICE_REG_TEST,	0,						0,								SIO4_GSC_PSRCR,	0x38,	0x38	},
		{ SERVICE_REG_TEST,	0,						0,								SIO4_USC_IOCR,	0x07,	0x07	},

		{ SERVICE_END_LIST }
	};

	int	errs	= 0;

	errs	+= sio4_reset_channel(fd, 0);
	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_set_reg_list(fd, list);
	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	return(0);
}



//*****************************************************************************
int rxc_usc_config_tests(int fd, const data_t* data)
{
	int	errs	= 0;

	gsc_label("SIO4_RXC_USC_CONFIG");

	if ((data->fw_type == SIO4_FW_TYPE_CONFIG_Z16C30) && (data->reg_psrcr))
	{
		errs	+= _service_test(fd);
		errs	+= _function_test(fd);

		if (errs == 0)
			printf("PASS\n");
	}
	else
	{
		printf("SKIPPED  (Not supported.)\n");
	}

	errs	= errs ? 1 : 0;
	return(errs);
}


