// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/rx_cable_config.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd, const data_t* data)
{
	#define	SHIFT(v)	((v) << (4 * data->channel))

	const service_data_t	list[]	=
	{
		// service			cmd						arg								reg				mask		value
		{ SERVICE_BY_PTR,	SIO4_RX_CABLE_CONFIG,	SIO4_RX_CABLE_CONFIG_UPPER,		0,				0,			0			},
		{ SERVICE_REG_TEST,	0,						0,								SIO4_GSC_CCR,	SHIFT(0xC),	SHIFT(0x4)	},
		{ SERVICE_REG_TEST,	0,						0,								SIO4_GSC_CSR,	0x30,		0x10		},

		{ SERVICE_BY_PTR,	SIO4_RX_CABLE_CONFIG,	SIO4_RX_CABLE_CONFIG_LOWER,		0,				0,			0			},
		{ SERVICE_REG_TEST,	0,						0,								SIO4_GSC_CCR,	SHIFT(0xC),	SHIFT(0x8)	},
		{ SERVICE_REG_TEST,	0,						0,								SIO4_GSC_CSR,	0x30,		0x20		},

		{ SERVICE_BY_PTR,	SIO4_RX_CABLE_CONFIG,	SIO4_RX_CABLE_CONFIG_DISABLE,	0,				0,			0			},
		{ SERVICE_REG_TEST,	0,						0,								SIO4_GSC_CCR,	SHIFT(0xC),	SHIFT(0x0)	},
		{ SERVICE_REG_TEST,	0,						0,								SIO4_GSC_CSR,	0x30,		0x00		},
		{ SERVICE_END_LIST }
	};

	int	errs	= 0;

	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_set_reg_list(fd, list);
	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	return(0);
}



//*****************************************************************************
int rx_cable_config_tests(int fd, const data_t* data)
{
	int	errs	= 0;

	gsc_label("SIO4_RX_CABLE_CONFIG");

	if ((data->legacy) && (data->reg_ccr))
	{
		errs	+= _service_test(fd, data);
		errs	+= _function_test(fd);

		if (errs == 0)
			printf("PASS\n");
	}
	else
	{
		printf("SKIPPED  (Not supported.)\n");
	}

	errs	= errs ? 1 : 0;
	return(errs);
}


