// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/perform.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _board_reset(const args_t* args, const data_t* data)
{
	int	errs	= 0;
	int	ret;

	gsc_label("Initialize Board");

	if (data->brd_reset)
	{
		ret		= ioctl(args->fd, SIO4_INIT_BOARD, NULL);
		errs	= (ret < 0) ? 1 : 0;
		printf("%s\n", errs ? "FAIL <---" : "PASS");
	}
	else
	{
		printf("SKIPPED  (Not supported.)\n");
	}

	return(errs);
}



//*****************************************************************************
int perform_tests(const args_t* args)
{
	data_t	data;
	int		errs	= 0;

	//=====================================================
	gsc_label("Initialize");
	printf("\n");
	gsc_label_level_inc();

	memset(&data, 0, sizeof(data_t));
	data.detail	= args->detail;

	errs	+= feature_test_query(args->fd, -1, 1, SIO4_FEATURE_BOARD_RESET, &data.brd_reset);
	errs	+= _board_reset(args, &data);

	gsc_label_level_dec();

	//=====================================================
	gsc_label("Features");
	printf("\n");
	gsc_label_level_inc();

	errs	+= sio4_fw_type_config(args->fd, -1, 1, SIO4_FW_TYPE_CONFIG_READ, &data.fw_type);
	errs	+= feature_test_query(args->fd, -1, 1, SIO4_FEATURE_COUNT, &data.feature_qty);
	errs	+= feature_test_query(args->fd, -1, 1, SIO4_FEATURE_INDEX_CHANNEL, &data.channel);
	errs	+= feature_test_query(args->fd, -1, 1, SIO4_FEATURE_IRQ_32, &data.irq_32);
	errs	+= feature_test_query(args->fd, -1, 1, SIO4_FEATURE_LEGACY_CABLE, &data.legacy);
	errs	+= feature_test_query(args->fd, -1, 1, SIO4_FEATURE_MP, &data.mp);
	errs	+= feature_test_query(args->fd, -1, 1, SIO4_FEATURE_MP_BITMAP, &data.mp_bitmap);
	errs	+= feature_test_query(args->fd, -1, 1, SIO4_FEATURE_MP_CHIP, &data.mp_chip);
	errs	+= feature_test_query(args->fd, -1, 1, SIO4_FEATURE_MP_PROGRAM, &data.mp_program);
	errs	+= feature_test_query(args->fd, -1, 1, SIO4_FEATURE_OSC_CHIP, &data.osc_chip);
	errs	+= feature_test_query(args->fd, -1, 1, SIO4_FEATURE_OSC_MEASURE, &data.osc_measure);
	errs	+= feature_test_query(args->fd, -1, 1, SIO4_FEATURE_OSC_PROGRAM, &data.osc_program);
	errs	+= feature_test_query(args->fd, -1, 1, SIO4_FEATURE_REG_CCR, &data.reg_ccr);
	errs	+= feature_test_query(args->fd, -1, 1, SIO4_FEATURE_REG_FCR, &data.reg_fcr);
	errs	+= feature_test_query(args->fd, -1, 1, SIO4_FEATURE_REG_FSR, &data.reg_fsr);
	errs	+= feature_test_query(args->fd, -1, 1, SIO4_FEATURE_REG_PSRCR, &data.reg_psrcr);
	errs	+= feature_test_query(args->fd, -1, 1, SIO4_FEATURE_RX_FIFO_FULL_CFG, &data.rx_ffcc);
	errs	+= feature_test_query(args->fd, -1, 1, SIO4_FEATURE_RX_FIFO_FULL_CFG_GLB, &data.rx_ffcg);
	errs	+= feature_test_query(args->fd, -1, 1, SIO4_FEATURE_USER_JUMPER_QTY, &data.jumper_qty);

	gsc_label_level_dec();

	//=====================================================
	gsc_label("Tests");
	printf("\n");
	gsc_label_level_inc();

	errs	+= read_register_tests				(args->fd);			// SIO4_READ_REGISTER
	errs	+= write_register_tests				(args->fd);			// SIO4_WRITE_REGISTER
	errs	+= mod_register_tests				(args->fd);			// SIO4_MOD_REGISTER
	errs	+= read_register_raw_tests			(args->fd);			// SIO4_READ_REGISTER_RAW
	errs	+= feature_test_tests				(args->fd, &data);	// SIO4_FEATURE_TEST
	errs	+= init_board_tests					(args->fd, &data);	// SIO4_INIT_BOARD
	errs	+= reset_device_tests				(args->fd, &data);	// SIO4_RESET_DEVICE
	errs	+= reset_zilog_chip_tests			(args->fd, &data);	// SIO4_RESET_ZILOG_CHIP
	errs	+= reset_channel_tests				(args->fd);			// SIO4_RESET_CHANNEL
	errs	+= reset_usc_tests					(args->fd, &data);	// SIO4_RESET_USC
	errs	+= board_jumpers_tests				(args->fd, &data);	// SIO4_BOARD_JUMPERS
	errs	+= cable_config_tests				(args->fd, &data);	// SIO4_CABLE_CONFIG
	errs	+= clear_dpll_status_tests			(args->fd, &data);	// SIO4_CLEAR_DPLL_STATUS
	errs	+= cts_cable_config_tests			(args->fd, &data);	// SIO4_CTS_CABLE_CONFIG
	errs	+= dcd_cable_config_tests			(args->fd, &data);	// SIO4_DCD_CABLE_CONFIG
	errs	+= enable_brg0_tests				(args->fd, &data);	// SIO4_ENABLE_BRG0
	errs	+= enable_brg1_tests				(args->fd, &data);	// SIO4_ENABLE_BRG1
	errs	+= get_driver_info_tests			(args->fd);			// SIO4_GET_DRIVER_INFO
	errs	+= init_channel_tests				(args->fd, &data);	// SIO4_INIT_CHANNEL
	errs	+= int_notify_tests					(args->fd, &data);	// SIO4_INT_NOTIFY
	errs	+= mp_config_tests					(args->fd, &data);	// SIO4_MP_CONFIG
	errs	+= mp_info_tests					(args->fd, &data);	// SIO4_MP_INFO
	errs	+= mp_init_tests					(args->fd, &data);	// SIO4_MP_INIT
	errs	+= mp_reset_tests					(args->fd, &data);	// SIO4_MP_RESET
	errs	+= mp_test_tests					(args->fd, &data);	// SIO4_MP_TEST
	errs	+= no_function_tests				(args->fd);			// SIO4_NO_FUNCTION
	errs	+= osc_info_tests					(args->fd, &data);	// SIO4_OSC_INFO
	errs	+= osc_init_tests					(args->fd, &data);	// SIO4_OSC_INIT
	errs	+= osc_measure_tests				(args->fd, &data);	// SIO4_OSC_MEASURE
	errs	+= osc_program_tests				(args->fd, &data);	// SIO4_OSC_PROGRAM
	errs	+= osc_reference_tests				(args->fd, &data);	// SIO4_OSC_REFERENCE
	errs	+= osc_reset_tests					(args->fd, &data);	// SIO4_OSC_RESET
	errs	+= osc_test_tests					(args->fd, &data);	// SIO4_OSC_TEST
	errs	+= read_int_status_tests			(args->fd);			// SIO4_READ_INT_STATUS
	errs	+= reset_fifo_tests					(args->fd, &data);	// SIO4_RESET_FIFO
	errs	+= rx_cable_config_tests			(args->fd, &data);	// SIO4_RX_CABLE_CONFIG
	errs	+= rx_fifo_ae_config_tests			(args->fd);			// SIO4_RX_FIFO_AE_CONFIG
	errs	+= rx_fifo_af_config_tests			(args->fd);			// SIO4_RX_FIFO_AF_CONFIG
	errs	+= rx_fifo_count_tests				(args->fd, &data);	// SIO4_RX_FIFO_COUNT
	errs	+= rx_fifo_full_cfg_chan_tests		(args->fd, &data);	// SIO4_RX_FIFO_FULL_CFG_CHAN
	errs	+= rx_fifo_full_cfg_glb_tests		(args->fd, &data);	// SIO4_RX_FIFO_FULL_CFG_GLB
	errs	+= rx_fifo_size_tests				(args->fd, &data);	// SIO4_RX_FIFO_SIZE
	errs	+= rx_io_abort_tests				(args->fd);			// SIO4_RX_IO_ABORT
	errs	+= rx_io_mode_config_tests			(args->fd);			// SIO4_RX_IO_MODE_CONFIG
	errs	+= rxc_usc_config_tests				(args->fd, &data);	// SIO4_RXC_USC_CONFIG
	errs	+= select_dpll_resync_tests			(args->fd, &data);	// SIO4_SELECT_DPLL_RESYNC
	errs	+= send_channel_command_tests		(args->fd, &data);	// SIO4_SEND_CHANNEL_COMMAND
	errs	+= set_brg0_mode_tests				(args->fd, &data);	// SIO4_SET_BRG0_MODE
	errs	+= set_brg0_source_tests			(args->fd, &data);	// SIO4_SET_BRG0_SOURCE
	errs	+= set_brg1_mode_tests				(args->fd, &data);	// SIO4_SET_BRG1_MODE
	errs	+= set_brg1_source_tests			(args->fd, &data);	// SIO4_SET_BRG1_SOURCE
	errs	+= set_ctr0_source_tests			(args->fd, &data);	// SIO4_SET_CTR0_SOURCE
	errs	+= set_ctr1_source_tests			(args->fd, &data);	// SIO4_SET_CTR1_SOURCE
	errs	+= set_dpll_divisor_tests			(args->fd, &data);	// SIO4_SET_DPLL_DIVISOR
	errs	+= set_dpll_mode_tests				(args->fd, &data);	// SIO4_SET_DPLL_MODE
	errs	+= set_dpll_source_tests			(args->fd, &data);	// SIO4_SET_DPLL_SOURCE
	errs	+= set_rcv_async_prot_tests			(args->fd, &data);	// SIO4_SET_RCV_ASYNC_PROT
	errs	+= set_rcv_hdlc_prot_tests			(args->fd, &data);	// SIO4_SET_RCV_HDLC_PROT
	errs	+= set_rcv_isochr_prot_tests		(args->fd, &data);	// SIO4_SET_RCV_ISOCHR_PROT
	errs	+= set_read_timeout_tests			(args->fd);			// SIO4_SET_READ_TIMEOUT
	errs	+= set_rx_clock_source_tests		(args->fd, &data);	// SIO4_SET_RX_CLOCK_SOURCE
	errs	+= set_sync_byte_tests				(args->fd, &data);	// SIO4_SET_SYNC_BYTE
	errs	+= set_tx_clock_source_tests		(args->fd, &data);	// SIO4_SET_TX_CLOCK_SOURCE
	errs	+= set_usc_dma_options_tests		(args->fd, &data);	// SIO4_SET_USC_DMA_OPTIONS
	errs	+= set_write_timeout_tests			(args->fd);			// SIO4_SET_WRITE_TIMEOUT
	errs	+= set_xmt_async_prot_tests			(args->fd, &data);	// SIO4_SET_XMT_ASYNC_PROT
	errs	+= set_xmt_hdlc_prot_tests			(args->fd, &data);	// SIO4_SET_XMT_HDLC_PROT
	errs	+= set_xmt_hdlc_sdlc_loop_prot_tests(args->fd, &data);	// SIO4_SET_XMT_HDLC_SDLC_LOOP_PROT
	errs	+= set_xmt_isochr_prot_tests		(args->fd, &data);	// SIO4_SET_XMT_ISOCHR_PROT
	errs	+= tx_cable_clock_config_tests		(args->fd, &data);	// SIO4_TX_CABLE_CLOCK_CONFIG
	errs	+= tx_cable_config_tests			(args->fd, &data);	// SIO4_TX_CABLE_CONFIG
	errs	+= tx_cable_data_config_tests		(args->fd, &data);	// SIO4_TX_CABLE_DATA_CONFIG
	errs	+= tx_fifo_ae_config_tests			(args->fd);			// SIO4_TX_FIFO_AE_CONFIG
	errs	+= tx_fifo_af_config_tests			(args->fd);			// SIO4_TX_FIFO_AF_CONFIG
	errs	+= tx_fifo_count_tests				(args->fd, &data);	// SIO4_TX_FIFO_COUNT
	errs	+= tx_fifo_size_tests				(args->fd, &data);	// SIO4_TX_FIFO_SIZE
	errs	+= tx_io_abort_tests				(args->fd);			// SIO4_TX_IO_ABORT
	errs	+= tx_io_mode_config_tests			(args->fd);			// SIO4_TX_IO_MODE_CONFIG
	errs	+= txc_usc_config_tests				(args->fd, &data);	// SIO4_TXC_USC_CONFIG

	gsc_label_level_dec();

	return(errs);
}


