// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/osc_info.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



// macros *********************************************************************

#define	TEST_CHIP(w,o,l)					_value_test("chip",(w),(o)->chip,(l))
#define	TEST_FREQ_GOT(w,o,l)				_value_test("freq_got",(w),(o)->freq_got,(l))
#define	TEST_FREQ_REF(w,o,l)				_value_test("freq_ref",(w),(o)->freq_ref,(l))
#define	TEST_FREQ_WANT(w,o,l)				_value_test("freq_want",(w),(o)->freq_want,(l))



//*****************************************************************************
static int _service_test(int fd)
{
	return(0);
}



//*****************************************************************************
static int _info_get(int fd, sio4_osc_t* osc, int line)
{
	int	errs	= 0;
	int	ret;

	memset(osc, 0, sizeof(osc[0]));
	ret	= sio4_ioctl(fd, SIO4_OSC_INFO, osc);

	if (ret < 0)
	{
		errs++;
		printf("FAIL <---  (%d. SIO4_OSC_INFO)\n", line);
	}

	return(errs);
}



//*****************************************************************************
static int _value_test(const char* item, u32 want, u32 got, int line)
{
	int	errs	= 0;

	if (got != want)
	{
		errs	= 1;
		printf(	"FAIL <---  (%d. %s: got %lu, expected %lu)\n",
				line,
				item,
				(long) got,
				(long) want);
	}

	return(errs);
}



//*****************************************************************************
static int _reference_set(int fd, u32 want, int line)
{
	int			errs	= 0;
	sio4_osc_t	osc;
	int			ret;

	memset(&osc, 0, sizeof(osc));
	osc.freq_ref	= want;
	ret				= sio4_ioctl(fd, SIO4_OSC_REFERENCE, &osc);

	if (ret < 0)
	{
		errs++;
		printf(	"FAIL <---  (%d. SIO4_OSC_REFERENCE)\n",
				line);
	}
	else if (osc.freq_ref != want)
	{
		errs++;
		printf(	"FAIL <---  (%d. SIO4_OSC_REFERENCE, expected %ld, got %ld)\n",
				line,
				(long) want,
				(long) osc.freq_ref);
	}

	return(errs);
}



//*****************************************************************************
static int _osc_info_reference_test(int fd, const data_t* data, s32 ref)
{
	s32			delta	= 0;
	int			errs	= 0;
	s32			freq_ref;
	s32			max		= 0;
	s32			min		= 0;
	sio4_osc_t	osc;

	errs	+= sio4_reset_channel(fd, 0);

	switch (data->osc_chip)
	{
		default:

			errs++;
			printf("FAIL <---  (%d. internal error)\n", __LINE__);
			break;

		case SIO4_OSC_CHIP_FIXED:

			min		= 1000000L;
			max		= 20000000L;
			delta	= 2000000L;
			break;

		case SIO4_OSC_CHIP_CY22393:
		case SIO4_OSC_CHIP_CY22393_2:

			min		= ref;
			max		= ref;
			delta	= 2500000L;
			break;
	}

	for (freq_ref = min; (errs == 0) && (freq_ref <= max); freq_ref += delta)
	{
		errs	+= _reference_set(fd, freq_ref, __LINE__);
		errs	+= _info_get(fd, &osc, __LINE__);
		errs	+= TEST_FREQ_REF(freq_ref, &osc, __LINE__);
		errs	+= TEST_CHIP(data->osc_chip, &osc, __LINE__);
	}

	return(errs);
}



//*****************************************************************************
static int _osc_info_reset_test(int fd, const data_t* data, s32 ref)
{
	s32			delta		= 0;
	int			errs		= 0;
	s32			freq_got	= 0;
	s32			freq_ref	= 0;
	s32			freq_want;
	s32			max			= 0;
	s32			min			= 0;
	sio4_osc_t	osc;
	int			ret;

	errs	+= sio4_reset_channel(fd, 0);

	switch (data->osc_chip)
	{
		default:

			errs++;
			printf("FAIL <---  (%d. internal error)\n", __LINE__);
			break;

		case SIO4_OSC_CHIP_FIXED:

			freq_got	= 20000000L;
			freq_ref	= 20000000L;
			min			= 1000000L;
			max			= 20000000L;
			delta		= 2000000L;
			break;

		case SIO4_OSC_CHIP_CY22393:
		case SIO4_OSC_CHIP_CY22393_2:

			freq_got	= 0;
			freq_ref	= ref;
			min			= ref;
			max			= ref;
			delta		= 2500000L;
			break;
	}

	for (freq_want = min; (errs == 0) && (freq_want <= max); freq_want += delta)
	{
		errs	+= _reference_set(fd, freq_ref, __LINE__);
		memset(&osc, 0, sizeof(osc));
		ret		= sio4_ioctl(fd, SIO4_OSC_RESET, &osc);

		if (ret < 0)
		{
			errs++;
			printf("FAIL <---  (%d. SIO4_OSC_RESET)\n", __LINE__);
			break;
		}

		errs	+= _info_get(fd, &osc, __LINE__);
		errs	+= TEST_FREQ_GOT(freq_got, &osc, __LINE__);
		errs	+= TEST_FREQ_WANT(0, &osc, __LINE__);
		errs	+= TEST_FREQ_REF(freq_ref, &osc, __LINE__);
		errs	+= TEST_CHIP(data->osc_chip, &osc, __LINE__);
	}

	return(errs);
}



//*****************************************************************************
static int _osc_info_init_test(int fd, const data_t* data, s32 ref)
{
	s32			delta		= 0;
	int			errs		= 0;
	s32			freq_ref	= 0;
	s32			freq_want;
	s32			max			= 0;
	s32			min			= 0;
	sio4_osc_t	osc;
	int			ret;

	errs	+= sio4_reset_channel(fd, 0);

	switch (data->osc_chip)
	{
		default:

			errs++;
			printf("FAIL <---  (%d. internal error)\n", __LINE__);
			break;

		case SIO4_OSC_CHIP_FIXED:

			freq_ref	= 20000000L;
			min			= 1000000L;
			max			= 20000000L;
			delta		= 2000000L;
			break;

		case SIO4_OSC_CHIP_CY22393:
		case SIO4_OSC_CHIP_CY22393_2:

			freq_ref	= ref;
			min			= ref;
			max			= ref;
			delta		= 2500000L;
			break;
	}

	for (freq_want = min; (errs == 0) && (freq_want <= max); freq_want += delta)
	{
		errs	+= _reference_set(fd, freq_ref, __LINE__);
		memset(&osc, 0, sizeof(osc));
		ret		= sio4_ioctl(fd, SIO4_OSC_INIT, &osc);

		if (ret < 0)
		{
			errs++;
			printf("FAIL <---  (%d. SIO4_OSC_INIT)\n", __LINE__);
			break;
		}

		errs	+= _info_get(fd, &osc, __LINE__);
		errs	+= TEST_FREQ_GOT(freq_ref, &osc, __LINE__);
		errs	+= TEST_FREQ_WANT(freq_ref, &osc, __LINE__);
		errs	+= TEST_FREQ_REF(freq_ref, &osc, __LINE__);
		errs	+= TEST_CHIP(data->osc_chip, &osc, __LINE__);
	}

	return(errs);
}



//*****************************************************************************
static int _osc_info_program_test(int fd, const data_t* data, s32 ref)
{
	s32			delta		= 0;
	int			errs		= 0;
	s32			freq_got	= 0;
	s32			freq_ref	= 0;
	s32			freq_want;
	s32			max			= 0;
	s32			min			= 0;
	sio4_osc_t	osc;
	int			ret;

	errs	+= sio4_reset_channel(fd, 0);

	switch (data->osc_chip)
	{
		default:

			errs++;
			printf("FAIL <---  (%d. internal error)\n", __LINE__);
			break;

		case SIO4_OSC_CHIP_CY22393:
		case SIO4_OSC_CHIP_CY22393_2:

			freq_ref	= ref;
			min			= 1000000L;
			max			= 20000000L;
			delta		= 2500000L;
			break;
	}

	for (freq_want = min; (errs == 0) && (freq_want <= max); freq_want += delta)
	{
		errs	+= _reference_set(fd, freq_ref, __LINE__);
		memset(&osc, 0, sizeof(osc));
		osc.freq_want	= freq_want;
		ret				= sio4_ioctl(fd, SIO4_OSC_PROGRAM, &osc);

		if (ret < 0)
		{
			errs++;
			printf("FAIL <---  (%d. SIO4_OSC_PROGRAM)\n", __LINE__);
			break;
		}

		errs	+= _info_get(fd, &osc, __LINE__);

		switch (data->osc_chip)
		{
			default:

				errs++;
				printf("FAIL <---  (%d. internal error)\n", __LINE__);
				break;

			case SIO4_OSC_CHIP_CY22393:
			case SIO4_OSC_CHIP_CY22393_2:

				freq_got	= freq_want;
				break;
		}

		errs	+= TEST_FREQ_GOT(freq_got, &osc, __LINE__);
		errs	+= TEST_FREQ_WANT(freq_want, &osc, __LINE__);
		errs	+= TEST_FREQ_REF(freq_ref, &osc, __LINE__);
		errs	+= TEST_CHIP(data->osc_chip, &osc, __LINE__);
	}

	return(errs);
}



//*****************************************************************************
static int _function_test(int fd, const data_t* data, s32 ref)
{
	int	errs	= 0;

	errs	+= _osc_info_reference_test(fd, data, ref);
	errs	+= _osc_info_reset_test(fd, data, ref);
	errs	+= _osc_info_init_test(fd, data, ref);

	if (data->osc_program)
		errs	+= _osc_info_program_test(fd, data, ref);

	return(errs);
}



//*****************************************************************************
int osc_info_tests(int fd, const data_t* data)
{
	int	errs	= 0;
	s32	ref		= SIO4_OSC_FREQ_REF_DEFAULT;

	gsc_label("SIO4_OSC_INFO");

	if (data->osc_measure)
		errs	+= sio4_osc_reference(fd, &ref, 0);

	if (errs == 0)
	{
		switch (data->osc_chip)
		{
			default:

				printf(	"SKIPPED  (Unrecognized oscillator option: %ld)\n",
						(long) data->osc_chip);
				break;

			case SIO4_OSC_CHIP_UNKNOWN:

				errs++;
				printf("FAIL <---  (Oscillator chip not recognized.)\n");
				break;

			case SIO4_OSC_CHIP_IDC2053B:
			case SIO4_OSC_CHIP_IDC2053B_4:

				printf("SKIPPED  (Oscillator chip not supported by test.)\n");
				break;

			case SIO4_OSC_CHIP_FIXED:
			case SIO4_OSC_CHIP_CY22393:
			case SIO4_OSC_CHIP_CY22393_2:

				errs	+= _service_test(fd);
				errs	+= _function_test(fd, data, ref);

				if (errs == 0)
					printf("PASS\n");

				break;
		}
	}

	errs	= errs ? 1 : 0;
	return(errs);
}


