// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/mp_init.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	return(0);
}



//*****************************************************************************
static int _prot_get(int fd, s32* prot)
{
	int	errs	= 0;
	u32	psrcr;
	int	status;
	u32	tmp;

	status	= sio4_reg_read(fd, SIO4_GSC_PSRCR, &psrcr);

	if (status)
	{
		errs++;
		printf(	"FAIL <---  (%d. sio4_reg_read, PSRCR, errno %d)\n",
				__LINE__,
				errno);
	}

	tmp	= (psrcr >> 24) % 0xF;

	switch (tmp)
	{
		default:

			if (errs == 0)
			{
				errs++;
				printf(	"FAIL <---  (%d. current Xcvr protocol not recognized: %ld)\n",
						__LINE__,
						(long) tmp);
			}

			prot[0]	= SIO4_MP_PROT_UNKNOWN;
			break;

		case 0x0:	prot[0]	= SIO4_MP_PROT_RS_422_485;		break;
		case 0x1:	prot[0]	= SIO4_MP_PROT_RS_423;			break;
		case 0x2:	prot[0]	= SIO4_MP_PROT_RS_232;			break;
		case 0x4:	prot[0]	= SIO4_MP_PROT_RS_530_M1;		break;
		case 0x5:	prot[0]	= SIO4_MP_PROT_RS_530_M2;		break;
		case 0x6:	prot[0]	= SIO4_MP_PROT_V35_M1;			break;
		case 0x7:	prot[0]	= SIO4_MP_PROT_V35_M2;			break;
		case 0x8:	prot[0]	= SIO4_MP_PROT_RS_422_423_MM1;	break;
		case 0x9:	prot[0]	= SIO4_MP_PROT_RS_422_423_MM2;	break;
		case 0xF:	prot[0]	= SIO4_MP_PROT_DISABLE;			break;
	}

	return(errs);
}



//*****************************************************************************
static int _sub_test(int fd, const data_t* data, s32 get)
{
	int			errs	= 0;
	int			l;
	sio4_mp_t	mp;
	int			status;

	for (l = 1; l <= 2; l++)
	{
		errs	+= sio4_reset_channel(fd, 0);
		memset(&mp, 0, sizeof(mp));
		status	= ioctl(fd, SIO4_MP_INIT, (void*) &mp);

		if (status)
		{
			errs++;
			printf("FAIL <---  (%d. ioctl: errno %d)\n", __LINE__, errno);
			break;
		}

		status	= ioctl(fd, SIO4_MP_INFO, (void*) &mp);

		if (status)
		{
			errs++;
			printf("FAIL <---  (%d. ioctl: errno %d)\n", __LINE__, errno);
			break;
		}

		if (mp.chip != data->mp_chip)
		{
			errs++;
			printf(	"FAIL <---  (%d. chip: got %ld, expected %ld)\n",
					__LINE__,
					(long) mp.chip,
					(long) data->mp_chip);
			break;
		}

		if (mp.prot_got != get)
		{
			errs++;
			printf(	"FAIL <---  (%d. prot_got: got %ld, expected %ld)\n",
					__LINE__,
					(long) mp.prot_got,
					(long) get);
			break;
		}
	}

	return(errs);
}



//*****************************************************************************
static int _function_test(int fd, const data_t* data, s32 prot)
{
	int	errs	= 0;

	errs	+= sio4_reset_channel(fd, 0);

	switch (data->mp_chip)
	{
		default:
		case SIO4_MP_CHIP_UNKNOWN:

			errs++;
			printf(	"FAIL <---  (%d. Unrecognized Xcvr option: %ld)\n",
					__LINE__,
					(long) data->mp_chip);
			break;

		case SIO4_MP_CHIP_FIXED:

			errs	+= _sub_test(fd, data, prot);
			break;

		case SIO4_MP_CHIP_SP508:

			errs	+= _sub_test(fd, data, SIO4_MP_PROT_RS_422_485);
			break;
	}

	return(errs);
}



//*****************************************************************************
int mp_init_tests(int fd, const data_t* data)
{
	int	errs	= 0;
	s32	prot	= SIO4_MP_PROT_UNKNOWN;

	gsc_label("SIO4_MP_INIT");

	if (data->mp)
		errs	+= _prot_get(fd, &prot);

	if (errs)
	{
	}
	else if (data->mp == 0)
	{
		printf("SKIPPED  (Not supported.)\n");
	}
	else if (prot < 0)
	{
		errs++;
		printf(	"FAIL <---  (%d. current Xcvr protocol not recognized: %ld)\n",
				__LINE__,
				(long) prot);
	}
	else
	{
		switch (data->mp_chip)
		{
			default:

				printf(	"SKIPPED  (Unrecognized Xcvr option: %ld)\n",
						(long) data->mp_chip);
				break;

			case SIO4_MP_CHIP_UNKNOWN:

				errs++;
				printf(	"FAIL <---  (Unsupport Xcvr test option: %ld)\n",
						(long) data->mp_chip);
				break;

			case SIO4_MP_CHIP_FIXED:
			case SIO4_MP_CHIP_SP508:

				errs	+= _service_test(fd);
				errs	+= _function_test(fd, data, prot);

				if (errs == 0)
					printf("PASS\n");

				break;
		}
	}

	errs	= errs ? 1 : 0;
	return(errs);
}


