// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/int_notify.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd, const data_t* data)
{
	#define	LOWER_SHIFT(v)	((v) << (data->channel * 4))
	#define	LOWER_MASK		LOWER_SHIFT(0xF)
	#define	UPPER_SHIFT(v)	((v) << ((data->channel * 4) + 16))
	#define	UPPER_MASK		UPPER_SHIFT(0xF)

	service_data_t	list_zilog[]	=
	{
		// service				cmd					arg								reg				mask		value
		{ SERVICE_REG_WRITE,	0,					1,								SIO4_GSC_ICR,	0,			0					},
		{ SERVICE_REG_WRITE,	0,					16,								SIO4_GSC_FDR,	0,			0					},
		{ SERVICE_SLEEP_MS,		0,					10,								0,				0,			0					},
		{ SERVICE_BY_VAL,		SIO4_INT_NOTIFY,	SIO4_INT_NOTIFY_SYNC_DETECTED,	SIO4_GSC_ICR,	LOWER_MASK,	LOWER_SHIFT(0x1)	},
		{ SERVICE_BY_VAL,		SIO4_INT_NOTIFY,	SIO4_INT_NOTIFY_TX_FIFO_AE,		SIO4_GSC_ICR,	LOWER_MASK,	LOWER_SHIFT(0x2)	},
		{ SERVICE_BY_VAL,		SIO4_INT_NOTIFY,	SIO4_INT_NOTIFY_RX_FIFO_AF,		SIO4_GSC_ICR,	LOWER_MASK,	LOWER_SHIFT(0x4)	},
		{ SERVICE_BY_VAL,		SIO4_INT_NOTIFY,	SIO4_INT_NOTIFY_USC_INTERRUPTS,	SIO4_GSC_ICR,	LOWER_MASK,	LOWER_SHIFT(0x8)	},
		{ SERVICE_BY_VAL,		SIO4_INT_NOTIFY,	0,								SIO4_GSC_ICR,	LOWER_MASK,	LOWER_SHIFT(0x0)	},
		{ SERVICE_END_LIST }
	};

	service_data_t	list_sync[]	=
	{
		// service				cmd					arg								reg				mask		value
		{ SERVICE_REG_WRITE,	0,					1,								SIO4_GSC_ICR,	0,			0					},
		{ SERVICE_BY_VAL,		SIO4_INT_NOTIFY,	SIO4_INT_NOTIFY_SYNC_DETECTED,	SIO4_GSC_ICR,	LOWER_MASK,	LOWER_SHIFT(0x1)	},
		{ SERVICE_BY_VAL,		SIO4_INT_NOTIFY,	SIO4_INT_NOTIFY_TX_FIFO_AE,		SIO4_GSC_ICR,	LOWER_MASK,	LOWER_SHIFT(0x2)	},
		{ SERVICE_BY_VAL,		SIO4_INT_NOTIFY,	SIO4_INT_NOTIFY_RX_FIFO_AF,		SIO4_GSC_ICR,	LOWER_MASK,	LOWER_SHIFT(0x4)	},
		{ SERVICE_BY_VAL,		SIO4_INT_NOTIFY,	0,								SIO4_GSC_ICR,	LOWER_MASK,	LOWER_SHIFT(0x0)	},
		{ SERVICE_END_LIST }
	};

	service_data_t	list_common[]	=
	{
		// service				cmd					arg								reg				mask		value
		{ SERVICE_REG_WRITE,	0,					1,								SIO4_GSC_ICR,	0,			0					},
		{ SERVICE_BY_VAL,		SIO4_INT_NOTIFY,	SIO4_INT_NOTIFY_TX_FIFO_E,		SIO4_GSC_ICR,	UPPER_MASK,	UPPER_SHIFT(0x1)	},
		{ SERVICE_BY_VAL,		SIO4_INT_NOTIFY,	SIO4_INT_NOTIFY_TX_FIFO_F,		SIO4_GSC_ICR,	UPPER_MASK,	UPPER_SHIFT(0x2)	},
		{ SERVICE_BY_VAL,		SIO4_INT_NOTIFY,	SIO4_INT_NOTIFY_RX_FIFO_E,		SIO4_GSC_ICR,	UPPER_MASK,	UPPER_SHIFT(0x4)	},
		{ SERVICE_BY_VAL,		SIO4_INT_NOTIFY,	SIO4_INT_NOTIFY_RX_FIFO_F,		SIO4_GSC_ICR,	UPPER_MASK,	UPPER_SHIFT(0x8)	},
		{ SERVICE_BY_VAL,		SIO4_INT_NOTIFY,	0,								SIO4_GSC_ICR,	LOWER_MASK,	LOWER_SHIFT(0x0)	},
		{ SERVICE_END_LIST }
	};

	int	errs	= 0;

	errs	+= sio4_reset_channel(fd, 0);

	if (data->fw_type == SIO4_FW_TYPE_CONFIG_SYNC)
	{
		errs	+= service_ioctl_set_reg_list(fd, list_sync);
		errs	+= service_ioctl_set_reg_list(fd, list_sync);
	}
	else
	{
		errs	+= service_ioctl_set_reg_list(fd, list_zilog);
		errs	+= service_ioctl_set_reg_list(fd, list_zilog);
	}

	if (data->irq_32)
	{
		errs	+= service_ioctl_set_reg_list(fd, list_common);
		errs	+= service_ioctl_set_reg_list(fd, list_common);
	}

	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	return(0);
}



//*****************************************************************************
int int_notify_tests(int fd, const data_t* data)
{
	int	errs	= 0;

	gsc_label("SIO4_INT_NOTIFY");

	errs	+= _service_test(fd, data);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	errs	= errs ? 1 : 0;
	return(errs);
}


