// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/init_channel.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	return(0);
}



//*****************************************************************************
static int _function_test(int fd)
{
	int				errs	= 0;
	SIO4_INIT_CHAN	init;
	int				status;

	memset(&init, 0, sizeof(init));

	init.eMode					= NORMAL;
	init.u32BaudRate			= 19200;
	init.eRxEnable				= DISABLE_IMMED;
	init.eRxDataFormat			= NRZ;
	init.eRxDataLength			= BITS8;
	init.u8RxParityEnable		= 0;
	init.eRxParityType			= EVEN_PARITY;
	init.eTxEnable				= DISABLE_IMMED;
	init.eTxDataFormat			= NRZ;
	init.eTxDataLength			= BITS8;
	init.u8TxParityEnable		= 0;
	init.eTxParityType			= EVEN_PARITY;
	init.eTxIdleLineCond		= ALL_ZEROS_IDLE;
	init.u8TxWaitOnUnderrun		= 0;
	init.u8EnableRxUpper		= 0;
	init.u8EnableRxLower		= 0;
	init.u8EnableTxUpper		= 0;
	init.u8EnableTxLower		= 0;
	init.u16TxAlmostEmpty		= 7;
	init.u16TxAlmostFull		= 7;
	init.u16RxAlmostEmpty		= 7;
	init.u16RxAlmostFull		= 7;
	init.u8EnableTxCableUpper	= 0;
	init.u8EnableTxCableLower	= 0;
	init.u8EnableRxCableUpper	= 0;
	init.u8EnableRxCableLower	= 0;

	status	= ioctl(fd, SIO4_INIT_CHANNEL, (void*) &init);

	if (status)
	{
		errs++;
		printf(	"FAIL <---  (%d. SIO4_INIT_CHANNEL, errno %d)\n",
				__LINE__,
				errno);
	}

	return(errs);
}



//*****************************************************************************
int init_channel_tests(int fd, const data_t* data)
{
	int	errs	= 0;

	gsc_label("SIO4_INIT_CHANNEL");

	if ((data->fw_type == SIO4_FW_TYPE_CONFIG_Z16C30) && (data->legacy))
	{
		errs	+= _service_test(fd);
		errs	+= _function_test(fd);

		if (errs == 0)
			printf("PASS\n");
	}
	else
	{
		printf("SKIPPED  (Not supported.)\n");
	}

	errs	= errs ? 1 : 0;
	return(errs);
}


