// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/cable_config.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd, const data_t* data)
{
	#define	CCR_MASK	(0xF << (data->channel * 4))
	#define	CCR_VAL(v)	((v) << (data->channel * 4))
	#define	CSR_MASK	(0x3C)
	#define	CSR_VAL(v)	((v) << 2)

	service_data_t	list[]	=
	{
		// service			cmd					arg								reg				mask		value
		{ SERVICE_BY_PTR,	SIO4_CABLE_CONFIG,	SIO4_CABLE_CONFIG_TXDIS_RXDIS,	0,				0,			0				},
		{ SERVICE_REG_TEST,	0,					0,								SIO4_GSC_CCR,	CCR_MASK,	CCR_VAL(0x0)	},
		{ SERVICE_REG_TEST,	0,					0,								SIO4_GSC_CSR,	CSR_MASK,	CSR_VAL(0x0)	},

		{ SERVICE_BY_PTR,	SIO4_CABLE_CONFIG,	SIO4_CABLE_CONFIG_TXDIS_RXLWR,	0,				0,			0				},
		{ SERVICE_REG_TEST,	0,					0,								SIO4_GSC_CCR,	CCR_MASK,	CCR_VAL(0x8)	},
		{ SERVICE_REG_TEST,	0,					0,								SIO4_GSC_CSR,	CSR_MASK,	CSR_VAL(0x8)	},

		{ SERVICE_BY_PTR,	SIO4_CABLE_CONFIG,	SIO4_CABLE_CONFIG_TXDIS_RXUPR,	0,				0,			0				},
		{ SERVICE_REG_TEST,	0,					0,								SIO4_GSC_CCR,	CCR_MASK,	CCR_VAL(0x4)	},
		{ SERVICE_REG_TEST,	0,					0,								SIO4_GSC_CSR,	CSR_MASK,	CSR_VAL(0x4)	},

		{ SERVICE_BY_PTR,	SIO4_CABLE_CONFIG,	SIO4_CABLE_CONFIG_TXLWR_RXDIS,	0,				0,			0				},
		{ SERVICE_REG_TEST,	0,					0,								SIO4_GSC_CCR,	CCR_MASK,	CCR_VAL(0x2)	},
		{ SERVICE_REG_TEST,	0,					0,								SIO4_GSC_CSR,	CSR_MASK,	CSR_VAL(0x2)	},

		{ SERVICE_BY_PTR,	SIO4_CABLE_CONFIG,	SIO4_CABLE_CONFIG_TXLWR_RXLWR,	0,				0,			0				},
		{ SERVICE_REG_TEST,	0,					0,								SIO4_GSC_CCR,	CCR_MASK,	CCR_VAL(0xA)	},
		{ SERVICE_REG_TEST,	0,					0,								SIO4_GSC_CSR,	CSR_MASK,	CSR_VAL(0xA)	},

		{ SERVICE_BY_PTR,	SIO4_CABLE_CONFIG,	SIO4_CABLE_CONFIG_TXLWR_RXUPR,	0,				0,			0				},
		{ SERVICE_REG_TEST,	0,					0,								SIO4_GSC_CCR,	CCR_MASK,	CCR_VAL(0x6)	},
		{ SERVICE_REG_TEST,	0,					0,								SIO4_GSC_CSR,	CSR_MASK,	CSR_VAL(0x6)	},

		{ SERVICE_BY_PTR,	SIO4_CABLE_CONFIG,	SIO4_CABLE_CONFIG_TXUPR_RXDIS,	0,				0,			0				},
		{ SERVICE_REG_TEST,	0,					0,								SIO4_GSC_CCR,	CCR_MASK,	CCR_VAL(0x1)	},
		{ SERVICE_REG_TEST,	0,					0,								SIO4_GSC_CSR,	CSR_MASK,	CSR_VAL(0x1)	},

		{ SERVICE_BY_PTR,	SIO4_CABLE_CONFIG,	SIO4_CABLE_CONFIG_TXUPR_RXLWR,	0,				0,			0				},
		{ SERVICE_REG_TEST,	0,					0,								SIO4_GSC_CCR,	CCR_MASK,	CCR_VAL(0x9)	},
		{ SERVICE_REG_TEST,	0,					0,								SIO4_GSC_CSR,	CSR_MASK,	CSR_VAL(0x9)	},

		{ SERVICE_BY_PTR,	SIO4_CABLE_CONFIG,	SIO4_CABLE_CONFIG_TXUPR_RXUPR,	0,				0,			0				},
		{ SERVICE_REG_TEST,	0,					0,								SIO4_GSC_CCR,	CCR_MASK,	CCR_VAL(0x5)	},
		{ SERVICE_REG_TEST,	0,					0,								SIO4_GSC_CSR,	CSR_MASK,	CSR_VAL(0x5)	},

		{ SERVICE_END_LIST }
	};

	int	errs	= 0;

	errs	+= sio4_reset_channel(fd, 0);
	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_set_reg_list(fd, list);
	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	return(0);
}



//*****************************************************************************
int cable_config_tests(int fd, const data_t* data)
{
	int	errs	= 0;

	gsc_label("SIO4_CABLE_CONFIG");

	if ((data->legacy) && (data->reg_ccr))
	{
		errs	+= _service_test(fd, data);
		errs	+= _function_test(fd);

		if (errs == 0)
			printf("PASS\n");
	}
	else
	{
		printf("SKIPPED  (Not supported.)\n");
	}

	errs	= errs ? 1 : 0;
	return(errs);
}


