// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/board_jumpers.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	return(0);
}



//*****************************************************************************
static int _function_test(int fd, const data_t* data, s32 jumpers)
{
	int	errs	= 0;
	u32	map;

	if (data->jumper_qty <= 0)
	{
		if (jumpers)
		{
			errs++;
			printf(	"FAIL <---  (%d. qty %ld, jumpers %ld)\n",
					__LINE__,
					(long) data->jumper_qty,
					(long) jumpers);
		}
	}
	else
	{
		map	= SIO4_ENCODE(0xFFFFFFFF, data->jumper_qty - 1, 0);
		map	^= 0xFFFFFFFF;

		if (map & jumpers)
		{
			errs++;
			printf(	"FAIL <---  (%d. invalid option: qty %ld, jumpers %ld)\n",
					__LINE__,
					(long) data->jumper_qty,
					(long) jumpers);
		}
	}

	return(errs);
}



//*****************************************************************************
int board_jumpers_tests(int fd, const data_t* data)
{
	int	errs	= 0;
	s32	jumpers;

	gsc_label("SIO4_BOARD_JUMPERS");
	errs	+= sio4_board_jumpers(fd, &jumpers, 0);

	if (errs)
	{
	}
	else if (jumpers == SIO4_BOARD_JUMPERS_UNSUPPORTED)
	{
		printf("SKIPPED  (Not supported.)\n");
	}
	else
	{
		errs	+= _service_test(fd);
		errs	+= _function_test(fd, data, jumpers);

		if (errs == 0)
			printf("PASS\n");
	}

	errs	= errs ? 1 : 0;
	return(errs);
}


