// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/regs/reg.c $
// $Rev: 53080 $
// $Date: 2023-06-13 10:08:16 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



// variables ******************************************************************

static menu_item_t	_name_list[65];	// Null terminate the list!!!
static int			_reg_id[65];
static menu_t		_reg_names;



//*****************************************************************************
static char* _trim_ws(char* str)
{
	int	i;

	if (str)
	{
		for (; (str) && (isspace(str[0]));)
			str++;

		i	= (int) strlen(str);

		for (; i > 0;)
		{
			i--;

			if (isspace(str[i]))
				str[i]	= 0;
		}
	}

	return(str);
}



//*****************************************************************************
static void _reg_mod(int fd, const char* name, int reg)
{
	char	buf[1024];
	char	c		= 0;
	int		errs;
	int		i;
	char*	psz;
	u32		value;
	long	v;

	printf("    %s\n", name);
	errs	= reg_read(fd, -1, 0, reg, &value);

	if (errs == 0)
	{
		printf("    Current Value:  %08lX\n", (long) value);
		printf("    Value To Write: ");

		// Get the user's input.
		fgets(buf, sizeof(buf), stdin);
		psz	= _trim_ws(buf);

		if ((psz[0] == '0') && (psz[1] == 'x'))
			psz	+= 2;

		i	= sscanf(psz, "%lx%c", &v, &c);

		if (i != 1)
		{
			printf("ERROR: Invalid input\n");
			errs	= 1;
		}
		else if (v != (v & 0xFFFFFFFF))
		{
			printf("ERROR: Invalid value\n");
			errs	= 1;
		}
		else
		{
			errs	= reg_write(fd, reg, v);
		}
	}

	if (errs == 0)
		errs	= reg_read(fd, -1, 0, reg, &value);

	if (errs == 0)
		printf("    Updated Value:  %08lX\n", (long) value);
}



//*****************************************************************************
void reg_mod_by_name(int fd)
{
	const gsc_reg_def_t*	def;
	int						i;
	int						index	= 0;
	const char*				name;
	int						support;

	for (i = 0;; i++)
	{
		def	= sio4_reg_get_def_index(i);

		if (def == NULL)
			break;

		if ((def->decode) && (def->ask_support))
			support	= (def->decode)(fd, 1, 0, 0);
		else
			support	= 1;

		if (support == 0)
			continue;

		name	= def->name;

		if (memcmp(name, "GSC ", 4) == 0)
			name	+= 4;

		_reg_id[index]			= def->reg;
		_name_list[index].name	= name;
		_name_list[index].func	= NULL;
		index++;
	}

	_name_list[index].name	= NULL;
	_name_list[index].func	= NULL;
	_reg_names.title		= "GSC Register List";
	_reg_names.list			= _name_list;
	i	= menu_select(&_reg_names);
	_reg_mod(fd, _name_list[i].name, _reg_id[i]);
}



//*****************************************************************************
void reg_mod_by_offset(int fd)
{
	char	buf[1024];
	char	c		= 0;
	int		i;
	char*	psz;
	int		reg;
	long	v;

	printf("Edit a register by an offset.\n");
	printf("  Enter a 4-byte aligned, hex offset from 0x00 to 0xFC: ");

	// Get the user's input.
	fgets(buf, sizeof(buf), stdin);
	psz	= _trim_ws(buf);

	if ((psz[0] == '0') && (psz[1] == 'x'))
		psz	+= 2;

	i	= sscanf(psz, "%lx%c", &v, &c);

	if (i != 1)
	{
		printf("ERROR: Invalid input\n");
	}
	else if ((v < 0) || (v > 0xFC))
	{
		printf("ERROR: The value is out of range.\n");
	}
	else if (v % 4)
	{
		printf("ERROR: The value is not 4-byte aligned.\n");
	}
	else
	{
		sprintf(buf, "Offset 0x%02lX", v);
		reg	= SIO4_GSC_ENCODE(0, 0, 0, 4, v);
		_reg_mod(fd, buf, reg);
	}
}



