// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/irq/usc_rx_abort_pe.c $
// $Rev: 53079 $
// $Date: 2023-06-13 10:07:58 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



// variables ******************************************************************

static	int	_qty;



/******************************************************************************
*
*	Function:	_irq_reset
*
*	Purpose:
*
*		Clean things up after we're done.
*
*	Arguments:
*
*		fd		The file descriptor for the channel to access.
*
*	Returned:
*
*		>= 0	The number of errors seen.
*
******************************************************************************/

static int _irq_reset(int fd)
{
	int	errs	= 0;
	int	status;

	// Reset the device.
	status	= sio4_channel_reset(fd, 0);
	errs	+= status ? 1 : 0;

	// Turn off asynchronous interrupt notification.
	errs	+= usc_notify_disable(fd);

	// Disable the interrupt.
	errs	+= GSC_INT_ALL_DISABLE(fd);
	errs	+= USC_MASTER_INT_DISABLE(fd);
	errs	+= USC_RX_STATUS_INT_DISABLE(fd);
	errs	+= USC_RX_ABORT_PE_INT_DISARM(fd);
	return(errs);
}



/******************************************************************************
*
*	Function:	_irq_setup
*
*	Purpose:
*
*		Set things up so generation of the interrupt will be detected.
*
*	Arguments:
*
*		fd		The file descriptor for the channel to access.
*
*	Returned:
*
*		>= 0	The number of errors seen.
*
******************************************************************************/

static int _irq_setup(int fd)
{
	sio4_async_t	async;
	int				errs	= 0;
	int				status;

	// Reset the device.
	status	= sio4_channel_reset(fd, 0);
	errs	+= status ? 1 : 0;

	sio4_async_t_init(&async);
	async.loopback.enable	= 1;
	async.rx.char_size	= SIO4_USC_CHAR_LENGTH_7;
	async.rx.parity_enable	= 1;
	async.rx.parity_type	= SIO4_USC_PARTYPE_EVEN;
	async.tx.char_size	= SIO4_USC_CHAR_LENGTH_7;
	async.tx.parity_enable	= 1;
	async.tx.parity_type	= SIO4_USC_PARTYPE_ODD;
	errs	+= sio4_async_config(fd, &async, 0, 0);

	// Enable the interrupt.
	errs	+= USC_RX_ABORT_PE_INT_ARM(fd);
	errs	+= USC_RX_STATUS_INT_ENABLE(fd);
	errs	+= USC_MASTER_INT_ENABLE(fd);
	errs	+= GSC_LOCAL_INT_ENABLE(fd);

	// Setup asynchronous interrupt notification.
	errs	+= USC_RX_STATUS_INT_CLEAR(fd);
	errs	+= USC_RX_ABORT_PE_STATUS_CLR(fd);
	errs	+= usc_notify_enable(fd, USC_IRQ_RX_ABORT_PE, &_qty);

	return(errs);
}



/******************************************************************************
*
*	Function:	_irq_trigger
*
*	Purpose:
*
*		Trigger the interrupt.
*
*	Arguments:
*
*		fd		The file descriptor for the channel to access.
*
*	Returned:
*
*		>= 0	The number of errors seen.
*
******************************************************************************/

static int _irq_trigger(int fd)
{
	char	buf[64];
	int		bytes	= sizeof(buf);
	int		errs;
	size_t	qty;

	memset(buf, 'a', sizeof(buf));
	errs	= sio4_write(fd, buf, bytes, &qty);

	if (qty != bytes)
		errs	= 1;

	wait_for_irq(&_qty);
	return(errs);
}



/******************************************************************************
*
*	Function:	usc_rx_abort_pe_test
*
*	Purpose:
*
*		Verify the operation of the USC xxx interrupt.
*
*	Arguments:
*
*		fd		The file descriptor for the channel to access.
*
*	Returned:
*
*		>= 0	The number of errors seen.
*
******************************************************************************/

int usc_rx_abort_pe_test(int fd)
{
	int	errs	= 0;

	gsc_label("Rx Abort/PE");
	errs	+= _irq_setup(fd);
	errs	+= _irq_trigger(fd);
	errs	+= (_qty > 0) ? 0 : 1;
	errs	+= _irq_reset(fd);
	printf("%s\n", errs ? "FAIL <---" : "PASS");
	return(errs ? 1 : 0);
}



