// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/irq/usc_dcd_down.c $
// $Rev: 43033 $
// $Date: 2018-06-22 17:41:58 -0500 (Fri, 22 Jun 2018) $

// SIO4: Sample Application: source file

#include "main.h"



// variables ******************************************************************

static	int	_qty;



/******************************************************************************
*
*	Function:	_irq_reset
*
*	Purpose:
*
*		Clean things up after we're done.
*
*	Arguments:
*
*		fd		The file descriptor for the channel to access.
*
*	Returned:
*
*		>= 0	The number of errors seen.
*
******************************************************************************/

static int _irq_reset(int fd)
{
	int	errs	= 0;
	int	status;

	// Reset the device.
	status	= sio4_channel_reset(fd, 0);
	errs	+= status ? 1 : 0;

	// Turn off asynchronous interrupt notification.
	errs	+= usc_notify_disable(fd);

	// Disable the interrupt.
	errs	+= GSC_INT_ALL_DISABLE(fd);
	errs	+= USC_MASTER_INT_DISABLE(fd);
	errs	+= USC_IOP_INT_DISABLE(fd);
	errs	+= USC_DCD_DN_INT_DISARM(fd);
	return(errs);
}



/******************************************************************************
*
*	Function:	_irq_setup
*
*	Purpose:
*
*		Set things up so generation of the interrupt will be detected.
*
*	Arguments:
*
*		fd		The file descriptor for the channel to access.
*
*	Returned:
*
*		>= 0	The number of errors seen.
*
******************************************************************************/

static int _irq_setup(int fd)
{
	int	errs	= 0;
	int	status;

	// Reset the device.
	status	= sio4_channel_reset(fd, 0);
	errs	+= status ? 1 : 0;

	errs	+= dcd_cable_config(fd, SIO4_DCD_CABLE_CONFIG_RTS_OUT, NULL, 0);
	errs	+= reg_mod(fd, SIO4_USC_IOCR, 0x0000, 0x3000);

	// Setup asynchronous interrupt notification.
	errs	+= USC_IOP_INT_CLEAR(fd);
	errs	+= USC_DCD_STATUS_CLEAR(fd);
	errs	+= usc_notify_enable(fd, USC_IRQ_DCD_DN, &_qty);

	return(errs);
}



/******************************************************************************
*
*	Function:	_irq_trigger
*
*	Purpose:
*
*		Trigger the interrupt.
*
*	Arguments:
*
*		fd		The file descriptor for the channel to access.
*
*	Returned:
*
*		>= 0	The number of errors seen.
*
******************************************************************************/

static int _irq_trigger(int fd)
{
	int	errs	= 0;

	// Enable the interrupt.
	errs	+= USC_DCD_DN_INT_ARM(fd);
	errs	+= USC_IOP_INT_ENABLE(fd);
	errs	+= USC_MASTER_INT_ENABLE(fd);
	errs	+= GSC_LOCAL_INT_ENABLE(fd);

	// Trigger the interrupt.
	errs	+= reg_mod(fd, SIO4_USC_IOCR, 0x2000, 0x3000);
	errs	+= reg_mod(fd, SIO4_USC_IOCR, 0x3000, 0x3000);
	errs	+= reg_mod(fd, SIO4_USC_IOCR, 0x2000, 0x3000);

	wait_for_irq(&_qty);
	return(errs);
}



/******************************************************************************
*
*	Function:	usc_dcd_down_test
*
*	Purpose:
*
*		Verify the operation of the USC DCD Down interrupt.
*
*	Arguments:
*
*		fd		The file descriptor for the channel to access.
*
*	Returned:
*
*		>= 0	The number of errors seen.
*
******************************************************************************/

int usc_dcd_down_test(int fd)
{
	int	errs	= 0;

	gsc_label("DCD Down");
	errs	+= _irq_setup(fd);
	errs	+= _irq_trigger(fd);
	errs	+= (_qty > 0) ? 0 : 1;
	errs	+= _irq_reset(fd);
	printf("%s\n", errs ? "FAIL <---" : "PASS");
	return(errs ? 1 : 0);
}


