// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/irq/usc_brg1_zero.c $
// $Rev: 43033 $
// $Date: 2018-06-22 17:41:58 -0500 (Fri, 22 Jun 2018) $

// SIO4: Sample Application: source file

#include "main.h"



// variables ******************************************************************

static	int	_qty;



/******************************************************************************
*
*	Function:	_irq_reset
*
*	Purpose:
*
*		Clean things up after we're done.
*
*	Arguments:
*
*		fd		The file descriptor for the channel to access.
*
*	Returned:
*
*		>= 0	The number of errors seen.
*
******************************************************************************/

static int _irq_reset(int fd)
{
	int	errs	= 0;
	int	status;

	// Reset the device.
	status	= sio4_channel_reset(fd, 0);
	errs	+= status ? 1 : 0;

	// Turn off asynchronous interrupt notification.
	errs	+= usc_notify_disable(fd);

	// Disable the interrupt.
	errs	+= GSC_INT_ALL_DISABLE(fd);
	errs	+= USC_MASTER_INT_DISABLE(fd);
	errs	+= USC_MISC_INT_DISABLE(fd);
	errs	+= USC_BRG1_ZERO_INT_DISARM(fd);
	return(errs);
}



/******************************************************************************
*
*	Function:	_irq_setup
*
*	Purpose:
*
*		Set things up so generation of the interrupt will be detected.
*
*	Arguments:
*
*		fd		The file descriptor for the channel to access.
*
*	Returned:
*
*		>= 0	The number of errors seen.
*
******************************************************************************/

static int _irq_setup(int fd)
{
	int	errs	= 0;
	s32	prog;
	int	status;

	// Reset the device.
	status	= sio4_channel_reset(fd, 0);
	errs	+= status ? 1 : 0;

	// Configure BRG1.
	status	= sio4_feature_test(fd, SIO4_FEATURE_OSC_PROGRAM, &prog, 0);
	errs	+= status ? 1 : 0;

	if (prog == SIO4_FEATURE_YES)
		errs	+= osc_program(fd, 20000000, NULL, 0);

	errs	+= reg_mod(fd, SIO4_USC_IOCR, 0x0, 0x38); // TxC = input
	status	= sio4_rxc_usc_config(fd,SIO4_TXC_USC_CONFIG_IN_PRG_CLK,NULL,0);
	errs	+= status ? 1 : 0;
	status	= sio4_brg1_enable(fd, 0, 0);
	errs	+= status ? 1 : 0;
	status	= sio4_brg1_set_mode(fd, BRG_SINGLE_CYCLE, 0);
	errs	+= status ? 1 : 0;
	status	= sio4_brg1_set_clock_source(fd, TXC_PIN_CLOCK, 0);
	errs	+= status ? 1 : 0;

	// Enable the interrupt.
	errs	+= USC_BRG1_ZERO_INT_ARM(fd);
	errs	+= USC_MISC_INT_ENABLE(fd);
	errs	+= USC_MASTER_INT_ENABLE(fd);
	errs	+= GSC_LOCAL_INT_ENABLE(fd);

	// Setup asynchronous interrupt notification.
	errs	+= USC_MISC_INT_CLEAR(fd);
	errs	+= USC_BRG1_ZERO_STATUS_CLR(fd);
	errs	+= usc_notify_enable(fd, USC_IRQ_BRG1_ZERO, &_qty);
	return(errs);
}



/******************************************************************************
*
*	Function:	_irq_trigger
*
*	Purpose:
*
*		Trigger the interrupt.
*
*	Arguments:
*
*		fd		The file descriptor for the channel to access.
*
*	Returned:
*
*		>= 0	The number of errors seen.
*
******************************************************************************/

static int _irq_trigger(int fd)
{
	int	errs	= 0;
	int	status;

	// Enable BRG1.
	status	= sio4_brg1_enable(fd, 1, 0);
	errs	+= status ? 1 : 0;
	wait_for_irq(&_qty);
	return(errs);
}



/******************************************************************************
*
*	Function:	usc_brg1_zero_test
*
*	Purpose:
*
*		Verify the operation of the USC BRG1 Zero interrupt.
*
*	Arguments:
*
*		fd		The file descriptor for the channel to access.
*
*	Returned:
*
*		>= 0	The number of errors seen.
*
******************************************************************************/

int usc_brg1_zero_test(int fd)
{
	int	errs	= 0;

	gsc_label("BRG1 Zero");
	errs	+= _irq_setup(fd);
	errs	+= _irq_trigger(fd);
	errs	+= (_qty > 0) ? 0 : 1;
	errs	+= _irq_reset(fd);
	printf("%s\n", errs ? "FAIL <---" : "PASS");
	return(errs ? 1 : 0);
}


