// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/irq/sync_detected.c $
// $Rev: 53079 $
// $Date: 2023-06-13 10:07:58 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



// variables ******************************************************************

static	int	_qty;



/******************************************************************************
*
*	Function:	_irq_reset
*
*	Purpose:
*
*		Clean things up after we're done.
*
*	Arguments:
*
*		fd		The file descriptor for the channel to access.
*
*	Returned:
*
*		>= 0	The number of errors seen.
*
******************************************************************************/

static int _irq_reset(int fd)
{
	int	errs	= 0;
	int	status;

	// Reset the device.
	status	= sio4_channel_reset(fd, 0);
	errs	+= status ? 1 : 0;

	// Turn off asynchronous interrupt notification.
	errs	+= notify_disable(fd);

	// Disable the interrupt.
	errs	+= GSC_INT_ALL_DISABLE(fd);
	return(errs);
}



/******************************************************************************
*
*	Function:	_irq_setup
*
*	Purpose:
*
*		Set things up so generation of the interrupt will be detected.
*
*	Arguments:
*
*		fd		The file descriptor for the channel to access.
*
*	Returned:
*
*		>= 0	The number of errors seen.
*
******************************************************************************/

static int _irq_setup(int fd)
{
	sio4_async_t	async;
	int				errs	= 0;
	s32				index;
	int				status;

	// Reset the device.
	status	= sio4_channel_reset(fd, 0);
	errs	+= status ? 1 : 0;

	// Setup the channel for Asynchronous loopback.
	sio4_async_t_init(&async);
	async.cable.legacy.config	= SIO4_CABLE_CONFIG_TXUPR_RXUPR;
	async.loopback.enable		= 1;
	async.loopback.internal		= 1;
	async.rx.enable				= 1;
	async.tx.enable				= 1;
	errs	+= sio4_async_config(fd, &async, 0, 0);

	// Set the Sync character.
	errs	+= reg_write(fd, SIO4_GSC_SBR, 'A');

	// Setup asynchronous interrupt notification.
	errs	+= notify_enable(fd, SIO4_INT_NOTIFY_SYNC_DETECTED, &_qty);

	// Enable the interrupt.
	errs	+= sio4_feature_test(fd, SIO4_FEATURE_INDEX_CHANNEL, &index, 0);
	errs	+= reg_write(fd, SIO4_GSC_ICR, 0x1 << (4 * index));
	return(errs);
}



/******************************************************************************
*
*	Function:	_irq_trigger
*
*	Purpose:
*
*		Trigger the interrupt.
*
*	Arguments:
*
*		fd		The file descriptor for the channel to access.
*
*	Returned:
*
*		>= 0	The number of errors seen.
*
******************************************************************************/

static int _irq_trigger(int fd)
{
	int			errs;
	const char*	psz		= "bbAbb";
	size_t		qty;
	size_t		size	= strlen(psz);

	// Write data containing the Sync Byte to the channel.
	errs	= sio4_write(fd, psz, size, &qty);

	if (qty == 5)
		wait_for_irq(&_qty);

	return(errs);
}



//*****************************************************************************
int sync_detected_test(int fd, int fw_type)
{
	int	errs	= 0;

	gsc_label("Sync Detected");

	if (fw_type == SIO4_FW_TYPE_CONFIG_Z16C30)
	{
		errs	+= _irq_setup(fd);
		errs	+= _irq_trigger(fd);
		errs	+= (_qty > 0) ? 0 : 1;
		errs	+= _irq_reset(fd);
		printf("%s\n", errs ? "FAIL <---" : "PASS");
	}
	else
	{
		printf("SKIPPED  (Not supported.)\n");
	}

	return(errs ? 1 : 0);
}



