// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/irq/perform.c $
// $Rev: 53079 $
// $Date: 2023-06-13 10:07:58 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
int perform_tests(const args_t* args)
{
	int	errs	= 0;
	s32	fw_type	= 0;
	s32	irq32	= 0;

	for (;;)	// A convenience loop.
	{
		errs	+= sio4_fw_type_config(args->fd, -1, 1, SIO4_FW_TYPE_CONFIG_READ, &fw_type);
		errs	+= feature_test_query(args->fd, -1, 1, SIO4_FEATURE_IRQ_32, &irq32);

		if (errs)
			break;

		gsc_label("Testing Interrupts");
		printf("\n");
		gsc_label_level_inc();

		errs	+= sync_detected_test(args->fd, fw_type);
		errs	+= rx_envelope_test(args->fd, fw_type);
		errs	+= tx_fifo_almost_empty_test(args->fd);
		errs	+= rx_fifo_almost_full_test(args->fd);
		errs	+= rx_spare_test(args->fd, fw_type);
		errs	+= tx_fifo_empty_test(args->fd, irq32);
		errs	+= tx_fifo_full_test(args->fd, irq32);
		errs	+= rx_fifo_empty_test(args->fd, irq32);
		errs	+= rx_fifo_full_test(args->fd, irq32);
		errs	+= usc_tests(args->fd, fw_type);

		gsc_label_level_dec();
		break;
	}

	return(errs);
}



// ****************************************************************************
void wait_for_irq(int* qty)
{
	int	i;

	for (i = 0; i < 500; i++)
	{
		if (qty[0] > 0)
			break;

		os_sleep_ms(10);
	}
}


