// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/irq/notify.c $
// $Rev: 43033 $
// $Date: 2018-06-22 17:41:58 -0500 (Fri, 22 Jun 2018) $

// SIO4: Sample Application: source file

#include "main.h"



// variables ******************************************************************

static	int		_fd;
static	u8		_flag;
static	int*	_qty;



/******************************************************************************
*
*	Function:	_handle_sigio
*
*	Purpose:
*
*		Handle a SIGIO signal.
*
*	Arguments:
*
*		signal	The signal generated, whichis SIGIO.
*
*	Returned:
*
*		None.
*
******************************************************************************/

static void _handle_sigio(int signo)
{
	SIO4_INTERRUPT_STATUS	int_stat;
	int						status;

	status	= ioctl(_fd, SIO4_READ_INT_STATUS, &int_stat);

	if ((status == 0) && (int_stat.u8SIO4Status & _flag) && (_qty))
		_qty[0]++;
}



/******************************************************************************
*
*	Function:	notify_enable
*
*	Purpose:
*
*		Enable asynchronous notification for firmware interrupts.
*
*	Arguments:
*
*		fd		The file descriptor for the channel to access.
*
*	Returned:
*
*		>= 0	The number of errors seen.
*
******************************************************************************/

int notify_enable(int fd, u8 flag, int* qty)
{
	int		errs;
	int		flags;
	pid_t	pid;
	int		status;

	ioctl(fd, SIO4_INT_NOTIFY, 0);
	_fd		= fd;
	_flag	= flag;
	_qty	= qty;
	signal(SIGIO, _handle_sigio);
	pid		= getpid();
	fcntl(fd, F_SETOWN, pid);
	flags	= fcntl(fd, F_GETFL);
	flags	|= FASYNC;
	fcntl(fd, F_SETFL, flags);
	status	= ioctl(fd, SIO4_INT_NOTIFY, flag);
	errs	= status ? 1 : 0;

	if (qty)
		qty[0]	= 0;

	return(errs);
}



/******************************************************************************
*
*	Function:	notify_disable
*
*	Purpose:
*
*		Disable asynchronous notification for firmware interrupts.
*
*	Arguments:
*
*		fd		The file descriptor for the channel to access.
*
*	Returned:
*
*		>= 0	The number of errors seen.
*
******************************************************************************/

int notify_disable(int fd)
{
	int		errs;
	int		flags;
	pid_t	pid;
	int		status;

	ioctl(fd, SIO4_INT_NOTIFY, 0);
	_fd		= 0;
	_flag	= 0;
	_qty	= NULL;
	signal(SIGIO, NULL);
	pid		= getpid();
	fcntl(fd, F_SETOWN, pid);
	flags	= fcntl(fd, F_GETFL);
	flags	&= ~FASYNC;
	fcntl(fd, F_SETFL, flags);
	status	= ioctl(fd, SIO4_INT_NOTIFY, 0);
	errs	= status ? 1 : 0;
	return(errs);
}



