// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/id/util.c $
// $Rev: 53078 $
// $Date: 2023-06-13 10:07:36 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



// macros *********************************************************************

#define	COLUMN_WIDTH	14
#define	ISEOL(c)		(((c) == '\0') || ((c) == '\n') || ((c) == '\r'))



//*****************************************************************************
int channels_close(const args_t* args)
{
	int	errs	= 0;
	int	i;
	int	ret;

	gsc_label("Closing Channels");

	for (i = 0; i <= 3; i++)
	{
		if (args->fd[i] < 0)
		{
			local_label_str("----");
			continue;
		}

		ret	= sio4_close(args->fd[i]);

		if (ret < 0)
		{
			errs++;
			local_label_str("FAIL <---");
		}
		else
		{
			local_label_str("PASS");
		}
	}

	if (errs)
		printf("FAIL <---");

	printf("\n");
	return(errs);
}



//*****************************************************************************
int channels_open(const args_t* args, int* fd)
{
	int	chan;
	int	errs	= 0;
	int	i;

	gsc_label("Opening Channels");

	for (i = 0; i <= 3; i++)
	{
		chan	= (args->index * 4) + i + 1;
		errs	= sio4_open(chan, &fd[i]);

		if (errs)
			local_label_str("FAIL <---");
		else
			local_label_str("PASS");
	}

	if (errs)
		printf("FAIL <---");

	printf("\n");
	return(errs);
}



//*****************************************************************************
void column_headings(const args_t* args)
{
	char	buf[COLUMN_WIDTH + 1];
	int		chan;
	int		i;

	// Print the column titles.
	gsc_label("Operation");

	for (i = 0; i <= 3; i++)
	{
		chan	= (args->index * 4) + i + 1;
		sprintf(buf, "Channel %i", chan);
		local_label_str(buf);
	}

	printf("\n");

	// Print the column spacers.
	gsc_label("=========");

	for (i = 0; i <= 3; i++)
		local_label_str("=========================");

	printf("\n");
}



//*****************************************************************************
int count_devices(int* qty)
{
	char	buf[512]	= "";
	char	c;
	int		count		= 0;
	int		errs		= 0;
	int		fd			= -1;
	int		j;
	int		k;
	char*	ptr;
	char*	tmp			= buf;

	for (;;)	// A convenience loop.
	{
		gsc_label("SIO4 Count");

		fd	= open("/proc/sio4", S_IRUSR);

		if (fd == -1)
		{
			errs	= 1;
			printf("FAIL <---  (open of /proc/sio4)\n");
			break;
		}

		memset(buf, 0, sizeof(buf));
		read(fd, buf, sizeof(buf));
		buf[sizeof(buf) - 1]	= 0;
		close(fd);

		// Device Count
		ptr	= strstr(buf, "boards");

		if (ptr == NULL)
		{
			errs	= 1;
			printf("FAIL <---  (/proc/sio4 content error: 'boards')\n");
			break;
		}

		// Advance to the number.
		ptr	+= 8;
		tmp	= ptr;

		// NULL terminate the string.

		for (;; ptr++)
		{
			if (ISEOL(ptr[0]))
			{
				ptr[0]	= 0;
				break;
			}
		}

		// Parse the number.
		j	= sscanf(tmp, "%d%c", &k, &c);

		if ((j == 1) && (k > 0))
			count	= k;

		printf("%d found\n", count);
		break;
	}

	if (qty)
		qty[0]	= count;

	return(errs);
}



//*****************************************************************************
void local_label_str(const char* str)
{
	char	buf[COLUMN_WIDTH + 1];
	int		len;

	memset(buf, ' ', sizeof(buf));

	if (str == NULL)
		str	= "";

	len	= strlen(str);

	if (len > COLUMN_WIDTH)
		len	= COLUMN_WIDTH;

	strncpy(buf, str, len);
	buf[COLUMN_WIDTH]		= 0;
	buf[COLUMN_WIDTH - 1]	= ' ';
	buf[COLUMN_WIDTH - 2]	= ' ';
	printf("%s", buf);
}

