// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/id/main.h $
// $Rev: 53078 $
// $Date: 2023-06-13 10:07:36 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: header file

#ifndef	__MAIN_H__
#define	__MAIN_H__

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <sys/stat.h>

#include "sio4_main.h"



// data types *****************************************************************

typedef struct
{
	// Application Settings

	s32	continuous;		// > 0 = ignore errors, < 0 = stop on errors
	s32	detail;
	s32	index;			// device index
	s32	minute_limit;	// for continuous testing
	int	qty;			// Number of devices detected.
	s32	test_limit;		// for continuous testing

	int	fd[4];			// File descriptor for four devices to access.

	// Device Settings

} args_t;



// prototypes *****************************************************************

int		channels_close	(const args_t* args);
int		channels_open	(const args_t* args, int* fd);
void	column_headings	(const args_t* args);
int		count_devices	(int* qty);

void	local_label_str	(const char* str);

int		perform_tests	(const args_t* args);



#endif
