// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/include/sio4_dsl.h $
// $Rev: 53093 $
// $Date: 2023-06-13 10:20:11 -0500 (Tue, 13 Jun 2023) $

// SIO4: Document Source Library: header file

#ifndef	__SIO4_DSL_H__
#define	__SIO4_DSL_H__

#include <fcntl.h>
#include <string.h>

#include "sio4.h"



// prototypes *****************************************************************

int sio4_async_setup(int fd);
int sio4_async_setup_rx(int fd, CLOCK_RATE rate, int verbose);
int sio4_async_setup_tx(int fd, CLOCK_RATE rate, STOP_BITS bits, int verbose);
int sio4_board_init(int fd, int verbose);
int sio4_board_jumpers(int fd, s32* get, int verbose);
int sio4_brg0_enable(int fd, int enable, int verbose);
int sio4_brg0_set_clock_source(int fd, CLOCK_SOURCE source, int verbose);
int sio4_brg0_set_mode(int fd, BRG_MODE mode, int verbose);
int sio4_brg1_enable(int fd, int enable, int verbose);
int sio4_brg1_set_clock_source(int fd, CLOCK_SOURCE source, int verbose);
int sio4_brg1_set_mode(int fd, BRG_MODE mode, int verbose);
int sio4_cable_config(int fd, s32 set, s32* get, int verbose);
int sio4_channel_init(int fd, int verbose);
int sio4_channel_reset(int fd, int verbose);
int sio4_close(int fd);
int sio4_ctr0_set_clock_source(int fd, CLOCK_SOURCE source, int verbose);
int sio4_ctr1_set_clock_source(int fd, CLOCK_SOURCE source, int verbose);
int sio4_cts_cable_config(int fd, s32 set, s32* get, int verbose);
int sio4_dcd_cable_config(int fd, s32 set, s32* get, int verbose);
int sio4_dpll_clear_status(int fd, int verbose);
int sio4_dpll_set_clock_source(int fd, CLOCK_SOURCE source, int verbose);
int sio4_dpll_set_divisor(int fd, DPLL_DIVISOR divisor, int verbose);
int sio4_dpll_set_mode(int fd, DPLL_MODE mode, int verbose);
int sio4_dpll_set_resync(int fd, DPLL_RESYNC resync, int verbose);
int sio4_driver_info_get(int fd, SIO4_DRIVER_INFO* info, int verbose);
int sio4_feature_test(int fd, s32 feature, s32* get, int verbose);
int sio4_fifo_reset(int fd, TX_RX which, int verbose);
int sio4_hdlc_sdlc_loop_setup_rx(int fd, int verbose);
int sio4_hdlc_setup_rx(int fd, int verbose);
int sio4_hdlc_setup_tx(int fd, int verbose);
int sio4_int_notify(int fd, unsigned char notify, int verbose);
int sio4_ioctl(int fd, int cmd, void* arg);
int sio4_isochr_setup_rx(int fd, int verbose);
int sio4_isochr_setup_tx(int fd, u8 two_stop_bits, int verbose);
int sio4_mp_config(int fd, s32 want, s32* got, int verbose);
int sio4_mp_info(int fd, u32* chip, s32* got, int verbose);
int sio4_mp_init(int fd, s32* got, int verbose);
int sio4_mp_reset(int fd, s32* got, int verbose);
int sio4_mp_test(int fd, s32 want, s32* got, int verbose);
int sio4_no_function(int fd, int verbose);
int sio4_open(int device, int* fd);
int sio4_osc_init(int fd, s32* freq_got, int verbose);
int sio4_osc_measure(int fd, s32* freq_got, int verbose);
int sio4_osc_program(int fd, s32 want, s32* got, int verbose);
int sio4_osc_reference(int fd, s32* freq_ref, int verbose);
int sio4_osc_reset(int fd, s32* freq_got, int verbose);
int sio4_osc_test(int fd, s32 freq_want, s32* freq_got, int verbose);
int sio4_read(int fd, void* dst, size_t bytes, size_t* qty);
int sio4_reg_mod(int fd, u32 reg, u32 value, u32 mask);
int sio4_reg_read(int fd, u32 reg, u32* value);
int sio4_reg_read_raw(int fd, u32 reg, u32* value);
int sio4_reg_write(int fd, u32 reg, u32 value);
int sio4_reset_device(int fd, int verbose);
int sio4_rx_cable_config(int fd, s32 set, s32* get, int verbose);
int sio4_rx_fifo_ae_config(int fd, s32 set, s32* get, int verbose);
int sio4_rx_fifo_af_config(int fd, s32 set, s32* get, int verbose);
int sio4_rx_fifo_count(int fd, s32* get, int verbose);
int sio4_rx_fifo_full_cfg_chan(int fd, s32 set, s32* get, int verbose);
int sio4_rx_fifo_full_cfg_glb(int fd, s32 set, s32* get, int verbose);
int sio4_rx_fifo_size(int fd, s32* get, int verbose);
int sio4_rx_io_abort(int fd, int verbose);
int sio4_rx_io_mode_config(int fd, s32 set, s32* get, int verbose);
int sio4_rx_set_clock_source(int fd, CLOCK_SOURCE source, int verbose);
int sio4_rxc_usc_config(int fd, s32 set, s32* get, int verbose);
int sio4_sync_byte_set(int fd, u8 byte, int verbose);
int sio4_timeout_set_read(int fd, u32 timeout, int verbose);
int sio4_timeout_set_write(int fd, u32 timeout, int verbose);
int sio4_tx_cable_clock_config(int fd, s32 set, s32* get, int verbose);
int sio4_tx_cable_config(int fd, s32 set, s32* get, int verbose);
int sio4_tx_cable_data_config(int fd, s32 set, s32* get, int verbose);
int sio4_tx_fifo_ae_config(int fd, s32 set, s32* get, int verbose);
int sio4_tx_fifo_af_config(int fd, s32 set, s32* get, int verbose);
int sio4_tx_fifo_count(int fd, s32* get, int verbose);
int sio4_tx_fifo_size(int fd, s32* get, int verbose);
int sio4_tx_io_abort(int fd, int verbose);
int sio4_tx_io_mode_config(int fd, s32 set, s32* get, int verbose);
int sio4_tx_set_clock_source(int fd, CLOCK_SOURCE source, int verbose);
int sio4_txc_usc_config(int fd, s32 set, s32* get, int verbose);
int sio4_usc_reset(int fd, int verbose);
int sio4_write(int fd, const void *src, size_t bytes, size_t* qty);
int sio4_zilog_reset(int fd, int verbose);

int sio4_channel_command_send(
		int						fd,
		SIO4_CHAN_CMD			command,
		int						verbose);

int sio4_dma_set_options(
		int						fd,
		STATUS_BLOCK_OPTIONS	tx_opts,
		u8						tx_wait,
		STATUS_BLOCK_OPTIONS	rx_opts,
		u8						rx_wait,
		int						verbose);

int sio4_int_read_status(
		int						fd,
		SIO4_INTERRUPT_STATUS	*int_stat,
		int						verbose);

int sio4_osc_info(
		int						fd,
		u32*					chip,
		s32*					freq_ref,
		s32*					freq_want,
		s32*					freq_got,
		int						verbose);



#endif
