// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/driver/zilog.c $
// $Rev: 53095 $
// $Date: 2023-06-13 10:42:41 -0500 (Tue, 13 Jun 2023) $

// SIO4: Device Driver: source file

#include "main.h"



/******************************************************************************
*
*	Function:	zilog_reset_ioctl
*
*	Purpose:
*
*		Implement the Zilog Reset IOCTL service.
*
*	Arguments:
*
*		chan	The structure for the channel to access.
*
*		arg		The argument passed by the application.
*
*	Returned:
*
*		0		All went well.
*		< 0		An appropriate error status.
*
******************************************************************************/

s32 zilog_reset_ioctl(chan_data_t* chan, void* arg)
{
	dev_data_t*	dev	= chan->dev;
	s32			fw_type;
	int			ret;

	ret	= fw_type_config_get(chan, &fw_type);

	if ((ret == 0) && (fw_type == SIO4_FW_TYPE_CONFIG_Z16C30))
	{
		// This auto clears and takes less than a single cycle.
		os_reg_mem_tx_u32(dev, chan->vaddr.gsc_csr_32, SIO4_GSC_CSR_ZIL_RST);

		// Write a zero to the USC Bus Configuration Register.
		os_reg_mem_tx_u8(dev, chan->vaddr.usc_bcr, 0);
	}

	return(ret);
}



