// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/driver/z1630.h $
// $Rev: 48525 $
// $Date: 2020-11-23 18:29:37 -0600 (Mon, 23 Nov 2020) $

// SIO4: Device Driver: header file

#ifndef	__Z1630_H__
#define	__Z1630_H__

#include "sio4.h"



// Zilog register field definitions.

// Z16C30: CCAR ***************************************************************

// Z16C30: CCAR.RTCmd

#define	SIO4_USC_CCAR_CMD_ENCODE(v)			SIO4_ENCODE((v), 15, 11)
#define	SIO4_USC_CCAR_CMD_DECODE(r)			SIO4_DECODE((r), 15, 11)

#define	SIO4_USC_CCAR_CMD_NONE				0x00
#define	SIO4_USC_CCAR_CMD_RESET_HI_IUS		0x02
#define	SIO4_USC_CCAR_CMD_TRG_CH_DMA		0x04
#define	SIO4_USC_CCAR_CMD_TRG_RX_DMA		0x05
#define	SIO4_USC_CCAR_CMD_TRG_TX_DMA		0x06
#define	SIO4_USC_CCAR_CMD_TRG_RX_TX_DMA		0x07
#define	SIO4_USC_CCAR_CMD_PRG_RX_FIFO		0x09
#define	SIO4_USC_CCAR_CMD_PRG_TX_FIFO		0x0A
#define	SIO4_USC_CCAR_CMD_PRG_RX_TX_FIFO	0x0B
#define	SIO4_USC_CCAR_CMD_LOAD_RCC			0x0D
#define	SIO4_USC_CCAR_CMD_LOAD_TCC			0x0E
#define	SIO4_USC_CCAR_CMD_LOAD_RCC_TCC		0x0F
#define	SIO4_USC_CCAR_CMD_LOAD_TC0			0x11
#define	SIO4_USC_CCAR_CMD_LOAD_TC1			0x12
#define	SIO4_USC_CCAR_CMD_LOAD_TC0_TC1		0x13
#define	SIO4_USC_CCAR_CMD_LSBIT_FIRST		0x14
#define	SIO4_USC_CCAR_CMD_MSBIT_FIRST		0x15
#define	SIO4_USC_CCAR_CMD_D15_8_FIRST		0x16
#define	SIO4_USC_CCAR_CMD_D7_0_FIRST		0x17
#define	SIO4_USC_CCAR_CMD_PRG_RX			0x19

// Z16C30: CCAR.RTCmd

#define	SIO4_USC_CCAR_RTRESET_ENCODE(v)		SIO4_ENCODE((v), 10, 10)
#define	SIO4_USC_CCAR_RTRESET_DECODE(r)		SIO4_DECODE((r), 10, 10)

#define	SIO4_USC_CCAR_RTRESET_YES			0x1
#define	SIO4_USC_CCAR_RTRESET_NO			0x0

// Z16C30: CCAR.RTMode

#define	SIO4_USC_CCAR_RTMODE_ENCODE(v)		SIO4_ENCODE((v), 9, 8)
#define	SIO4_USC_CCAR_RTMODE_DECODE(r)		SIO4_DECODE((r), 9, 8)

#define	SIO4_USC_CCAR_RTMODE_INT_LOC_LP		0x3
#define	SIO4_USC_CCAR_RTMODE_LOCAL_LOOP		0x2
#define	SIO4_USC_CCAR_RTMODE_LOCAL_ECHO		0x1
#define	SIO4_USC_CCAR_RTMODE_NORMAL			0x0



// Z16C30: CCR ****************************************************************

// Z16C30: CCR.TxCtrlBlk and CCR.RxStatBlk value.

#define	SIO4_USC_CCR_TXCTRLBLK_ENCODE(v)	SIO4_ENCODE((v), 15, 14)
#define	SIO4_USC_CCR_TXCTRLBLK_DECODE(r)	SIO4_DECODE((r), 15, 14)

#define	SIO4_USC_CCR_RXSTATBLK_ENCODE(v)	SIO4_ENCODE((v), 7, 6)
#define	SIO4_USC_CCR_RXSTATBLK_DECODE(r)	SIO4_DECODE((r), 7, 6)

#define	SIO4_USC_CCR_BLOCK_SIZE_NONE		0x0
#define	SIO4_USC_CCR_BLOCK_SIZE_16_BIT		0x1
#define	SIO4_USC_CCR_BLOCK_SIZE_32_BIT		0x2

// Z16C30: CCR.TxShaveL

#define	SIO4_USC_CCR_TXSHAVEL_ENCODE(v)		SIO4_ENCODE((v), 11, 8)
#define	SIO4_USC_CCR_TXSHAVEL_DECODE(r)		SIO4_DECODE((r), 11, 8)

// Z16C30: CCR.TxPreL

#define	SIO4_USC_CCR_TXPREL_ENCODE(v)		SIO4_ENCODE((v), 11, 10)
#define	SIO4_USC_CCR_TXPREL_DECODE(r)		SIO4_DECODE((r), 11, 10)

#define	SIO4_USC_CCR_TXPREL_8				0x0
#define	SIO4_USC_CCR_TXPREL_16				0x1
#define	SIO4_USC_CCR_TXPREL_32				0x2
#define	SIO4_USC_CCR_TXPREL_64				0x3

// Z16C30: CCR.TxPrePat

#define	SIO4_USC_CCR_TXPREPAT_ENCODE(v)		SIO4_ENCODE((v), 9, 8)
#define	SIO4_USC_CCR_TXPREPAT_DECODE(r)		SIO4_DECODE((r), 9, 8)

#define	SIO4_USC_CCR_TXPREPAT_0				0x0
#define	SIO4_USC_CCR_TXPREPAT_1				0x1
#define	SIO4_USC_CCR_TXPREPAT_10			0x2
#define	SIO4_USC_CCR_TXPREPAT_01			0x3



// Z16C30: CCSR ***************************************************************

// Z16C30: CCSR.DPLLEdge

#define	SIO4_USC_CCSR_DPLLEDGE_ENCODE(v)	SIO4_ENCODE((v), 9, 8)
#define	SIO4_USC_CCSR_DPLLEDGE_DECODE(r)	SIO4_DECODE((r), 9, 8)

#define	SIO4_USC_CCSR_DPLL_EDGE_UP_DN		0x0
#define	SIO4_USC_CCSR_DPLL_EDGE_UP			0x1
#define	SIO4_USC_CCSR_DPLL_EDGE_DN			0x2
#define	SIO4_USC_CCSR_DPLL_EDGE_FREE		0x3



// Z16C30: CMCR ***************************************************************

// Z16C30: CMCR.CTR1Src & CMCR.CTR0Src

#define	SIO4_USC_CMCR_CTR1SRC_ENCODE(v)		SIO4_ENCODE((v), 15, 14)
#define	SIO4_USC_CMCR_CTR1SRC_DECODE(r)		SIO4_DECODE((r), 15, 14)

#define	SIO4_USC_CMCR_CTR0SRC_ENCODE(v)		SIO4_ENCODE((v), 13, 12)
#define	SIO4_USC_CMCR_CTR0SRC_DECODE(r)		SIO4_DECODE((r), 13, 12)

#define	SIO4_USC_CMCR_CTRSRC_DISABLE		0x0
#define	SIO4_USC_CMCR_CTRSRC_RXC			0x2
#define	SIO4_USC_CMCR_CTRSRC_TXC			0x3

// Z16C30: CMCR.BRG1Src & CMCR.BRG0Src

#define	SIO4_USC_CMCR_BRG1SRC_ENCODE(v)		SIO4_ENCODE((v), 11, 10)
#define	SIO4_USC_CMCR_BRG1SRC_DECODE(r)		SIO4_DECODE((r), 11, 10)

#define	SIO4_USC_CMCR_BRG0SRC_ENCODE(v)		SIO4_ENCODE((v), 9, 8)
#define	SIO4_USC_CMCR_BRG0SRC_DECODE(r)		SIO4_DECODE((r), 9, 8)

#define	SIO4_USC_CMCR_BRGSRC_CTR0			0x0
#define	SIO4_USC_CMCR_BRGSRC_CTR1			0x1
#define	SIO4_USC_CMCR_BRGSRC_RXC			0x2
#define	SIO4_USC_CMCR_BRGSRC_TXC			0x3

// Z16C30: CMCR.DPLLSrc

#define	SIO4_USC_CMCR_DPLLSRC_ENCODE(v)		SIO4_ENCODE((v), 7, 6)
#define	SIO4_USC_CMCR_DPLLSRC_DECODE(r)		SIO4_DECODE((r), 7, 6)

#define	SIO4_USC_CMCR_DPLLSRC_BRG0			0x0
#define	SIO4_USC_CMCR_DPLLSRC_BRG1			0x1
#define	SIO4_USC_CMCR_DPLLSRC_RXC			0x2
#define	SIO4_USC_CMCR_DPLLSRC_TXC			0x3

// Z16C30: CMCR.TxClkSrc & CMCR.RxClkSrc

#define	SIO4_USC_CMCR_TXCLKSRC_ENCODE(v)	SIO4_ENCODE((v), 5, 3)
#define	SIO4_USC_CMCR_TXCLKSRC_DECODE(r)	SIO4_DECODE((r), 5, 3)

#define	SIO4_USC_CMCR_RXCLKSRC_ENCODE(v)	SIO4_ENCODE((v), 2, 0)
#define	SIO4_USC_CMCR_RXCLKSRC_DECODE(r)	SIO4_DECODE((r), 2, 0)

#define	SIO4_USC_CMCR_CLKSRC_DISABLE		0x0
#define	SIO4_USC_CMCR_CLKSRC_RXC			0x1
#define	SIO4_USC_CMCR_CLKSRC_TXC			0x2
#define	SIO4_USC_CMCR_CLKSRC_DPLL			0x3
#define	SIO4_USC_CMCR_CLKSRC_BRG0			0x4
#define	SIO4_USC_CMCR_CLKSRC_BRG1			0x5
#define	SIO4_USC_CMCR_CLKSRC_CTR0			0x6
#define	SIO4_USC_CMCR_CLKSRC_CTR1			0x7



// Z16C30: CMR ****************************************************************

// Z16C30: CMR.TxMode & CMR.RxMode

#define	SIO4_USC_CMR_TXMODE_ENCODE(v)		SIO4_ENCODE((v), 11, 8)
#define	SIO4_USC_CMR_TXMODE_DECODE(r)		SIO4_DECODE((r), 11, 8)

#define	SIO4_USC_CMR_RXMODE_ENCODE(v)		SIO4_ENCODE((v), 3, 0)
#define	SIO4_USC_CMR_RXMODE_DECODE(r)		SIO4_DECODE((r), 3, 0)

#define	SIO4_USC_CMR_MODE_ASYNC				0x0
#define	SIO4_USC_CMR_MODE_EXTERN_SYNC		0x1
#define	SIO4_USC_CMR_MODE_ISOCHR			0x2
#define	SIO4_USC_CMR_MODE_ASYNC_CV			0x3
#define	SIO4_USC_CMR_MODE_MONOSYNC			0x4
#define	SIO4_USC_CMR_MODE_BISYNC			0x5
#define	SIO4_USC_CMR_MODE_HDLC_SDLC			0x6
#define	SIO4_USC_CMR_MODE_TRANS_BISYNC		0x7
#define	SIO4_USC_CMR_MODE_NINE_BIT			0x8
#define	SIO4_USC_CMR_MODE_ETH_802_3			0x9
#define	SIO4_USC_CMR_MODE_SLAV_MONOSYNC		0xC
#define	SIO4_USC_CMR_MODE_HDLC_SDLC_LOOP	0xE

// Z16C30: CMR.Async.Tx.StopBits

#define	SIO4_USC_CMR_AT_STOPBITS_ENCODE(v)	SIO4_ENCODE((v), 15, 14)
#define	SIO4_USC_CMR_AT_STOPBITS_DECODE(r)	SIO4_DECODE((r), 15, 14)

#define	SIO4_USC_CMR_AT_STOPBITS_1			0x0
#define	SIO4_USC_CMR_AT_STOPBITS_2			0x1
#define	SIO4_USC_CMR_AT_STOPBITS_1_SHV		0x2
#define	SIO4_USC_CMR_AT_STOPBITS_2_SHV		0x3

#define	SIO4_USC_CMR_AT_STOPBITS_TO_BITS(m)	(((m) & 0x1) ? 2 : 1)

// Z16C30: CMR.Async.Tx.CLKsPerBit & CMR.Async.Rx.CLKsPerBit

#define	SIO4_USC_CMR_AT_CLKBIT_ENCODE(v)	SIO4_ENCODE((v), 13, 12)
#define	SIO4_USC_CMR_AT_CLKBIT_DECODE(r)	SIO4_DECODE((r), 13, 12)

#define	SIO4_USC_CMR_AR_CLKBIT_ENCODE(v)	SIO4_ENCODE((v), 5, 4)
#define	SIO4_USC_CMR_AR_CLKBIT_DECODE(r)	SIO4_DECODE((r), 5, 4)

#define	SIO4_USC_CMR_A_CLKBIT_16			0x0
#define	SIO4_USC_CMR_A_CLKBIT_32			0x1
#define	SIO4_USC_CMR_A_CLKBIT_64			0x2

// Z16C30: CMR.Monosync.Tx.Send CRC on Tx Underrun

#define	SIO4_USC_CMR_MST_TXCRC_ENCODE(v)	SIO4_ENCODE((v), 15, 15)
#define	SIO4_USC_CMR_MST_TXCRC_DECODE(r)	SIO4_DECODE((r), 15, 15)

// Z16C30: CMR.Monosync.Tx.send Preamble before opening Sync

#define	SIO4_USC_CMR_MST_TXPRE_ENCODE(v)	SIO4_ENCODE((v), 13, 13)
#define	SIO4_USC_CMR_MST_TXPRE_DECODE(r)	SIO4_DECODE((r), 13, 13)

// Z16C30: CMR.Monosync.Tx.Sync Size & CMR.Monosync.Rx.Sync Size

#define	SIO4_USC_CMR_MST_SSIZE_ENCODE(v)	SIO4_ENCODE((v), 12, 12)
#define	SIO4_USC_CMR_MST_SSIZE_DECODE(r)	SIO4_DECODE((r), 12, 12)

#define	SIO4_USC_CMR_MSR_SSIZE_ENCODE(v)	SIO4_ENCODE((v), 4, 4)
#define	SIO4_USC_CMR_MSR_SSIZE_DECODE(r)	SIO4_DECODE((r), 4, 4)

#define	SIO4_USC_CMR_MS_SSIZE_8				0x0
#define	SIO4_USC_CMR_MS_SSIZE_RXTXLEN		0x1

// Z16C30: CMR.Monosync.Rx.Sync Char Action

#define	SIO4_USC_CMR_MSR_SCACT_ENCODE(v)	SIO4_ENCODE((v), 5, 5)
#define	SIO4_USC_CMR_MSR_SCACT_DECODE(r)	SIO4_DECODE((r), 5, 5)

#define	SIO4_USC_CMR_MSR_SCACT_KEEP			0x0
#define	SIO4_USC_CMR_MSR_SCACT_TOSS			0x1



// Z16C30: HCR ****************************************************************

// Z16C30: HCR.CTR0Div

#define	SIO4_USC_HCR_CTR0DIV_ENCODE(v)		SIO4_ENCODE((v), 15, 14)
#define	SIO4_USC_HCR_CTR0DIV_DECODE(r)		SIO4_DECODE((r), 15, 14)

#define	SIO4_USC_HCR_CTR0DIV_32				0x0
#define	SIO4_USC_HCR_CTR0DIV_16				0x1
#define	SIO4_USC_HCR_CTR0DIV_8				0x2
#define	SIO4_USC_HCR_CTR0DIV_4				0x3

// Z16C30: HCR.CTR1DSel

#define	SIO4_USC_HCR_CTR1DSEL_ENCODE(v)		SIO4_ENCODE((v), 13, 13)
#define	SIO4_USC_HCR_CTR1DSEL_DECODE(r)		SIO4_DECODE((r), 13, 13)

#define	SIO4_USC_HCR_CTR1DSEL_CTR0DIV		0x0
#define	SIO4_USC_HCR_CTR1DSEL_DPLLDIV		0x1

// Z16C30: HCR.DPLLDiv

#define	SIO4_USC_HCR_DPLLDIV_ENCODE(v)		SIO4_ENCODE((v), 11, 10)
#define	SIO4_USC_HCR_DPLLDIV_DECODE(r)		SIO4_DECODE((r), 11, 10)

#define	SIO4_USC_HCR_DPLLDIV_32				0x0
#define	SIO4_USC_HCR_DPLLDIV_16				0x1
#define	SIO4_USC_HCR_DPLLDIV_8				0x2
#define	SIO4_USC_HCR_DPLLDIV_4				0x3 // See Zilog manual!!!

// Z16C30: HCR.DPLLMode

#define	SIO4_USC_HCR_DPLLMODE_ENCODE(v)		SIO4_ENCODE((v), 9, 8)
#define	SIO4_USC_HCR_DPLLMODE_DECODE(r)		SIO4_DECODE((r), 9, 8)

#define	SIO4_USC_HCR_DPLLMODE_DISABLE		0x0
#define	SIO4_USC_HCR_DPLLMODE_NRZ			0x1
#define	SIO4_USC_HCR_DPLLMODE_BIPH_MS		0x2
#define	SIO4_USC_HCR_DPLLMODE_BIPH_L		0x3

// Z16C30: HCR.TxAMode & HCR.TxAMode

#define	SIO4_USC_HCR_TXAMODE_ENCODE(v)		SIO4_ENCODE((v), 7, 6)
#define	SIO4_USC_HCR_TXAMODE_DECODE(r)		SIO4_DECODE((r), 7, 6)

#define	SIO4_USC_HCR_RXAMODE_ENCODE(v)		SIO4_ENCODE((v), 3, 2)
#define	SIO4_USC_HCR_RXAMODE_DECODE(r)		SIO4_DECODE((r), 3, 2)

#define	SIO4_USC_HCR_AMODE_GPIO				0x0
#define	SIO4_USC_HCR_AMODE_DMA_ACK			0x1
#define	SIO4_USC_HCR_AMODE_LOW				0x2
#define	SIO4_USC_HCR_AMODE_HI				0x3

// Z16C30: HCR.BRG1S & HCR.BRG0S

#define	SIO4_USC_HCR_BRG1S_ENCODE(v)		SIO4_ENCODE((v), 5, 5)
#define	SIO4_USC_HCR_BRG1S_DECODE(r)		SIO4_DECODE((r), 5, 5)

#define	SIO4_USC_HCR_BRG0S_ENCODE(v)		SIO4_ENCODE((v), 1, 1)
#define	SIO4_USC_HCR_BRG0S_DECODE(r)		SIO4_DECODE((r), 1, 1)

#define	SIO4_USC_HCR_BRGS_CONTINUOUS		0x0
#define	SIO4_USC_HCR_BRGS_SINGLE			0x1

// Z16C30: HCR.BRG1E & HCR.BRG0E

#define	SIO4_USC_HCR_BRG1E_ENCODE(v)		SIO4_ENCODE((v), 4, 4)
#define	SIO4_USC_HCR_BRG1E_DECODE(r)		SIO4_DECODE((r), 4, 4)

#define	SIO4_USC_HCR_BRG0E_ENCODE(v)		SIO4_ENCODE((v), 0, 0)
#define	SIO4_USC_HCR_BRG0E_DECODE(r)		SIO4_DECODE((r), 0, 0)



// Z16C30: IOCR ***************************************************************

// Z16C30: IOCR.CTSMode

#define	SIO4_USC_IOCR_CTSMODE_ENCODE(v)		SIO4_ENCODE((v), 15, 14)
#define	SIO4_USC_IOCR_CTSMODE_DECODE(r)		SIO4_DECODE((r), 15, 14)

#define	SIO4_USC_IOCR_CTSMODE_INPUT			0x0
#define	SIO4_USC_IOCR_CTSMODE_LOW			0x2
#define	SIO4_USC_IOCR_CTSMODE_HIGH			0x3

// Z16C30: IOCR.DCDMode

#define	SIO4_USC_IOCR_DCDMODE_ENCODE(v)		SIO4_ENCODE((v), 13, 12)
#define	SIO4_USC_IOCR_DCDMODE_DECODE(r)		SIO4_DECODE((r), 13, 12)

#define	SIO4_USC_IOCR_DCDMODE_DCD			0x0
#define	SIO4_USC_IOCR_DCDMODE_SYNC			0x1
#define	SIO4_USC_IOCR_DCDMODE_LOW			0x2
#define	SIO4_USC_IOCR_DCDMODE_HIGH			0x3

// Z16C30: IOCR.TxRMode & IOCR.RxRMode

#define	SIO4_USC_IOCR_TXRMODE_ENCODE(v)		SIO4_ENCODE((v), 11, 10)
#define	SIO4_USC_IOCR_TXRMODE_DECODE(r)		SIO4_DECODE((r), 11, 10)

#define	SIO4_USC_IOCR_RXRMODE_ENCODE(v)		SIO4_ENCODE((v), 9, 8)
#define	SIO4_USC_IOCR_RXRMODE_DECODE(r)		SIO4_DECODE((r), 9, 8)

#define	SIO4_USC_IOCR_REQMODE_INPUT			0x0
#define	SIO4_USC_IOCR_REQMODE_DMA			0x1
#define	SIO4_USC_IOCR_REQMODE_LOW			0x2
#define	SIO4_USC_IOCR_REQMODE_HIGH			0x3

// Z16C30: IOCR.TxDMode

#define	SIO4_USC_IOCR_TXDMODE_ENCODE(v)		SIO4_ENCODE((v), 7, 6)
#define	SIO4_USC_IOCR_TXDMODE_DECODE(r)		SIO4_DECODE((r), 7, 6)

#define	SIO4_USC_IOCR_TXDMODE_OUTPUT		0x0
#define	SIO4_USC_IOCR_TXDMODE_HI_Z			0x1
#define	SIO4_USC_IOCR_TXDMODE_LOW			0x2
#define	SIO4_USC_IOCR_TXDMODE_HIGH			0x3

// Z16C30: IOCR.TxCMode

#define	SIO4_USC_IOCR_TXCMODE_ENCODE(v)		SIO4_ENCODE((v), 5, 3)
#define	SIO4_USC_IOCR_TXCMODE_DECODE(r)		SIO4_DECODE((r), 5, 3)

#define	SIO4_USC_IOCR_TXCMODE_INPUT			0x0
#define	SIO4_USC_IOCR_TXCMODE_TXCLK			0x1
#define	SIO4_USC_IOCR_TXCMODE_CHR_CLCK		0x2
#define	SIO4_USC_IOCR_TXCMODE_TX_COMP		0x3
#define	SIO4_USC_IOCR_TXCMODE_BRG0			0x4
#define	SIO4_USC_IOCR_TXCMODE_BRG1			0x5
#define	SIO4_USC_IOCR_TXCMODE_CTR1			0x6
#define	SIO4_USC_IOCR_TXCMODE_DPLL			0x7

// Z16C30: IOCR.RxCMode

#define	SIO4_USC_IOCR_RXCMODE_ENCODE(v)		SIO4_ENCODE((v), 2, 0)
#define	SIO4_USC_IOCR_RXCMODE_DECODE(r)		SIO4_DECODE((r), 2, 0)

#define	SIO4_USC_IOCR_RXCMODE_INPUT			0x0
#define	SIO4_USC_IOCR_RXCMODE_RXCLK			0x1
#define	SIO4_USC_IOCR_RXCMODE_CHR_CLCK		0x2
#define	SIO4_USC_IOCR_RXCMODE_RX_SYNC		0x3
#define	SIO4_USC_IOCR_RXCMODE_BRG0			0x4
#define	SIO4_USC_IOCR_RXCMODE_BRG1			0x5
#define	SIO4_USC_IOCR_RXCMODE_CTR0			0x6
#define	SIO4_USC_IOCR_RXCMODE_DPLL			0x7



// Z16C30: RCSR ***************************************************************

// Z16C30: RCSR.RCmd

#define	SIO4_USC_RCSR_RCMD_ENCODE(v)		SIO4_ENCODE((v), 15, 12)
#define	SIO4_USC_RCSR_RCMD_DECODE(r)		SIO4_DECODE((r), 15, 12)

#define	SIO4_USC_RCSR_RCMD_NOOP				0x0
#define	SIO4_USC_RCSR_RCMD_CLEAR_CRC		0x2
#define	SIO4_USC_RCSR_RCMD_HUNT				0x3
#define	SIO4_USC_RCSR_RCMD_RXFIFO			0x5
#define	SIO4_USC_RCSR_RCMD_INT_LVL			0x6
#define	SIO4_USC_RCSR_RCMD_RXREQ_LVL		0x7

// Z16C30: RCSR.2BE

#define	SIO4_USC_RCSR_2BE_ENCODE(v)			SIO4_ENCODE((v), 15, 15)
#define	SIO4_USC_RCSR_2BE_DECODE(r)			SIO4_DECODE((r), 15, 15)

// Z16C30: RCSR.1BE

#define	SIO4_USC_RCSR_1BE_ENCODE(v)			SIO4_ENCODE((v), 14, 14)
#define	SIO4_USC_RCSR_1BE_DECODE(r)			SIO4_DECODE((r), 14, 14)

// Z16C30: RCSR.RxResidue

#define	SIO4_USC_RCSR_RESIDUE_ENCODE(v)		SIO4_ENCODE((v), 11, 9)
#define	SIO4_USC_RCSR_RESIDUE_DECODE(r)		SIO4_DECODE((r), 11, 9)

// Z16C30: RCSR.ShortF/CVType

#define	SIO4_USC_RCSR_CVTYPE_ENCODE(v)		SIO4_ENCODE((v), 8, 8)
#define	SIO4_USC_RCSR_CVTYPE_DECODE(r)		SIO4_DECODE((r), 8, 8)

// Z16C30: RCSR.ExitedHunt

#define	SIO4_USC_RCSR_EXHUNT_ENCODE(v)		SIO4_ENCODE((v), 7, 7)
#define	SIO4_USC_RCSR_EXHUNT_DECODE(r)		SIO4_DECODE((r), 7, 7)

// Z16C30: RCSR.IdleReceived

#define	SIO4_USC_RCSR_IDLE_ENCODE(v)		SIO4_ENCODE((v), 6, 6)
#define	SIO4_USC_RCSR_IDLE_DECODE(r)		SIO4_DECODE((r), 6, 6)

// Z16C30: RCSR.Break/Abort

#define	SIO4_USC_RCSR_BREAK_ENCODE(v)		SIO4_ENCODE((v), 5, 5)
#define	SIO4_USC_RCSR_BREAK_DECODE(r)		SIO4_DECODE((r), 5, 5)

// Z16C30: RCSR.RxBound

#define	SIO4_USC_RCSR_BOUND_ENCODE(v)		SIO4_ENCODE((v), 4, 4)
#define	SIO4_USC_RCSR_BOUND_DECODE(r)		SIO4_DECODE((r), 4, 4)

// Z16C30: RCSR.CRCE/FE

#define	SIO4_USC_RCSR_FRAME_ENCODE(v)		SIO4_ENCODE((v), 3, 3)
#define	SIO4_USC_RCSR_FRAME_DECODE(r)		SIO4_DECODE((r), 3, 3)

// Z16C30: RCSR.Abort/PE

#define	SIO4_USC_RCSR_PARITY_ENCODE(v)		SIO4_ENCODE((v), 2, 2)
#define	SIO4_USC_RCSR_PARITY_DECODE(r)		SIO4_DECODE((r), 2, 2)

// Z16C30: RCSR.RxOver

#define	SIO4_USC_RCSR_OVER_ENCODE(v)		SIO4_ENCODE((v), 1, 1)
#define	SIO4_USC_RCSR_OVER_DECODE(r)		SIO4_DECODE((r), 1, 1)

// Z16C30: RCSR.RxAvail

#define	SIO4_USC_RCSR_AVAIL_ENCODE(v)		SIO4_ENCODE((v), 0, 0)
#define	SIO4_USC_RCSR_AVAIL_DECODE(r)		SIO4_DECODE((r), 0, 0)



// Z16C30: RMR ****************************************************************

// Z16C30: RMR.RxDecode

#define	SIO4_USC_RMR_RXDECODE_ENCODE(v)		SIO4_ENCODE((v), 15, 13)
#define	SIO4_USC_RMR_RXDECODE_DECODE(r)		SIO4_DECODE((r), 15, 13)

#define	SIO4_USC_ENCODING_NRZ				0x0
#define	SIO4_USC_ENCODING_NRZB				0x1
#define	SIO4_USC_ENCODING_NRZI_MARK			0x2
#define	SIO4_USC_ENCODING_NRZI_SPACE		0x3
#define	SIO4_USC_ENCODING_BIPH_MARK			0x4
#define	SIO4_USC_ENCODING_BIPH_SPACE		0x5
#define	SIO4_USC_ENCODING_BIPH_LEVEL		0x6
#define	SIO4_USC_ENCODING_D_BIPH_LEVEL		0x7

// Z16C30: RMR.RxCRCType

#define	SIO4_USC_RMR_RXCRCTYPE_ENCODE(v)	SIO4_ENCODE((v), 12, 11)
#define	SIO4_USC_RMR_RXCRCTYPE_DECODE(r)	SIO4_DECODE((r), 12, 11)

#define	SIO4_USC_CRCTYPE_16_CCITT			0x0
#define	SIO4_USC_CRCTYPE_16					0x1
#define	SIO4_USC_CRCTYPE_32_ETH				0x2

// Z16C30: RMR.RxCRCStart

#define	SIO4_USC_RMR_RXCRCSTART_ENCODE(v)	SIO4_ENCODE((v),10,10)
#define	SIO4_USC_RMR_RXCRCSTART_DECODE(r)	SIO4_DECODE((r),10,10)

// Z16C30: RMR.RxCRCEnab

#define	SIO4_USC_RMR_RXCRCENAB_ENCODE(v)	SIO4_ENCODE((v), 9, 9)
#define	SIO4_USC_RMR_RXCRCENAB_DECODE(r)	SIO4_DECODE((r), 9, 9)

// Z16C30: RMR.QAbort

#define	SIO4_USC_RMR_QABORT_ENCODE(v)		SIO4_ENCODE((v), 8, 8)
#define	SIO4_USC_RMR_QABORT_DECODE(r)		SIO4_DECODE((r), 8, 8)

#define	SIO4_USC_RMR_QABORT_PE				0x0
#define	SIO4_USC_RMR_QABORT_ABORT			0x1

// Z16C30: RMR.RxParType

#define	SIO4_USC_RMR_RXPARTYPE_ENCODE(v)	SIO4_ENCODE((v), 7, 6)
#define	SIO4_USC_RMR_RXPARTYPE_DECODE(r)	SIO4_DECODE((r), 7, 6)

#define	SIO4_USC_PARTYPE_EVEN				0x0
#define	SIO4_USC_PARTYPE_ODD				0x1
#define	SIO4_USC_PARTYPE_SPACE				0x2
#define	SIO4_USC_PARTYPE_MARK				0x3

// Z16C30: RMR.RxParEnab

#define	SIO4_USC_RMR_RXPARENAB_ENCODE(v)	SIO4_ENCODE((v), 5, 5)
#define	SIO4_USC_RMR_RXPARENAB_DECODE(r)	SIO4_DECODE((r), 5, 5)

// Z16C30: RMR.RxLength

#define	SIO4_USC_RMR_RXLENGTH_ENCODE(v)		SIO4_ENCODE((v), 4, 2)
#define	SIO4_USC_RMR_RXLENGTH_DECODE(r)		SIO4_DECODE((r), 4, 2)

#define	SIO4_USC_CHAR_LENGTH_1				0x1
#define	SIO4_USC_CHAR_LENGTH_2				0x2
#define	SIO4_USC_CHAR_LENGTH_3				0x3
#define	SIO4_USC_CHAR_LENGTH_4				0x4
#define	SIO4_USC_CHAR_LENGTH_5				0x5
#define	SIO4_USC_CHAR_LENGTH_6				0x6
#define	SIO4_USC_CHAR_LENGTH_7				0x7
#define	SIO4_USC_CHAR_LENGTH_8				0x0

#define	SIO4_USC_CHAR_LENGTH_TO_BITS(m)		(((m) == 0) ? 8 : ((m) & 0x7))

// Z16C30: RMR.RxEnab

#define	SIO4_USC_RMR_RXENAB_ENCODE(v)		SIO4_ENCODE((v), 1, 0)
#define	SIO4_USC_RMR_RXENAB_DECODE(r)		SIO4_DECODE((r), 1, 0)

#define	SIO4_USC_ENAB_OFF_NOW				0x0
#define	SIO4_USC_ENAB_OFF_AT_END			0x1
#define	SIO4_USC_ENAB_ON_NOW				0x2
#define	SIO4_USC_ENAB_ON_DCD				0x3



// Z16C30: RSR ****************************************************************

// Z16C30: RSR

#define	SIO4_USC_RSR_MONOSYNC_ENCODE(v)		SIO4_ENCODE((v), 15, 8)
#define	SIO4_USC_RSR_MONOSYNC_DECODE(r)		SIO4_DECODE((r), 15, 8)



// Z16C30: TCSR ***************************************************************

// Z16C30: TCSR.TCmd

#define	SIO4_USC_TCSR_TCMD_ENCODE(v)		SIO4_ENCODE((v), 15, 12)
#define	SIO4_USC_TCSR_TCMD_DECODE(r)		SIO4_DECODE((r), 15, 12)

#define	SIO4_USC_TCSR_TCMD_NOOP				0x0
#define	SIO4_USC_TCSR_TCMD_CLR_TX_CRC		0x2
#define	SIO4_USC_TCSR_TCMD_SEND_MSG			0x8
#define	SIO4_USC_TCSR_TCMD_SEND_ABORT		0x9
#define	SIO4_USC_TCSR_TCMD_ENABLE_DLE		0xC
#define	SIO4_USC_TCSR_TCMD_DISABLE_DLE		0xD
#define	SIO4_USC_TCSR_TCMD_CLEAR_EOM		0xE
#define	SIO4_USC_TCSR_TCMD_SET_EOM			0xF

// Z16C30: TCSR.UnderWait

#define	SIO4_USC_TCSR_UWAIT_ENCODE(v)		SIO4_ENCODE((v), 11, 11)
#define	SIO4_USC_TCSR_UWAIT_DECODE(r)		SIO4_DECODE((r), 11, 11)

// Z16C30: TCSR.TxIdle

#define	SIO4_USC_TCSR_TXIDLE_ENCODE(v)		SIO4_ENCODE((v), 10, 8)
#define	SIO4_USC_TCSR_TXIDLE_DECODE(r)		SIO4_DECODE((r), 10, 8)

#define	SIO4_USC_TCSR_TXIDLE_DEFAULT		0x0
#define	SIO4_USC_TCSR_TXIDLE_ALT_01			0x1
#define	SIO4_USC_TCSR_TXIDLE_CONT_0			0x2
#define	SIO4_USC_TCSR_TXIDLE_CONT_1			0x3
#define	SIO4_USC_TCSR_TXIDLE_ALT_MS			0x5
#define	SIO4_USC_TCSR_TXIDLE_CONT_S			0x6
#define	SIO4_USC_TCSR_TXIDLE_CONT_M			0x7

// Z16C30: TCSR.PreSent

#define	SIO4_USC_TCSR_PRE_ENCODE(v)			SIO4_ENCODE((v), 7, 7)
#define	SIO4_USC_TCSR_PRE_DECODE(r)			SIO4_DECODE((r), 7, 7)

// Z16C30: TCSR.IdleSent

#define	SIO4_USC_TCSR_IDLE_ENCODE(v)		SIO4_ENCODE((v), 6, 6)
#define	SIO4_USC_TCSR_IDLE_DECODE(r)		SIO4_DECODE((r), 6, 6)

// Z16C30: TCSR.AbortSent

#define	SIO4_USC_TCSR_ABORT_ENCODE(v)		SIO4_ENCODE((v), 5, 5)
#define	SIO4_USC_TCSR_ABORT_DECODE(r)		SIO4_DECODE((r), 5, 5)

// Z16C30: TCSR.EOMSent

#define	SIO4_USC_TCSR_EOM_ENCODE(v)			SIO4_ENCODE((v), 4, 4)
#define	SIO4_USC_TCSR_EOM_DECODE(r)			SIO4_DECODE((r), 4, 4)

// Z16C30: TCSR.CRCSent

#define	SIO4_USC_TCSR_CRC_ENCODE(v)			SIO4_ENCODE((v), 3, 3)
#define	SIO4_USC_TCSR_CRC_DECODE(r)			SIO4_DECODE((r), 3, 3)

// Z16C30: TCSR.AllSent

#define	SIO4_USC_TCSR_ALL_ENCODE(v)			SIO4_ENCODE((v), 2, 2)
#define	SIO4_USC_TCSR_ALL_DECODE(r)			SIO4_DECODE((r), 2, 2)

// Z16C30: TCSR.TxUnder

#define	SIO4_USC_TCSR_TXUNDER_ENCODE(v)		SIO4_ENCODE((v), 1, 1)
#define	SIO4_USC_TCSR_TXUNDER_DECODE(r)		SIO4_DECODE((r), 1, 1)

// Z16C30: TCSR.TxEmpty

#define	SIO4_USC_TCSR_TXEMPTY_ENCODE(v)		SIO4_ENCODE((v), 0, 0)
#define	SIO4_USC_TCSR_TXEMPTY_DECODE(r)		SIO4_DECODE((r), 0, 0)



// Z16C30: TMR ****************************************************************

// Z16C30: TMR.TxEncode: See RMR.RxDecode for values.

#define	SIO4_USC_TMR_TXENCODE_ENCODE(v)		SIO4_ENCODE((v), 15, 13)
#define	SIO4_USC_TMR_TXENCODE_DECODE(r)		SIO4_DECODE((r), 15, 13)

// Z16C30: TMR.TxCRCType: See RMR.RxCRCType for values.

#define	SIO4_USC_TMR_TXCRCTYPE_ENCODE(v)	SIO4_ENCODE((v), 12, 11)
#define	SIO4_USC_TMR_TXCRCTYPE_DECODE(r)	SIO4_DECODE((r), 12, 11)

// Z16C30: TMR.TxCRCStart

#define	SIO4_USC_TMR_TXCRCSTART_ENCODE(v)	SIO4_ENCODE((v),10,10)
#define	SIO4_USC_TMR_TXCRCSTART_DECODE(r)	SIO4_DECODE((r),10,10)

// Z16C30: TMR.TxCRCEnab

#define	SIO4_USC_TMR_TXCRCENAB_ENCODE(v)	SIO4_ENCODE((v), 9, 9)
#define	SIO4_USC_TMR_TXCRCENAB_DECODE(r)	SIO4_DECODE((r), 9, 9)

// Z16C30: TMR.TxCRCCatEnd

#define	SIO4_USC_TMR_TXCRCCATEND_ENCODE(v)	SIO4_ENCODE((v), 8, 8)
#define	SIO4_USC_TMR_TXCRCCATEND_DECODE(r)	SIO4_DECODE((r), 8, 8)

// Z16C30: TMR.TxParType: See RMR.RxParType for values.

#define	SIO4_USC_TMR_TXPARTYPE_ENCODE(v)	SIO4_ENCODE((v), 7, 6)
#define	SIO4_USC_TMR_TXPARTYPE_DECODE(r)	SIO4_DECODE((r), 7, 6)

// Z16C30: TMR.TxParEnab

#define	SIO4_USC_TMR_TXPARENAB_ENCODE(v)	SIO4_ENCODE((v), 5, 5)
#define	SIO4_USC_TMR_TXPARENAB_DECODE(r)	SIO4_DECODE((r), 5, 5)

// Z16C30: TMR.TxLength: See RMR.RxLength for values.

#define	SIO4_USC_TMR_TXLENGTH_ENCODE(v)		SIO4_ENCODE((v), 4, 2)
#define	SIO4_USC_TMR_TXLENGTH_DECODE(r)		SIO4_DECODE((r), 4, 2)

// Z16C30: TMR.TxEnab: See RMR.RxEnab for values.

#define	SIO4_USC_TMR_TXENAB_ENCODE(v)		SIO4_ENCODE((v), 1, 0)
#define	SIO4_USC_TMR_TXENAB_DECODE(r)		SIO4_DECODE((r), 1, 0)



#endif // __Z1630_H
