// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/driver/sio4.h $
// $Rev: 53095 $
// $Date: 2023-06-13 10:42:41 -0500 (Tue, 13 Jun 2023) $

// SIO4: Device Driver: header file

#ifndef	__SIO4_H__
#define	__SIO4_H__

#include "gsc_common.h"
#include "z1630.h"

#ifndef	_ASMLANGUAGE



// data types *****************************************************************

typedef	unsigned char	UINT8;
typedef	unsigned short	UINT16;
typedef	unsigned long	UINT32;

#define	SIO4_BASE_NAME						"sio4"



// These are the ioctl() functions

// General Functions
#define	SIO4_NO_FUNCTION					_IO  ('S',	 0)
#define	SIO4_INIT_CHANNEL					_IOW ('S',	 2, SIO4_INIT_CHAN)
#define	SIO4_SEND_CHANNEL_COMMAND			_IOW ('S',	 3, SIO4_CHAN_CMD)
#define	SIO4_RESET_FIFO						_IOW ('S',	 4, TX_RX)
//		SIO4_READ_FIFO_STATUS				_IOR ('S',	 5, FIFO_STATUS) // No longer supported.
#define	SIO4_RESET_ZILOG_CHIP				_IO  ('S',	 6)
#define	SIO4_SET_SYNC_BYTE					_IOW ('S',	 7, UINT32)
#define	SIO4_SET_READ_TIMEOUT				_IOW ('S',	 8, UINT32)
#define	SIO4_SET_WRITE_TIMEOUT				_IOW ('S',	 9, UINT32)
#define	SIO4_READ_REGISTER					_IOWR('S',  11, REGISTER_PARAMS)
#define	SIO4_WRITE_REGISTER					_IOW ('S',  12, REGISTER_PARAMS)
#define	SIO4_SET_XMT_ASYNC_PROT				_IOW ('S',  13, XMT_ASYNC_PROTOCOL)
#define	SIO4_SET_RCV_ASYNC_PROT				_IOW ('S',  14, RCV_ASYNC_PROTOCOL)
#define	SIO4_SET_XMT_ISOCHR_PROT			_IOW ('S',  16, XMT_ISOCHR_PROTOCOL)
#define	SIO4_SET_RCV_ISOCHR_PROT			_IO  ('S',  17)
#define	SIO4_SET_XMT_HDLC_PROT				_IOW ('S',  24, XMT_HDLC_PROTOCOL)
#define	SIO4_SET_RCV_HDLC_PROT				_IOW ('S',  25, RCV_HDLC_PROTOCOL)
#define	SIO4_SET_XMT_HDLC_SDLC_LOOP_PROT	_IOW ('S',  33, XMT_HDLC_SDLC_LOOP_PROTOCOL)
#define	SIO4_SET_DPLL_SOURCE				_IOW ('S',  38, CLOCK_SOURCE)
#define	SIO4_CLEAR_DPLL_STATUS				_IOW ('S',  39, UINT32)
#define	SIO4_SELECT_DPLL_RESYNC				_IOW ('S',  40, DPLL_RESYNC)
#define	SIO4_SET_DPLL_DIVISOR				_IOW ('S',  41, DPLL_DIVISOR)
#define	SIO4_SET_DPLL_MODE					_IOW ('S',  42, DPLL_MODE)
#define	SIO4_SET_TX_CLOCK_SOURCE			_IOW ('S',  48, CLOCK_SOURCE)
#define	SIO4_SET_RX_CLOCK_SOURCE			_IOW ('S',  49, CLOCK_SOURCE)
#define	SIO4_SET_CTR0_SOURCE				_IOW ('S',  50, CLOCK_SOURCE)
#define	SIO4_SET_CTR1_SOURCE				_IOW ('S',  51, CLOCK_SOURCE)
#define	SIO4_SET_BRG0_SOURCE				_IOW ('S',  54, CLOCK_SOURCE)
#define	SIO4_SET_BRG1_SOURCE				_IOW ('S',  55, CLOCK_SOURCE)
#define	SIO4_SET_BRG0_MODE					_IOW ('S',  56, BRG_MODE)
#define	SIO4_SET_BRG1_MODE					_IOW ('S',  57, BRG_MODE)
#define	SIO4_ENABLE_BRG0					_IOW ('S',  58, UINT8)
#define	SIO4_ENABLE_BRG1					_IOW ('S',  59, UINT8)
#define	SIO4_INIT_BOARD						_IO  ('S',  75)
#define	SIO4_RESET_DEVICE					_IO  ('S',  76)
#define	SIO4_INT_NOTIFY						_IO  ('S',  77)
#define	SIO4_SET_USC_DMA_OPTIONS			_IOW ('S', 100, USC_DMA_OPTIONS)
#define	SIO4_READ_INT_STATUS				_IOR ('S', 101, SIO4_INTERRUPT_STATUS)
#define	SIO4_GET_DRIVER_INFO				_IOR ('S', 102, SIO4_DRIVER_INFO)
#define	SIO4_RESET_USC						_IO  ('S', 103)
#define	SIO4_RESET_CHANNEL					_IO  ('S', 104)
#define	SIO4_BOARD_JUMPERS					_IOR ('S', 105, s32)
#define	SIO4_FEATURE_TEST					_IOWR('S', 106, s32)
//		SIO4_TX_FIFO_TYPE					_IOR ('S', 107, s32)	// No longer supported.
//		SIO4_RX_FIFO_TYPE					_IOR ('S', 108, s32)	// No longer supported.
#define	SIO4_TX_FIFO_AE_CONFIG				_IOWR('S', 109, s32)
#define	SIO4_TX_FIFO_AF_CONFIG				_IOWR('S', 110, s32)
#define	SIO4_RX_FIFO_AE_CONFIG				_IOWR('S', 111, s32)
#define	SIO4_RX_FIFO_AF_CONFIG				_IOWR('S', 112, s32)
#define	SIO4_TX_FIFO_SIZE					_IOR ('S', 113, s32)
#define	SIO4_RX_FIFO_SIZE					_IOR ('S', 114, s32)
#define	SIO4_TX_FIFO_COUNT					_IOR ('S', 115, s32)
#define	SIO4_RX_FIFO_COUNT					_IOR ('S', 116, s32)
#define	SIO4_RX_FIFO_FULL_CFG_GLB			_IOWR('S', 117, s32)
#define	SIO4_TX_CABLE_CONFIG				_IOWR('S', 118, s32)
#define	SIO4_RX_CABLE_CONFIG				_IOWR('S', 119, s32)
#define	SIO4_TX_CABLE_CLOCK_CONFIG			_IOWR('S', 120, s32)
#define	SIO4_TXC_USC_CONFIG					_IOWR('S', 122, s32)
#define	SIO4_RXC_USC_CONFIG					_IOWR('S', 123, s32)
#define	SIO4_CTS_CABLE_CONFIG				_IOWR('S', 124, s32)
#define	SIO4_MOD_REGISTER					_IOWR('S', 125, REGISTER_MOD_PARAMS)
#define	SIO4_READ_REGISTER_RAW				_IOWR('S', 126, REGISTER_PARAMS)
#define	SIO4_TX_IO_MODE_CONFIG				_IOWR('S', 127, s32)
#define	SIO4_RX_IO_MODE_CONFIG				_IOWR('S', 128, s32)
#define	SIO4_TX_IO_ABORT					_IOR ('S', 129, s32)
#define	SIO4_RX_IO_ABORT					_IOR ('S', 130, s32)
#define	SIO4_TX_CABLE_DATA_CONFIG			_IOWR('S', 131, s32)
#define	SIO4_DCD_CABLE_CONFIG				_IOWR('S', 132, s32)
#define	SIO4_CABLE_CONFIG					_IOWR('S', 133, s32)
#define	SIO4_MP_TEST						_IOWR('S', 140, sio4_mp_t)
#define	SIO4_MP_RESET						_IOR ('S', 141, sio4_mp_t)
#define	SIO4_MP_INIT						_IOR ('S', 142, sio4_mp_t)
#define	SIO4_MP_CONFIG						_IOWR('S', 143, sio4_mp_t)
#define	SIO4_MP_INFO						_IOR ('S', 144, sio4_mp_t)
#define	SIO4_OSC_REFERENCE					_IOWR('S', 150, sio4_osc_t)
#define	SIO4_OSC_RESET						_IOR ('S', 151, sio4_osc_t)
#define	SIO4_OSC_INIT						_IOR ('S', 152, sio4_osc_t)
#define	SIO4_OSC_TEST						_IOWR('S', 153, sio4_osc_t)
#define	SIO4_OSC_PROGRAM					_IOWR('S', 154, sio4_osc_t)
#define	SIO4_OSC_INFO						_IOR ('S', 155, sio4_osc_t)
#define	SIO4_OSC_MEASURE					_IOR ('S', 156, sio4_osc_t)
#define	SIO4_TX_FIFO_STATUS					_IOR ('S', 157, s32)
#define	SIO4_RX_FIFO_STATUS					_IOR ('S', 158, s32)
#define	SIO4_RX_FIFO_FULL_CFG_CHAN			_IOWR('S', 159, s32)
#define	SIO4_FW_TYPE_CONFIG					_IOWR('S', 160, s32)


// ****************************************************************************

#define	SIO4_DECODE(r,b,e)					(((r)>>(e)) & (0xFFFFFFFFUL >> (31-((b)-(e)))))
#define	SIO4_ENCODE(v,b,e)					(((v) << (e)) & \
											((0xFFFFFFFF << (e)) & (0xFFFFFFFF >> (31 - (b)))))

#define	SIO4_TYPE_ENCODE(t)					(SIO4_ENCODE((t),	 2,  0)		)
#define	SIO4_TYPE_DECODE(r)					(SIO4_DECODE((r),	 2,  0)		)

#define	SIO4_SIZE_ENCODE(s)					(SIO4_ENCODE((s)-1,	 4,  3)		)
#define	SIO4_SIZE_DECODE(r)					(SIO4_DECODE((r),	 4,  3)+1	)

#define	SIO4_OFFSET_ENCODE(o)				(SIO4_ENCODE((o),	21,  5)		)
#define	SIO4_OFFSET_DECODE(r)				(SIO4_DECODE((r),	21,  5)		)

#define	SIO4_CH_MULT_ENCODE(m)				(SIO4_ENCODE((m)/4,	24, 22)		)
#define	SIO4_CH_MULT_DECODE(r)				(SIO4_DECODE((r),	24, 22)*4	)

#define	SIO4_FIELD_1_ENCODE(f1)				(SIO4_ENCODE((f1),	27, 25)		)
#define	SIO4_FIELD_1_DECODE(r)				(SIO4_DECODE((r),	27, 25)		)

#define	SIO4_FIELD_2_ENCODE(f2)				(SIO4_ENCODE((f2),	30, 28)		)
#define	SIO4_FIELD_2_DECODE(r)				(SIO4_DECODE((r),	30,	28)		)

#define	SIO4_OTHER_DECODE(r)				(SIO4_DECODE((r),	31,	31)		)

#define	SIO4_REG_ENCODE(t,f1,f2,m,s,o)		(	SIO4_TYPE_ENCODE	((t)) |	\
												SIO4_SIZE_ENCODE	((s)) | \
												SIO4_OFFSET_ENCODE	((o)) | \
												SIO4_CH_MULT_ENCODE	((m)) | \
												SIO4_FIELD_1_ENCODE	((f1))| \
												SIO4_FIELD_2_ENCODE	((f2)))

#define	SIO4_REG_PCI						GSC_REG_TYPE_PCI	// PCI Configuration Registers
#define	SIO4_REG_PLX						GSC_REG_TYPE_BAR0	// PLX Feature Set Registers
#define	SIO4_REG_GSC						GSC_REG_TYPE_BAR2	// GSC Firmware Registers
#define	SIO4_REG_USC						GSC_REG_TYPE_ALT	// Zilog USC Registers

// PCI Configuration Registers: PCI9080
#define	SIO4_PCI_ENCODE(s,o)				SIO4_REG_ENCODE(SIO4_REG_PCI,0,0,0,s,o)

#define	SIO4_PCI_VID						SIO4_PCI_ENCODE(2,0x00)
#define	SIO4_PCI_DID						SIO4_PCI_ENCODE(2,0x02)
#define	SIO4_PCI_CR							SIO4_PCI_ENCODE(2,0x04)
#define	SIO4_PCI_SR							SIO4_PCI_ENCODE(2,0x06)
#define	SIO4_PCI_REV						SIO4_PCI_ENCODE(1,0x08)
#define	SIO4_PCI_CCR						SIO4_PCI_ENCODE(3,0x08)
#define	SIO4_PCI_CLSR						SIO4_PCI_ENCODE(1,0x0C)
#define	SIO4_PCI_LTR						SIO4_PCI_ENCODE(1,0x0D)
#define	SIO4_PCI_HTR						SIO4_PCI_ENCODE(1,0x0E)
#define	SIO4_PCI_BISTR						SIO4_PCI_ENCODE(1,0x0F)
#define	SIO4_PCI_BAR0						SIO4_PCI_ENCODE(4,0x10)
#define	SIO4_PCI_BAR1						SIO4_PCI_ENCODE(4,0x14)
#define	SIO4_PCI_BAR2						SIO4_PCI_ENCODE(4,0x18)
#define	SIO4_PCI_BAR3						SIO4_PCI_ENCODE(4,0x1C)
#define	SIO4_PCI_BAR4						SIO4_PCI_ENCODE(4,0x20)
#define	SIO4_PCI_BAR5						SIO4_PCI_ENCODE(4,0x24)
#define	SIO4_PCI_CIS						SIO4_PCI_ENCODE(4,0x28)
#define	SIO4_PCI_SVID						SIO4_PCI_ENCODE(2,0x2C)
#define	SIO4_PCI_SID						SIO4_PCI_ENCODE(2,0x2E)
#define	SIO4_PCI_ERBAR						SIO4_PCI_ENCODE(4,0x30)
#define	SIO4_PCI_ILR						SIO4_PCI_ENCODE(1,0x3C)
#define	SIO4_PCI_IPR						SIO4_PCI_ENCODE(1,0x3D)
#define	SIO4_PCI_MGR						SIO4_PCI_ENCODE(1,0x3E)
#define	SIO4_PCI_MLR						SIO4_PCI_ENCODE(1,0x3F)

// PLX Feature Set Registers: PCI9080
#define	SIO4_PLX_ENCODE(s,o)				SIO4_REG_ENCODE(SIO4_REG_PLX,0,0,0,s,o)

// PCI9080: Local Configuration Registers
#define	SIO4_PLX_LAS0RR						SIO4_PLX_ENCODE(4,0x00)
#define	SIO4_PLX_LAS0BA						SIO4_PLX_ENCODE(4,0x04)
#define	SIO4_PLX_MARBR						SIO4_PLX_ENCODE(4,0x08)
#define	SIO4_PLX_BIGEND						SIO4_PLX_ENCODE(4,0x0C)
#define	SIO4_PLX_EROMRR						SIO4_PLX_ENCODE(4,0x10)
#define	SIO4_PLX_EROMBA						SIO4_PLX_ENCODE(4,0x14)
#define	SIO4_PLX_LBRD0						SIO4_PLX_ENCODE(4,0x18)
#define	SIO4_PLX_DMRR						SIO4_PLX_ENCODE(4,0x1C)
#define	SIO4_PLX_DMLBAM						SIO4_PLX_ENCODE(4,0x20)
#define	SIO4_PLX_DMLBAI						SIO4_PLX_ENCODE(4,0x24)
#define	SIO4_PLX_DMPBAM						SIO4_PLX_ENCODE(4,0x28)
#define	SIO4_PLX_DMCFGA						SIO4_PLX_ENCODE(4,0x2C)
#define	SIO4_PLX_LAS1RR						SIO4_PLX_ENCODE(4,0xF0)
#define	SIO4_PLX_LAS1BA						SIO4_PLX_ENCODE(4,0xF4)
#define	SIO4_PLX_LBRD1						SIO4_PLX_ENCODE(4,0xF8)

// PCI9080: Run Time Registers
#define	SIO4_PLX_MBOX0						SIO4_PLX_ENCODE(4,0x40)
#define	SIO4_PLX_MBOX1						SIO4_PLX_ENCODE(4,0x44)
#define	SIO4_PLX_MBOX2						SIO4_PLX_ENCODE(4,0x48)
#define	SIO4_PLX_MBOX3						SIO4_PLX_ENCODE(4,0x4C)
#define	SIO4_PLX_MBOX4						SIO4_PLX_ENCODE(4,0x50)
#define	SIO4_PLX_MBOX5						SIO4_PLX_ENCODE(4,0x54)
#define	SIO4_PLX_MBOX6						SIO4_PLX_ENCODE(4,0x58)
#define	SIO4_PLX_MBOX7						SIO4_PLX_ENCODE(4,0x5C)
#define	SIO4_PLX_P2LDBELL					SIO4_PLX_ENCODE(4,0x60)
#define	SIO4_PLX_L2PDBELL					SIO4_PLX_ENCODE(4,0x64)
#define	SIO4_PLX_INTCSR						SIO4_PLX_ENCODE(4,0x68)
#define	SIO4_PLX_CNTRL						SIO4_PLX_ENCODE(4,0x6C)
#define	SIO4_PLX_PCIHIDR					SIO4_PLX_ENCODE(4,0x70)
#define	SIO4_PLX_PCIHREV					SIO4_PLX_ENCODE(2,0x74)

// PCI9080: DMA Registers
#define	SIO4_PLX_DMAMODE0					SIO4_PLX_ENCODE(4,0x80)
#define	SIO4_PLX_DMAPADR0					SIO4_PLX_ENCODE(4,0x84)
#define	SIO4_PLX_DMALADR0					SIO4_PLX_ENCODE(4,0x88)
#define	SIO4_PLX_DMASIZ0					SIO4_PLX_ENCODE(4,0x8C)
#define	SIO4_PLX_DMADPR0					SIO4_PLX_ENCODE(4,0x90)
#define	SIO4_PLX_DMAMODE1					SIO4_PLX_ENCODE(4,0x94)
#define	SIO4_PLX_DMAPADR1					SIO4_PLX_ENCODE(4,0x98)
#define	SIO4_PLX_DMALADR1					SIO4_PLX_ENCODE(4,0x9C)
#define	SIO4_PLX_DMASIZ1					SIO4_PLX_ENCODE(4,0xA0)
#define	SIO4_PLX_DMADPR1					SIO4_PLX_ENCODE(4,0xA4)
#define	SIO4_PLX_DMACSR0					SIO4_PLX_ENCODE(1,0xA8)
#define	SIO4_PLX_DMACSR1					SIO4_PLX_ENCODE(1,0xA9)
#define	SIO4_PLX_DMAARB						SIO4_PLX_ENCODE(4,0xAC)
#define	SIO4_PLX_DMATHR						SIO4_PLX_ENCODE(4,0xB0)

// PCI9080: Messaging Queue Registers
#define	SIO4_PLX_OPLFIS						SIO4_PLX_ENCODE(4,0x30)
#define	SIO4_PLX_OPLFIM						SIO4_PLX_ENCODE(4,0x34)
#define	SIO4_PLX_IQP						SIO4_PLX_ENCODE(4,0x40)
#define	SIO4_PLX_OQP						SIO4_PLX_ENCODE(4,0x44)
#define	SIO4_PLX_MQCR						SIO4_PLX_ENCODE(4,0xC0)
#define	SIO4_PLX_QBAR						SIO4_PLX_ENCODE(4,0x4C)
#define	SIO4_PLX_IFHPR						SIO4_PLX_ENCODE(4,0xC8)
#define	SIO4_PLX_IFTPR						SIO4_PLX_ENCODE(4,0xCC)
#define	SIO4_PLX_IPHPR						SIO4_PLX_ENCODE(4,0xD0)
#define	SIO4_PLX_IPTPR						SIO4_PLX_ENCODE(4,0xD4)
#define	SIO4_PLX_OFHPR						SIO4_PLX_ENCODE(4,0xD8)
#define	SIO4_PLX_OFTPR						SIO4_PLX_ENCODE(4,0xDC)
#define	SIO4_PLX_OPHPR						SIO4_PLX_ENCODE(4,0xE0)
#define	SIO4_PLX_OPTPR						SIO4_PLX_ENCODE(4,0xE4)
#define	SIO4_PLX_QSR						SIO4_PLX_ENCODE(4,0xE8)

// SIO4 Registers
#define	SIO4_GSC_ENCODE(f1,f2,m,s,o)		SIO4_REG_ENCODE(SIO4_REG_GSC,f2,f1,m,s,o)

#define	SIO4_GSC_FRR						SIO4_GSC_ENCODE(0,0, 0,4,0x00)// Firmware Rev Reg
#define	SIO4_GSC_BCR						SIO4_GSC_ENCODE(0,0, 0,4,0x04)// Board Control Reg
#define	SIO4_GSC_BSR						SIO4_GSC_ENCODE(0,0, 0,4,0x08)// Board Status Reg
#define	SIO4_GSC_CCR						SIO4_GSC_ENCODE(0,1, 0,4,0x0C)// Clock Control Reg
#define	SIO4_GSC_TSR						SIO4_GSC_ENCODE(0,0, 0,4,0x0C)// Timestamp Register

#define	SIO4_GSC_TAR						SIO4_GSC_ENCODE(0,0,16,4,0x10)// Tx Almost Reg
#define	SIO4_GSC_RAR						SIO4_GSC_ENCODE(0,0,16,4,0x14)// Rx Almost Reg
#define	SIO4_GSC_FDR						SIO4_GSC_ENCODE(0,0,16,4,0x18)// FIFO Data Reg
#define	SIO4_GSC_CSR						SIO4_GSC_ENCODE(0,0,16,4,0x1C)// Command/Status Reg

#define	SIO4_GSC_SBR						SIO4_GSC_ENCODE(0,0, 4,4,0x50)// Sync Byte Register

#define	SIO4_GSC_ICR						SIO4_GSC_ENCODE(2,1, 0,4,0x60)// Interrupt Control
#define	SIO4_GSC_ISR						SIO4_GSC_ENCODE(2,1, 0,4,0x64)// Interrupt Control
#define	SIO4_GSC_IELR						SIO4_GSC_ENCODE(2,1, 0,4,0x68)// Int Edge/Level Reg
#define	SIO4_GSC_IHLR						SIO4_GSC_ENCODE(2,1, 0,4,0x6C)// Int Hi/Low Reg

#define	SIO4_GSC_PSRCR						SIO4_GSC_ENCODE(0,0, 4,4,0x80)// Pin Source Reg
#define	SIO4_GSC_PSTSR						SIO4_GSC_ENCODE(0,0, 4,4,0x90)// Pin Ststus Reg
#define	SIO4_GSC_GPIOSR						SIO4_GSC_ENCODE(0,0, 0,4,0x90)// GPIO Source Register
#define	SIO4_GSC_IOCR						SIO4_GSC_ENCODE(0,0, 4,4,0x90)// I/O Control Register

#define	SIO4_GSC_FCR						SIO4_GSC_ENCODE(0,0, 4,4,0xD0)// FIFO Count Reg
#define	SIO4_GSC_FSR						SIO4_GSC_ENCODE(0,0, 4,4,0xE0)// FIFO Size Reg
#define	SIO4_GSC_FTR						SIO4_GSC_ENCODE(0,3, 0,4,0xF8)// Firmware Type Register
#define	SIO4_GSC_FR							SIO4_GSC_ENCODE(0,0, 0,4,0xFC)// Features Register

// For SYNC devices only.
#define	SIO4_GSC_TCR						SIO4_GSC_ENCODE(0,0, 4,4,0xB0)// Tx Count Reg
#define	SIO4_GSC_RCR						SIO4_GSC_ENCODE(0,0, 4,4,0xC0)// Rx Count Reg

// CY22393 oscillator programming
#define	SIO4_GSC_PORAR						SIO4_GSC_ENCODE(0,0, 0,4,0xA0)// Prog Osc RAM Adrs
#define	SIO4_GSC_PORDR						SIO4_GSC_ENCODE(0,0, 0,4,0xA4)// Prog Osc RAM Data
#define	SIO4_GSC_POCSR						SIO4_GSC_ENCODE(0,0, 0,4,0xA8)// Prog Osc Ctrl/Stat
#define	SIO4_GSC_PORD2R						SIO4_GSC_ENCODE(0,0, 0,4,0xAC)// Prog Osc RAM Data 2

// IDC2053B oscillator programming
#define	SIO4_GSC_PCR						SIO4_GSC_ENCODE(0,0, 4,4,0xA0)// Prog Clock Reg
#define	SIO4_GSC_PCDR						SIO4_GSC_ENCODE(0,0, 4,4,0xA0)// Prog Clock/Divider Reg

// GSC Register support macros.

// Board Control Register
#define	SIO4_GSC_BCR_DMA0_REQ				0x00000007	// DMA 0 Request
#define	SIO4_GSC_BCR_DMA0_SCD				0x00000008	// DMA 0 Single Cycle Disable
#define	SIO4_GSC_BCR_DMA1_REQ				0x00000070	// DMA 1 Request
#define	SIO4_GSC_BCR_DMA1_SCD				0x00000080	// DMA 1 Single Cycle Disable
#define	SIO4_GSC_BCR_RX_FFC					0x00000100	// Rx FIFO Full Config
#define	SIO4_GSC_BCR_BRD_RST				0x80000000	// Board Reset

// Board Status Register
#define	SIO4_GSC_BSR_RS232					0x00000010	// RS-232 device
#define	SIO4_GSC_BSR_AUX_XCVR				0x00000040	// Aux Xcvrs

// Firmware Revision Register
#define	SIO4_GSC_FRR_FWREV					0x000000FF	// Revision level
#define	SIO4_GSC_FRR_SIO4					0x0000FF00	// If 0, then original SIO4.
// Firmware Revision Register: per specification of SIO4A/B
#define	SIO4_GSC_FRR_SPEC_FWREV				0x000000FF	// Revision level
#define	SIO4_GSC_FRR_SPEC					0x40000000	// FRR conforms to spec.
#define	SIO4_GSC_FRR_SPEC_FR				0x80000000	// Has Features Reg.

// Features Register; layout depends on the device model

// Clock Control Register
#define	SIO4_GSC_CCR_TXU_ENCODE(v)			SIO4_ENCODE((v), 0, 0)
#define	SIO4_GSC_CCR_TXU_DECODE(r)			SIO4_DECODE((r), 0, 0)
#define	SIO4_GSC_CCR_TXL_ENCODE(v)			SIO4_ENCODE((v), 1, 1)
#define	SIO4_GSC_CCR_TXL_DECODE(r)			SIO4_DECODE((r), 1, 1)
#define	SIO4_GSC_CCR_RXU_ENCODE(v)			SIO4_ENCODE((v), 2, 2)
#define	SIO4_GSC_CCR_RXU_DECODE(r)			SIO4_DECODE((r), 2, 2)
#define	SIO4_GSC_CCR_RXL_ENCODE(v)			SIO4_ENCODE((v), 3, 3)
#define	SIO4_GSC_CCR_RXL_DECODE(r)			SIO4_DECODE((r), 3, 3)

// Control/Status Register
#define	SIO4_GSC_CSR_TFR					0x00000001	// Tx FIFO Reset
#define	SIO4_GSC_CSR_RFR					0x00000002	// Rx FIFO Reset
#define	SIO4_GSC_CSR_TDUE					0x00000004	// Tx Data Upper Enable
#define	SIO4_GSC_CSR_TDLE					0x00000008	// Tx Data Lower Enable
#define	SIO4_GSC_CSR_TDULE					(SIO4_GSC_CSR_TDUE | SIO4_GSC_CSR_TDLE)
#define	SIO4_GSC_CSR_RDUE					0x00000010	// Rx Data Upper Enable
#define	SIO4_GSC_CSR_RDLE					0x00000020	// Rx Data Lower Enable
#define	SIO4_GSC_CSR_RDULE					(SIO4_GSC_CSR_RDUE | SIO4_GSC_CSR_RDLE)
#define	SIO4_GSC_CSR_ZIL_RST				0x00000080	// Zilog Reset
#define	SIO4_GSC_CSR_TFE					0x00000100	// Tx FIFO Empty
#define	SIO4_GSC_CSR_TFAE					0x00000200	// Tx FIFO Almost Empty
#define	SIO4_GSC_CSR_TFAF					0x00000400	// Tx FIFO Almost Full
#define	SIO4_GSC_CSR_TFF					0x00000800	// Tx FIFO Full
#define	SIO4_GSC_CSR_RFE					0x00001000	// Rx FIFO Empty
#define	SIO4_GSC_CSR_RFAE					0x00002000	// Rx FIFO Almost Empty
#define	SIO4_GSC_CSR_RFAF					0x00004000	// Rx FIFO Almost Full
#define	SIO4_GSC_CSR_RFF					0x00008000	// Rx FIFO Full

#define	SIO4_GSC_CSR_TXFR_ENCODE(v)			SIO4_ENCODE((v), 0, 0)
#define	SIO4_GSC_CSR_TXFR_DECODE(r)			SIO4_DECODE((r), 0, 0)
#define	SIO4_GSC_CSR_RXFR_ENCODE(v)			SIO4_ENCODE((v), 1, 1)
#define	SIO4_GSC_CSR_RXFR_DECODE(r)			SIO4_DECODE((r), 1, 1)
#define	SIO4_GSC_CSR_TXU_ENCODE(v)			SIO4_ENCODE((v), 2, 2)
#define	SIO4_GSC_CSR_TXU_DECODE(r)			SIO4_DECODE((r), 2, 2)
#define	SIO4_GSC_CSR_TXL_ENCODE(v)			SIO4_ENCODE((v), 3, 3)
#define	SIO4_GSC_CSR_TXL_DECODE(r)			SIO4_DECODE((r), 3, 3)
#define	SIO4_GSC_CSR_RXU_ENCODE(v)			SIO4_ENCODE((v), 4, 4)
#define	SIO4_GSC_CSR_RXU_DECODE(r)			SIO4_DECODE((r), 4, 4)
#define	SIO4_GSC_CSR_RXL_ENCODE(v)			SIO4_ENCODE((v), 5, 5)
#define	SIO4_GSC_CSR_RXL_DECODE(r)			SIO4_DECODE((r), 5, 5)
#define	SIO4_GSC_CSR_TXFS_ENCODE(v)			SIO4_ENCODE((v), 11, 8)
#define	SIO4_GSC_CSR_TXFS_DECODE(r)			SIO4_DECODE((r), 11, 8)
#define	SIO4_GSC_CSR_RXFS_ENCODE(v)			SIO4_ENCODE((v), 15, 12)
#define	SIO4_GSC_CSR_RXFS_DECODE(r)			SIO4_DECODE((r), 15, 12)

// These are for the Pin Source Register
#define	SIO4_GSC_PSRCR_USC_TCS				0x00000007	// USC TxC Source
#define	SIO4_GSC_PSRCR_USC_TCS_PRG_CLK		0x00000000	// -Programmed Clock
#define	SIO4_GSC_PSRCR_USC_TCS_LOW			0x00000002	// -Drive Low
#define	SIO4_GSC_PSRCR_USC_TCS_HI			0x00000003	// -Drive High
#define	SIO4_GSC_PSRCR_USC_TCS_CBL_RC		0x00000004	// -Cable RxClk
#define	SIO4_GSC_PSRCR_USC_TCS_USC_OUT		0x00000007	// -Driven by USC
#define	SIO4_GSC_PSRCR_USC_RCS				0x00000038	// USC RxC Source
#define	SIO4_GSC_PSRCR_USC_RCS_PRG_CLK		0x00000000	// -Programmed Clock
#define	SIO4_GSC_PSRCR_USC_RCS_LOW			0x00000010	// -Drive Low
#define	SIO4_GSC_PSRCR_USC_RCS_HI			0x00000018	// -Drive High
#define	SIO4_GSC_PSRCR_USC_RCS_CBL_RC		0x00000020	// -Cable RxClk
#define	SIO4_GSC_PSRCR_USC_RCS_USC_OUT		0x00000038	// -Driven by USC
#define	SIO4_GSC_PSRCR_CBL_TCS				0x000001C0	// Cable TxClk Source
#define	SIO4_GSC_PSRCR_CBL_TCS_PRG_CLK		0x00000000	// -Programmed Clock
#define	SIO4_GSC_PSRCR_CBL_TCS_LOW			0x00000080	// -Drive low
#define	SIO4_GSC_PSRCR_CBL_TCS_HI			0x000000C0	// -Drive high
#define	SIO4_GSC_PSRCR_CBL_TCS_USC_TC		0x00000100	// -USC TxClk
#define	SIO4_GSC_PSRCR_CBL_TCS_USC_RC		0x00000140	// -USC RxClk
#define	SIO4_GSC_PSRCR_CBL_TCS_CBL_RC		0x00000180	// -USC RxClk
#define	SIO4_GSC_PSRCR_CBL_CTS				0x00000600	// USC CTS Setup
#define	SIO4_GSC_PSRCR_CBL_CTS_DISABLE		0x00000000	// -Disable
#define	SIO4_GSC_PSRCR_CBL_CTS_CBL_IN		0x00000200	// -Input from Cable
#define	SIO4_GSC_PSRCR_CBL_CTS_CBL_OUT		0x00000600	// -Output to Cable
#define	SIO4_GSC_PSRCR_CBL_CTS_OUT			0x00006000	// Cable CTS Output
#define	SIO4_GSC_PSRCR_CBL_DCD				0x00001800	// USC DCD Setup
#define	SIO4_GSC_PSRCR_CBL_DCD_DISABLE		0x00000000	// -Disable
#define	SIO4_GSC_PSRCR_CBL_DCD_DCD_IN		0x00000800	// -DCD in from cable
#define	SIO4_GSC_PSRCR_CBL_DCD_CTS_IN		0x00001000	// -CTS in from Cable
#define	SIO4_GSC_PSRCR_CBL_DCD_DCD_OUT		0x00001800	// -Output to Cable
#define	SIO4_GSC_PSRCR_CBL_DCD_OUT			0x00018000	// Cable DCD Output
#define	SIO4_GSC_PSRCR_CBL_TXD				0x00180000	// Cable TxD Source
#define	SIO4_GSC_PSRCR_CBL_TXD_USC_TXD		0x00000000	// -Output USC Txd
#define	SIO4_GSC_PSRCR_CBL_TXD_DRV_LOW		0x00100000	// -Drive Low
#define	SIO4_GSC_PSRCR_CBL_TXD_DRV_HI		0x00180000	// -Drive High

#define	SIO4_GSC_PSRCR_MP_PROT				0x0F000000	// Protocol
#define	SIO4_GSC_PSRCR_DCE_MODE				0x10000000	// Enable DCE Mode
#define	SIO4_GSC_PSRCR_LB_ENABLE			0x20000000	// Loop Back Enable
#define	SIO4_GSC_PSRCR_TERM_DISABLE			0x40000000	// Disable Term.
#define	SIO4_GSC_PSRCR_DCEDTE_ENABLE		0x80000000	// Enable DCE/DTE

// These are the masks for the Almost Registers.
#define	SIO4_FIFO_ALMOST_EMPTY_MASK			0x0000FFFF
#define	SIO4_FIFO_ALMOST_FULL_MASK			0xFFFF0000
#define	SIO4_FIFO_ALMOST_EMPTY_SHIFT		0
#define	SIO4_FIFO_ALMOST_FULL_SHIFT			16

// These are for the interrupts.
#define	SIO4_IRQ_SYNC_DETECT				0x00000001
#define	SIO4_IRQ_USC						0x00000008
#define	SIO4_IRQ_TFE						0x00010000
#define	SIO4_IRQ_TFAE						0x00000002
#define	SIO4_IRQ_TFF						0x00020000
#define	SIO4_IRQ_RFE						0x00040000
#define	SIO4_IRQ_RFAF						0x00000004
#define	SIO4_IRQ_RFF						0x00080000

// These are for the Prog Osc Control/Status Register
#define	SIO4_GSC_POCSR_PROGRAM				0x00000001	// Program the CY22393.
#define	SIO4_GSC_POCSR_PRG_DONE				0x00000001	// Programming is done.
#define	SIO4_GSC_POCSR_PRG_ERR				0x00000002	// Programming Failed.
#define	SIO4_GSC_POCSR_MSR_DONE				0x00000004	// Clock measurement is done.
#define	SIO4_GSC_POCSR_PD_SET				0x00000080	// Post Divider Set
#define	SIO4_GSC_POCSR_MEASURE				0xFFFFFF00	// Frequency / 10


// USC Registers
#define	SIO4_USC_ENCODE(s,o)				SIO4_REG_ENCODE(SIO4_REG_USC,0,0,0,s,o)

#define	SIO4_USC_CCAR						SIO4_USC_ENCODE(2, 0)	// Channel Command/Address Register
#define	SIO4_USC_CMR						SIO4_USC_ENCODE(2, 2)	// Channel Mode Register
#define	SIO4_USC_CCSR						SIO4_USC_ENCODE(2, 4)	// Channel Command/Status Register
#define	SIO4_USC_CCR						SIO4_USC_ENCODE(2, 6)	// Channel Control Register
#define	SIO4_USC_PRR						SIO4_USC_ENCODE(2, 8)	// Primary Reserved Register
#define	SIO4_USC_SRR						SIO4_USC_ENCODE(2,10)	// Secondary Reserved Register
#define	SIO4_USC_TMDR						SIO4_USC_ENCODE(2,12)	// Test Mode Data Register
#define	SIO4_USC_TMCR						SIO4_USC_ENCODE(2,14)	// Test Mode Control Register
#define	SIO4_USC_CMCR						SIO4_USC_ENCODE(2,16)	// Clock Mode Control Register
#define	SIO4_USC_HCR						SIO4_USC_ENCODE(2,18)	// Hardware Configuration Register
#define	SIO4_USC_IVR						SIO4_USC_ENCODE(2,20)	// Interrupt Vector Register
#define	SIO4_USC_IOCR						SIO4_USC_ENCODE(2,22)	// I/O Control Register
#define	SIO4_USC_ICR						SIO4_USC_ENCODE(2,24)	// Interrupt Control Register
#define	SIO4_USC_DCCR						SIO4_USC_ENCODE(2,26)	// Daisy-Chain Control Register
#define	SIO4_USC_MISR						SIO4_USC_ENCODE(2,28)	// Miscellaneous Interrupt Status Register
#define	SIO4_USC_SICR						SIO4_USC_ENCODE(2,30)	// Status Interrupt Control Register
#define	SIO4_USC_RDR						SIO4_USC_ENCODE(2,32)	// Receive Data Register
#define	SIO4_USC_RMR						SIO4_USC_ENCODE(2,34)	// Receive Mode Register
#define	SIO4_USC_RCSR						SIO4_USC_ENCODE(2,36)	// Receive Command Status Register
#define	SIO4_USC_RICR						SIO4_USC_ENCODE(2,38)	// Receive Interrupt Control Register
#define	SIO4_USC_RSR						SIO4_USC_ENCODE(2,40)	// Receive Sync Register
#define	SIO4_USC_RCLR						SIO4_USC_ENCODE(2,42)	// Receive Count Limit Register
#define	SIO4_USC_RCCR						SIO4_USC_ENCODE(2,44)	// Receive Character Count Register
#define	SIO4_USC_TC0R						SIO4_USC_ENCODE(2,46)	// Time Constant 0 Register
#define	SIO4_USC_TDR						SIO4_USC_ENCODE(2,48)	// Transmit Data Register
#define	SIO4_USC_TMR						SIO4_USC_ENCODE(2,50)	// Transmit Mode Register
#define	SIO4_USC_TCSR						SIO4_USC_ENCODE(2,52)	// Transmit Command/Status Register
#define	SIO4_USC_TICR						SIO4_USC_ENCODE(2,54)	// Transmit Interrupt Control Register
#define	SIO4_USC_TSR						SIO4_USC_ENCODE(2,56)	// Transmit Sync Register
#define	SIO4_USC_TCLR						SIO4_USC_ENCODE(2,58)	// Transmit Count Limit Register
#define	SIO4_USC_TCCR						SIO4_USC_ENCODE(2,60)	// Transmit Character Count Register
#define	SIO4_USC_TC1R						SIO4_USC_ENCODE(2,62)	// Time Constant 1 Register

// USC Channel Command/Address Register.
#define	SIO4_USC_CCAR_UL					0x0001	// U//L
#define	SIO4_USC_CCAR_RA					0x003E	// RegAddr
#define	SIO4_USC_CCAR_BW					0x0040	// B//W
#define	SIO4_USC_CCAR_CL					0x0080	// ChanLoad
#define	SIO4_USC_CCAR_RTM					0x0300	// RTMode

#define	SIO4_USC_CCAR_RTR					0x0400	// RTReset
#define	SIO4_USC_CCAR_RTR_RESET				0x0400	// Reset
#define	SIO4_USC_CCAR_RTR_RELEASE			0x0000	// Release

#define	SIO4_USC_CCAR_RTC					0xF800	// RTCmd

// USC Hardware Configuration Register
#define	SIO4_USC_HCR_BRG0E					0x0001	// BRG0E
#define	SIO4_USC_HCR_BRG0E_DISABLE			0x0000	// Disable
#define	SIO4_USC_HCR_BRG0E_ENABLE			0x0001	// Enable

#define	SIO4_USC_HCR_BRG0S					0x0002	// BRG0S
#define	SIO4_USC_HCR_BRG0S_CONT				0x0000	// Continuous
#define	SIO4_USC_HCR_BRG0S_SINGLE			0x0002	// Single

#define	SIO4_USC_HCR_RAM					0x000C	// RxAMode
#define	SIO4_USC_HCR_RAM_DMAA				0x0004	// DMA Acknowledge, REQUIRED

#define	SIO4_USC_HCR_BRG1E					0x0010	// BRG1E
#define	SIO4_USC_HCR_BRG1E_DISABLE			0x0000	// Disable
#define	SIO4_USC_HCR_BRG1E_ENABLE			0x0010	// Enable

#define	SIO4_USC_HCR_BRG1S					0x0020	// BRG1S
#define	SIO4_USC_HCR_BRG1S_CONT				0x0000	// Continuous
#define	SIO4_USC_HCR_BRG1S_SINGLE			0x0020	// Single

#define	SIO4_USC_HCR_TAM					0x00C0	// TxAMode
#define	SIO4_USC_HCR_TAM_DMAA				0x0040	// DMA Acknowledge, REQUIRED

#define	SIO4_USC_HCR_DPLLM					0x0300	// DPLLMode
#define	SIO4_USC_HCR_DPLLM_DISABLE			0x0000	// Disable
#define	SIO4_USC_HCR_DPLLM_NRZ				0x0100	// NRZ Modes
#define	SIO4_USC_HCR_DPLLM_BP_MRK_SPC		0x0200	// Biphase-Mark or -Space
#define	SIO4_USC_HCR_DPLLM_BP_LEVEL			0x0300	// Biphase Level

#define	SIO4_USC_HCR_DPLLD					0x0C00	// DPLLDiv
#define	SIO4_USC_HCR_DPLLD_32				0x0000	// 32
#define	SIO4_USC_HCR_DPLLD_16				0x0400	// 16
#define	SIO4_USC_HCR_DPLLD_8				0x0800	// 8
#define	SIO4_USC_HCR_DPLLD_4				0x0C00	// 4, COUNTER 1 ONLY

#define	SIO4_USC_HCR_CVOK					0x1000	// CVOK

#define	SIO4_USC_HCR_CTR1DS					0x2000	// CTR1DSel
#define	SIO4_USC_HCR_CTR1DS_CTR0D			0x0000	// CTR0Div
#define	SIO4_USC_HCR_CTR1DS_DPLLD			0x2000	// DPLLDiv

#define	SIO4_USC_HCR_CTR0D					0xC000	// CTR0Div
#define	SIO4_USC_HCR_CTR0D_32				0x0000	// 32
#define	SIO4_USC_HCR_CTR0D_16				0x4000	// 16
#define	SIO4_USC_HCR_CTR0D_8				0x8000	// 8
#define	SIO4_USC_HCR_CTR0D_4				0xC000	// 4

// USC Input/Output Control Register
#define	SIO4_USC_IOCR_RCM					0x0007	// RxCMode
#define	SIO4_USC_IOCR_RCM_IN				0x0000	// -Input
#define	SIO4_USC_IOCR_RCM_RCLK				0x0001	// -RxCLK
#define	SIO4_USC_IOCR_RCM_RCC				0x0002	// -Receive Char Clock
#define	SIO4_USC_IOCR_RCM_RSYNC				0x0003	// -RxSYNC
#define	SIO4_USC_IOCR_RCM_BRG0				0x0004	// -BRG0
#define	SIO4_USC_IOCR_RCM_BRG1				0x0005	// -BRG1
#define	SIO4_USC_IOCR_RCM_CTR1				0x0006	// -CTR1
#define	SIO4_USC_IOCR_RCM_DPLL				0x0007	// -Rx output of DPLL
#define	SIO4_USC_IOCR_TCM					0x0038	// TxCMode
#define	SIO4_USC_IOCR_TCM_IN				0x0000	// -Input
#define	SIO4_USC_IOCR_TCM_TCLK				0x0008	// -TxCLK
#define	SIO4_USC_IOCR_TCM_TCC				0x0010	// -Transmit Char Clock
#define	SIO4_USC_IOCR_TCM_TC				0x0018	// -Transmit Complete
#define	SIO4_USC_IOCR_TCM_BRG0				0x0020	// -BRG0
#define	SIO4_USC_IOCR_TCM_BRG1				0x0028	// -BRG1
#define	SIO4_USC_IOCR_TCM_CTR1				0x0030	// -CTR1
#define	SIO4_USC_IOCR_TCM_DPLL				0x0038	// -Tx output of DPLL
#define	SIO4_USC_IOCR_TDM					0x00C0	// TxDMode
#define	SIO4_USC_IOCR_TDM_OUT				0x0000	// -Transmit Out
#define	SIO4_USC_IOCR_TDM_HIZ				0x0040	// -High Impedance
#define	SIO4_USC_IOCR_TDM_LOW				0x0080	// -Low
#define	SIO4_USC_IOCR_TDM_HI				0x00C0	// -High
#define	SIO4_USC_IOCR_RRM					0x0300	// RxRMode
#define	SIO4_USC_IOCR_RRM_DMAR				0x0100	// -DMA Request, REQUIRED
#define	SIO4_USC_IOCR_TRM					0x0C00	// RxRMode
#define	SIO4_USC_IOCR_TRM_DMAR				0x0400	// -DMA Request, REQUIRED
#define	SIO4_USC_IOCR_DCDM					0x3000	// DCDMode
#define	SIO4_USC_IOCR_DCDM_RCD_IN			0x0000	// -Rx Carrier Detect Input
#define	SIO4_USC_IOCR_DCDM_RSD_IN			0x1000	// -Rx Sync Detect Input
#define	SIO4_USC_IOCR_DCDM_LOW				0x2000	// -Low
#define	SIO4_USC_IOCR_DCDM_HI				0x3000	// -High
#define	SIO4_USC_IOCR_CTSM					0xC000	// CTSMode
#define	SIO4_USC_IOCR_CTSM_IN				0x0000	// -CTS Input
#define	SIO4_USC_IOCR_CTSM_LOW				0x8000	// -Low
#define	SIO4_USC_IOCR_CTSM_HI				0xC000	// -High



// USCs Command Status register
#define	IDLE_LINE_COND_MASK					0x7
#define	WAIT_ON_UNDERRUN_MASK				0x8

// These are the masks for the Clock Mode Control Register.
#define	RX_SOURCE_MASK						0x07
#define	TX_SOURCE_MASK						0x38
#define	DPLL_SOURCE_MASK					0xC0	// This value was 0xF0 in NT & VxWorks code.
#define	BRG0_SOURCE_MASK					0x03
#define	BRG1_SOURCE_MASK					0x0C
#define	CTR0_SOURCE_MASK					0x30
#define	CTR1_SOURCE_MASK					0xC0
#define	RX_SOURCE_SHIFT						0
#define	TX_SOURCE_SHIFT						3
#define	DPLL_SOURCE_SHIFT					6
#define	BRG0_SOURCE_SHIFT					0
#define	BRG1_SOURCE_SHIFT					2
#define	CTR0_SOURCE_SHIFT					4
#define	CTR1_SOURCE_SHIFT					6

// Channel Command Status Register.
#define	DPLL_RESYNC_MASK					0x03
#define	DPLL_RESYNC_SHIFT					0

// These are the masks for the Channel Control Register.
#define	RX_STATUS_BLOCK_OPTIONS_MASK		0xC0
#define	WAIT_FOR_RX_DMA_TRIGGER_MASK		0x20
#define	TX_STATUS_BLOCK_OPTIONS_MASK		0xC0
#define	WAIT_FOR_TX_DMA_TRIGGER_MASK		0x20
#define	WAIT_FOR_RX_DMA_TRIGGER_SHIFT		5
#define	RX_STATUS_BLOCK_OPTIONS_SHIFT		6
#define	WAIT_FOR_TX_DMA_TRIGGER_SHIFT		5
#define	TX_STATUS_BLOCK_OPTIONS_SHIFT		6

// MODES
#define	ASYNC_MODE							0x0
#define	EXT_SYNC_MODE						0x1
#define	ISOCHR_MODE							0x2
#define	ASYNC_CV_MODE						0x3
#define	MONOSYNC_MODE						0x4
#define	BOSUMC_MODE							0x5
#define	HDLC_MODE							0x6
#define	TRANS_BISYNC_MODE					0x7
#define	NBIP_MODE							0x8
#define	E802_3_MODE							0x9
#define	SLAVED_MONOSYNC_MODE				0xC
#define	HDLC_LOOP_MODE						0xE

// TX HDLC MODE
#define	SHARED_ZERO_FLAGS_SHIFT				4
#define	TX_PREAMBLE_ENABLE_SHIFT			5
#define	TX_UNDERRUN_SHIFT					6

// RX HDLC MODE
#define	ADDR_SEARCH_SHIFT					4
#define	B16_CTRL_ENABLE_SHIFT				6
#define	LOGICAL_CTRL_ENABLE_SHIFT			7

// TX HDLC SDLC LOOP MODE
#define	TX_ACTIVE_ON_POLL_SHIFT				5

// TX ISOCHRONOUS MODE
#define	TWO_STOP_BITS_SHIFT					6

// ASYNCHRONOUS MODES
#define	CLOCK_RATE_SHIFT					4
#define	STOP_BITS_SHIFT						6

// ****************************************************************************
// SIO4_INIT_CHANNEL

#define	ENABLE_SHIFT						0
#define	DATA_LENGTH_SHIFT					2
#define	PARITY_ENABLE_SHIFT					5
#define	PARITY_TYPE_SHIFT					6
#define	DATA_FORMAT_SHIFT					5
#define	TX_WAIT_ON_UNDERRUN_SHIFT			3
#define	TX_IDLE_LINE_COND_SHIFT				0
#define	DATA_FORMAT_MASK					0xE0
#define	ZILOG_MODE_MASK						0x3

typedef enum CharLength
{
	BITS8,
	BITS1,
	BITS2,
	BITS3,
	BITS4,
	BITS5,
	BITS6,
	BITS7
} CHAR_LENGTH;

typedef enum DataFormat
{
	NRZ,
	NRZB,
	NRZI_MARK,
	NRZI_SPACE,
	BIPHASE_MARK,
	BIPHASE_SPACE,
	BIPHASE_LEVEL,
	DIFF_BIPHASE_LEVEL
} DATA_FORMAT;

typedef enum EnableType
{
	DISABLE_IMMED,
	DISABLE_AFTER_TX_RX,
	ENABLE_WO_AUTO,
	ENABLE_WITH_AUTO
} ENABLE_TYPE;

typedef enum IdleLineCond
{
	SYNC_FLAG_NORMAL_IDLE,
	ALTERNATE_1_AND_0_IDLE,
	ALL_ZEROS_IDLE,
	ALL_ONES_IDLE,
	RESERVED_IDLE,
	ALTERNATE_MARK_AND_SPACE_IDLE,
	SPACE_IDLE,
	MARK_IDLE
} IDLE_LINE_COND;

typedef enum ParityType
{
	EVEN_PARITY,
	ODD_PARITY,
	SPACE_PARITY,
	MARK_PARITY
} PARITY_TYPE;

typedef enum SIO4Mode
{
	NORMAL,
	AUTO_ECHO,
	EXT_LOCAL_LOOPBACK,
	INT_LOCAL_LOOPBACK
} SIO4_MODE;

typedef struct SIO4InitChan
{
	SIO4_MODE		eMode;
	UINT32			u32BaudRate;
	ENABLE_TYPE		eRxEnable;
	DATA_FORMAT		eRxDataFormat;
	CHAR_LENGTH		eRxDataLength;
	UINT8			u8RxParityEnable;
	PARITY_TYPE		eRxParityType;
	ENABLE_TYPE		eTxEnable;
	DATA_FORMAT		eTxDataFormat;
	CHAR_LENGTH		eTxDataLength;
	UINT8			u8TxParityEnable;
	PARITY_TYPE		eTxParityType;
	IDLE_LINE_COND	eTxIdleLineCond;
	UINT8			u8TxWaitOnUnderrun;
	UINT8			u8EnableRxUpper;
	UINT8			u8EnableRxLower;
	UINT8			u8EnableTxUpper;
	UINT8			u8EnableTxLower;
	UINT16			u16TxAlmostEmpty;
	UINT16			u16TxAlmostFull;
	UINT16			u16RxAlmostEmpty;
	UINT16			u16RxAlmostFull;
	UINT8			u8EnableTxCableUpper;
	UINT8			u8EnableTxCableLower;
	UINT8			u8EnableRxCableUpper;
	UINT8			u8EnableRxCableLower;
} SIO4_INIT_CHAN;

// ****************************************************************************
// SIO4_SEND_CHANNEL_COMMAND

#define	CHAN_CMD_MASK						0xF8
#define	CHAN_CMD_SHIFT						4

typedef enum ChannelCmd
{
	NULL_CMD				=  0,
	RESET_HIGHEST_IUS		=  2,
	TRIG_CHAN_LOAD_DMA_CMD	=  4,
	TRIG_RX_DMA_CMD			=  5,
	TRIG_TX_DMA_CMD			=  6,
	TRIG_RX_TX_DMA_CMD		=  7,
	RX_FIFO_PURGE_CMD		=  9,
	TX_FIFO_PURGE_CMD		= 10,
	RX_TX_FIFO_PURGE_CMD	= 11,
	LOAD_RX_CHAR_CNT_CMD	= 13,
	LOAD_TX_CHAR_CNT_CMD	= 14,
	LOAD_RX_TX_CHAR_CNT_CMD	= 15,
	LOAD_TC0_CMD			= 17,
	LOAD_TC1_CMD			= 18,
	LOAD_TC0_TC1_CMD		= 19,
	SEL_LSB_FIRST_CMD		= 20,
	SEL_MSB_FIRST_CMD		= 21,
	SEL_STRAIGHT_CMD		= 22,
	SEL_SWAPPED_CMD			= 23,
	RX_PURGE_CMD			= 25
} SIO4_CHAN_CMD;

// ****************************************************************************
// SIO4_RESET_FIFO

typedef enum TxRx
{
	TX_FIFO			= 1,
	RX_FIFO			= 2,
	TX_AND_RX_FIFO	= 3
} TX_RX;

// ****************************************************************************
// SIO4_SET_READ_TIMEOUT
// SIO4_SET_WRITE_TIMEOUT

#define	SIO4_TIMEOUT_DEFAULT				5

// ****************************************************************************
// SIO4_READ_REGISTER
// SIO4_READ_REGISTER_RAW
// SIO4_WRITE_REGISTER

typedef struct RegisterParams
{
	UINT32	u32RegisterNumber;
	UINT32	u32Value;
} REGISTER_PARAMS;

// ****************************************************************************
// SIO4_SET_XMT_ASYNC_PROT

typedef enum ClockRate
{
	RATE_X16,
	RATE_X32,
	RATE_X64,
	LOCK_RATE
} CLOCK_RATE;

typedef enum StopBits
{
	ONE_STOP_BIT,
	TWO_STOP_BITS,
	ONE_STOP_BIT_SHAVED,
	TWO_STOP_BITS_SHAVED
} STOP_BITS;

typedef struct XmtASYNCProtocol
{
	CLOCK_RATE	eTxClockRate;
	STOP_BITS	eTxStopBits;
} XMT_ASYNC_PROTOCOL;

// ****************************************************************************
// SIO4_SET_RCV_ASYNC_PROT

typedef struct RcvASYNCProtocol
{
	CLOCK_RATE eRxClockRate;
} RCV_ASYNC_PROTOCOL;

// ****************************************************************************
// SIO4_SET_XMT_ISOCHR_PROT

typedef struct XmtISOCHRProt
{
	UINT8	u8TwoStopBits;
}XMT_ISOCHR_PROTOCOL, *PXMT_ISOCHR_PROTOCOL;

// ****************************************************************************
// SIO4_SET_XMT_HDLC_PROT

typedef enum TxUnderrun
{
	ABORT_COND,
	EXT_ABORT_COND,
	FLAG_COND,
	CRC_FLAG_COND
} TX_UNDERRUN;

typedef struct XmtHDLCProtocol
{
	UINT8		u8SharedZeroFlags;
	UINT8		u8TxPreambleEnable;
	TX_UNDERRUN eTxUnderrun;
} XMT_HDLC_PROTOCOL;

// ****************************************************************************
// SIO4_SET_RCV_HDLC_PROT

typedef enum AddrSearchMode
{
	DISABLED,
	ONE_BYTE_NO_CTRL,
	ONE_BYTE_PLUS_CTRL,
	EXT_PLUS_CTRL
} ADDR_SEARCH_MODE;

typedef struct RcvHDLCProtocol
{
	ADDR_SEARCH_MODE	eAddrSearchMode;
	UINT8				u816BitControlEnable;
	UINT8				u8LogicalControlEnable;
} RCV_HDLC_PROTOCOL;

// ****************************************************************************
// SIO4_SET_XMT_HDLC_SDLC_LOOP_PROT

typedef struct XmtHDLCSDLCLoopProtocol
{
	UINT8			u8SharedZeroFlags;
	UINT8			u8TxActiveOnPoll;
	TX_UNDERRUN		eTxUnderrun;
} XMT_HDLC_SDLC_LOOP_PROTOCOL;

// ****************************************************************************
// SIO4_SET_BRG0_SOURCE
// SIO4_SET_BRG1_SOURCE
// SIO4_SET_CTR0_SOURCE
// SIO4_SET_CTR1_SOURCE
// SIO4_SET_DPLL_SOURCE
// SIO4_SET_TX_CLOCK_SOURCE
// SIO4_SET_RX_CLOCK_SOURCE

typedef enum ClockSource
{
	CLOCK_DISABLED,
	RXC_PIN_CLOCK,
	TXC_PIN_CLOCK,
	DPLL_CLOCK,
	BRG0_CLOCK,
	BRG1_CLOCK,
	CTR0_CLOCK,
	CTR1_CLOCK
} CLOCK_SOURCE;

// ****************************************************************************
// SIO4_CLEAR_DPLL_STATUS

#define	CLEAR_DPLL_IN_SYNC					0x10
#define	CLEAR_DPLL_MISSING_2_CLOCKS			0x08
#define	CLEAR_DPLL_MISSING_1_CLOCK			0x04
#define	CLEAR_DPLL_ALL_STATUS				0x1C

// ****************************************************************************
// SIO4_SELECT_DPLL_RESYNC

typedef enum DPLLResync
{
	BOTH_EDGES,
	RISING_EDGE,
	FALLING_EDGE,
	SYNC_INHIBIT
} DPLL_RESYNC;

// ****************************************************************************
// SIO4_SET_DPLL_DIVISOR

typedef enum DPLLDivisor
{
	DPLL_32X,
	DPLL_16X,
	DPLL_8X
} DPLL_DIVISOR;

// ****************************************************************************
// SIO4_SET_DPLL_MODE

typedef enum DPLLMode
{
	DPLL_DISABLED,
	DPLL_NRZ_NRZI,
	DPLL_BIPHASE_MARK_SPACE,
	DPLL_BIPHASE_LEVEL
} DPLL_MODE;

// ****************************************************************************
// SIO4_SET_BRG0_MODE
// SIO4_SET_BRG1_MODE

typedef enum BRGMode
{
	BRG_CONTINUOUS,
	BRG_SINGLE_CYCLE
} BRG_MODE;

// ****************************************************************************
// SIO4_INT_NOTIFY

#define	SIO4_INT_NOTIFY_SYNC_DETECTED		0x01
#define	SIO4_INT_NOTIFY_TX_FIFO_AE			0x02
#define	SIO4_INT_NOTIFY_RX_FIFO_AF			0x04
#define	SIO4_INT_NOTIFY_USC_INTERRUPTS		0x08
#define	SIO4_INT_NOTIFY_TX_FIFO_E			0x10
#define	SIO4_INT_NOTIFY_TX_FIFO_F			0x20
#define	SIO4_INT_NOTIFY_RX_FIFO_E			0x40
#define	SIO4_INT_NOTIFY_RX_FIFO_F			0x80

// ****************************************************************************
// SIO4_SET_USC_DMA_OPTIONS

typedef enum StatusBlockOptions
{
	NO_STATUS_BLOCK,
	ONE_WORD_STATUS_BLOCK,
	TWO_WORD_STATUS_BLOCK
} STATUS_BLOCK_OPTIONS;

typedef struct
{
	STATUS_BLOCK_OPTIONS	eTxStatusBlockOptions;
	UINT8					u8TxDMAWaitForTrigger;
	STATUS_BLOCK_OPTIONS	eRxStatusBlockOptions;
	UINT8					u8RxDMAWaitForTrigger;
} USC_DMA_OPTIONS;

// ****************************************************************************
// SIO4_READ_INT_STATUS

typedef struct IntStatus
{
	UINT8	u8SIO4Status;
} SIO4_INTERRUPT_STATUS;

// ****************************************************************************
// SIO4_GET_DRIVER_INFO

typedef struct SIO4DriverInfo
{
	UINT8	u8VersionNumber[16];
	UINT8	u8Built[32];
}SIO4_DRIVER_INFO;

// ****************************************************************************
// SIO4_BOARD_JUMPERS

#define	SIO4_BOARD_JUMPERS_UNSUPPORTED		(-1)

// ****************************************************************************
// SIO4_FEATURE_TEST

#define	SIO4_FEATURE_COUNT					0	// Count of features.
#define	SIO4_FEATURE_BOARD_RESET			1	// Board Reset in BCR
#define	SIO4_FEATURE_REG_BSR				2	// Board Status Register
//		SIO4_FEATURE_BSR_FIFO_PRESENT		3	// No longer supported
#define	SIO4_FEATURE_REG_FCR				4	// FIFO Count Registers
#define	SIO4_FEATURE_REG_FSR				5	// FIFO Size Registers
#define	SIO4_FEATURE_REG_FR					6	// Features Register
#define	SIO4_FEATURE_RX_FIFO_FULL_CFG_GLB	7	// BCR Rx FIFO Full Config - GLOBAL
#define	SIO4_FEATURE_REG_PSRCR				8	// Pin Source Register
#define	SIO4_FEATURE_REG_PSTSR				9	// Pin Status Register
#define	SIO4_FEATURE_IRQ_32					10	// 32 Interrupts
#define	SIO4_FEATURE_OSC_CHIP				11	// Oscillator Chip
#define	SIO4_FEATURE_OSC_PER_CHANNEL		12	// Oscillator per channel
#define	SIO4_FEATURE_OSC_PROGRAM			13	// Will driver program it?
#define	SIO4_FEATURE_OSC_MEASURE			14	// Measure the frequency.
#define	SIO4_FEATURE_MODEL_SYNC				15	// Is this an SIO4 SYNC?
#define	SIO4_FEATURE_MODEL_Z16C30			16	// Is this a Z16C30 model?
#define	SIO4_FEATURE_MP						17	// Is Mult Proc feature here?
#define	SIO4_FEATURE_MP_CHIP				18	// MP Chip
#define	SIO4_FEATURE_MP_PROGRAM				19	// Can we program changes?
#define	SIO4_FEATURE_DMDMA_SCD				20	// BCR Single Cycle Disable?
#define	SIO4_FEATURE_OSC_PD_MAX				21	// # of Firmware Post Divider bits
#define	SIO4_FEATURE_REG_PORD2R				22	// Is this register supported?
#define	SIO4_FEATURE_FW_TYPE				23	// sio4_fw_type_t
#define	SIO4_FEATURE_SIO4_TYPE				24	// sio4_type_t
#define	SIO4_FEATURE_LEGACY_CABLE			25	// Legacy Cable Interface?
#define	SIO4_FEATURE_USER_JUMPER_SENSE		26	// Bit value if jumper is present.
#define	SIO4_FEATURE_USER_JUMPER_QTY		27	// Number of user jumpers
#define	SIO4_FEATURE_REG_CCR				28	// Is reg CCR supported?
#define	SIO4_FEATURE_REG_TSR				29	// Is reg TSR supported?
#define	SIO4_FEATURE_REG_IELR				30	// Is reg IELR supported?
#define	SIO4_FEATURE_REG_IHLR				31	// Is reg IHLR supported?
#define	SIO4_FEATURE_REG_SBR				32	// Is reg SBR supported?
#define	SIO4_FEATURE_REG_GPIOSR				33	// Is reg GPIOSR supported?
#define	SIO4_FEATURE_REG_IOCR				34	// Is reg IOCR supported?
#define	SIO4_FEATURE_REG_RCR				35	// Is reg RCR supported?
#define	SIO4_FEATURE_REG_TCR				36	// Is reg TCR supported?
#define	SIO4_FEATURE_REG_FTR				37	// Is reg FTR supported?
#define	SIO4_FEATURE_FORM_FACTOR			38	// sio4_form_factor_t;
#define	SIO4_FEATURE_BUS_SPEED				39	// 0, 33 or 66
#define	SIO4_FEATURE_BUS_WIDTH				40	// 0, 32 or 64
#define	SIO4_FEATURE_INDEX_CHANNEL			41	// 0-3
#define	SIO4_FEATURE_CHANNEL_QTY			42	// 4 or 8
#define	SIO4_FEATURE_FIFO_SIZE_RX			43	// Rx FIFO Size, 0 if unknown
#define	SIO4_FEATURE_FIFO_SIZE_TX			44	// Tx FIFO Size, 0 if unknown
#define	SIO4_FEATURE_FIFO_SIZE_TOTAL		45	// Total FIFO size for 4 chans.
#define	SIO4_FEATURE_INDEX_SUBDEVICE		46	// SIO4: 0, SIO8: 0, 1
#define	SIO4_FEATURE_REG_PCR				47	// Programmable Clock Register?
#define	SIO4_FEATURE_REG_POCSR				48	// Programmable Oscillator Control/Status Register?
#define	SIO4_FEATURE_REG_PORAR				49	// Programmable Oscillator RAM Address Register
#define	SIO4_FEATURE_REG_PORDR				50	// Programmable Oscillator RAM Data Register
#define	SIO4_FEATURE_REG_PSRCR_BITS			51	// Bitmap of PSRCR supported bits
#define	SIO4_FEATURE_USER_JUMPER_VAL		52	// Value from User Jumper pins
#define	SIO4_FEATURE_RX_FIFO_FULL_CFG		53	// CSR Rx FIFO Full Config - channel specific
#define	SIO4_FEATURE_MODEL_BASE				54	// sio4_model_t
#define	SIO4_FEATURE_REG_PSTSR_BITS			55	// Bitmap of PSRCR supported bits
#define	SIO4_FEATURE_DEVICE_QTY				56	// SIO4 = 1, SIO8 = 2
#define	SIO4_FEATURE_FIFO_SPACE_CFG			57	// FIFO Space Reconfiguration?
#define	SIO4_FEATURE_INDEX_DEVICE			58	// 0, 1, 2, 3, 4, 5 ...
#define	SIO4_FEATURE_LED_CHANNEL			59	// How many channel LEDs are there?
#define	SIO4_FEATURE_LED_MAIN				60	// How many main LEDs are there?
#define	SIO4_FEATURE_RX_FIFO_OVERRUN		61	// Rx FIFO Overrun supported?
#define	SIO4_FEATURE_RX_FIFO_UNDERRUN		62	// Rx FIFO Underrun supported?
#define	SIO4_FEATURE_RX_STATUS_WORD			63	// CSR D3: Rx Status Word Enable?
#define	SIO4_FEATURE_TIME_STAMP				64	// Is the timestamp feature supported?
#define	SIO4_FEATURE_TX_FIFO_EMPTY_CFG		65	// CSR D18/D26: Tx Disable on FIFO Empty?
#define	SIO4_FEATURE_TX_FIFO_OVERRUN		66	// Tx FIFO Overrun supported?
#define	SIO4_FEATURE_MP_BITMAP				67	// Supported Valid MP protocols
#define	SIO4_FEATURE_INDEX_BOARD			68	// Index of each SIO4 (SIO8 counts as two)
#define	SIO4_FEATURE_FW_TYPE_CONFIG			69	// Is the FW Type configurable?
#define	SIO4_FEATURE_LAST_INDEX				69	// Highest feature index

#define	SIO4_FEATURE_UNKNOWN				(-1)// The feature is not known.
#define	SIO4_FEATURE_NO						0	// The feature is unsupported.
#define	SIO4_FEATURE_YES					1	// The feature is supported.

typedef enum
{
	SIO4_FORM_FACTOR_PCI		= 1,
	SIO4_FORM_FACTOR_PMC		= 2,
	SIO4_FORM_FACTOR_CPCI		= 3,
	SIO4_FORM_FACTOR_PC104P		= 4,
	SIO4_FORM_FACTOR_PCIE		= 5,
	SIO4_FORM_FACTOR_XMC		= 6,

	SIO4_FORM_FACTOR_PCI66		= 100,
	SIO4_FORM_FACTOR_PCIE4,
	SIO4_FORM_FACTOR_PMC66,
	SIO4_FORM_FACTOR_UNKNOWN			// must exceed field range
} sio4_form_factor_t;

typedef enum
{
	SIO4_FW_TYPE_Z16C30		= 0x01,
	SIO4_FW_TYPE_SYNC		= 0x04
} sio4_fw_type_t;

typedef enum
{
	SIO4_TYPE_SIO4,
	SIO4_TYPE_SIO4A,
	SIO4_TYPE_SIO4AR,
	SIO4_TYPE_SIO4AHRM,
	SIO4_TYPE_SIO4B,
	SIO4_TYPE_SIO4BX,
	SIO4_TYPE_SIO4BXR,
	SIO4_TYPE_SIO8BXS,
	SIO4_TYPE_SIO4BX2,
	SIO4_TYPE_SIO8BX2

} sio4_type_t;

typedef enum
{
	SIO4_MODEL_SIO4,
	SIO4_MODEL_SIO4A,
	SIO4_MODEL_SIO4A_SYNC,
	SIO4_MODEL_SIO4AR,
	SIO4_MODEL_SIO4AR_SYNC,
	SIO4_MODEL_SIO4AHRM,
	SIO4_MODEL_SIO4AHRM_SYNC,
	SIO4_MODEL_SIO4B,
	SIO4_MODEL_SIO4B_SYNC,
	SIO4_MODEL_SIO4BX,
	SIO4_MODEL_SIO4BX_SYNC,
	SIO4_MODEL_SIO4BXR,
	SIO4_MODEL_SIO4BXR_SYNC,
	SIO4_MODEL_SIO8BXS,
	SIO4_MODEL_SIO8BXS_SYNC,
	SIO4_MODEL_SIO4BX2,
	SIO4_MODEL_SIO4BX2_SYNC,
	SIO4_MODEL_SIO8BX2,
	SIO4_MODEL_SIO8BX2_SYNC

} sio4_model_t;

// ****************************************************************************
// SIO4_RX_FIFO_COUNT
// SIO4_TX_FIFO_COUNT

#define	SIO4_FIFO_COUNT_UNKNOWN				(-1)

// ****************************************************************************
// SIO4_RX_FIFO_FULL_CFG_CHAN				CCR D19 (when supported)

#define	SIO4_RX_FIFO_FULL_CFG_CHAN_OVER		0
#define	SIO4_RX_FIFO_FULL_CFG_CHAN_HALT		1
#define	SIO4_RX_FIFO_FULL_CFG_CHAN_READ		(-1)

// ****************************************************************************
// SIO4_RX_FIFO_FULL_CFG_GLB				BCR D8

#define	SIO4_RX_FIFO_FULL_CFG_GLB_OVER		0	// per channel settings take effect
#define	SIO4_RX_FIFO_FULL_CFG_GLB_HALT		1	// overrides per channel setting
#define	SIO4_RX_FIFO_FULL_CFG_GLB_READ		(-1)

// ****************************************************************************
// SIO4_TX_CABLE_CONFIG

#define	SIO4_TX_CABLE_CONFIG_DISABLE		0
#define	SIO4_TX_CABLE_CONFIG_LOWER			1
#define	SIO4_TX_CABLE_CONFIG_UPPER			2
#define	SIO4_TX_CABLE_CONFIG_BOTH			3
#define	SIO4_TX_CABLE_CONFIG_READ			(-1)
#define	SIO4_TX_CABLE_CONFIG_INVALID		(-2)

// ****************************************************************************
// SIO4_RX_CABLE_CONFIG

#define	SIO4_RX_CABLE_CONFIG_DISABLE		0
#define	SIO4_RX_CABLE_CONFIG_LOWER			1
#define	SIO4_RX_CABLE_CONFIG_UPPER			2
#define	SIO4_RX_CABLE_CONFIG_READ			(-1)
#define	SIO4_RX_CABLE_CONFIG_INVALID		(-2)

// ****************************************************************************
// SIO4_TX_CABLE_CLOCK_CONFIG

#define	SIO4_TX_CABLE_CLOCK_CONFIG_PRG_CLK		0
#define	SIO4_TX_CABLE_CLOCK_CONFIG_PRG_CLK_INV	1
#define	SIO4_TX_CABLE_CLOCK_CONFIG_DRV_LOW		2
#define	SIO4_TX_CABLE_CLOCK_CONFIG_DRV_HI		3
#define	SIO4_TX_CABLE_CLOCK_CONFIG_USC_TC		4
#define	SIO4_TX_CABLE_CLOCK_CONFIG_USC_RC		5
#define	SIO4_TX_CABLE_CLOCK_CONFIG_CBL_RC		6
#define	SIO4_TX_CABLE_CLOCK_CONFIG_CBL_RAC		7
#define	SIO4_TX_CABLE_CLOCK_CONFIG_READ			(-1)
#define	SIO4_TX_CABLE_CLOCK_CONFIG_INVALID		(-2)
#define	SIO4_TX_CABLE_CLOCK_CONFIG_UNKNOWN		(-3)

// ****************************************************************************
// SIO4_TXC_USC_CONFIG						GSC PSRCR D0-D2, USC IOCR D3-D5

#define	SIO4_TXC_USC_CONFIG_IN_LOW			0	// PSRCR D0-D2: 0x2, IOCR D3-D5: 0x0
#define	SIO4_TXC_USC_CONFIG_IN_HI			1	// PSRCR D0-D2: 0x3, IOCR D3-D5: 0x0
#define	SIO4_TXC_USC_CONFIG_IN_PRG_CLK		2	// PSRCR D0-D2: 0x0, IOCR D3-D5: 0x0
#define	SIO4_TXC_USC_CONFIG_IN_PRG_CLK_INV	11	// PSRCR D0-D2: 0x1, IOCR D3-D5: 0x0
#define	SIO4_TXC_USC_CONFIG_IN_CBL_RC		3	// PSRCR D0-D2: 0x4, IOCR D3-D5: 0x0
#define	SIO4_TXC_USC_CONFIG_OUT_TCLK		4	// PSRCR D0-D2: 0x7, IOCR D3-D5: 0x1
#define	SIO4_TXC_USC_CONFIG_OUT_TCC			5	// PSRCR D0-D2: 0x7, IOCR D3-D5: 0x2
#define	SIO4_TXC_USC_CONFIG_OUT_TCOMP		6	// PSRCR D0-D2: 0x7, IOCR D3-D5: 0x3
#define	SIO4_TXC_USC_CONFIG_OUT_BRG0		7	// PSRCR D0-D2: 0x7, IOCR D3-D5: 0x4
#define	SIO4_TXC_USC_CONFIG_OUT_BRG1		8	// PSRCR D0-D2: 0x7, IOCR D3-D5: 0x5
#define	SIO4_TXC_USC_CONFIG_OUT_CTR1		9	// PSRCR D0-D2: 0x7, IOCR D3-D5: 0x6
#define	SIO4_TXC_USC_CONFIG_OUT_DPLL		10	// PSRCR D0-D2: 0x7, IOCR D3-D5: 0x7
#define	SIO4_TXC_USC_CONFIG_READ			(-1)
#define	SIO4_TXC_USC_CONFIG_INVALID			(-2)
#define	SIO4_TXC_USC_CONFIG_UNKNOWN			(-3)

// ****************************************************************************
// SIO4_RXC_USC_CONFIG

#define	SIO4_RXC_USC_CONFIG_IN_LOW			0
#define	SIO4_RXC_USC_CONFIG_IN_HI			1
#define	SIO4_RXC_USC_CONFIG_IN_PRG_CLK		2
#define	SIO4_RXC_USC_CONFIG_IN_CBL_RC		3
#define	SIO4_RXC_USC_CONFIG_OUT_TCLK		4
#define	SIO4_RXC_USC_CONFIG_OUT_TCC			5
#define	SIO4_RXC_USC_CONFIG_OUT_TCOMP		6
#define	SIO4_RXC_USC_CONFIG_OUT_BRG0		7
#define	SIO4_RXC_USC_CONFIG_OUT_BRG1		8
#define	SIO4_RXC_USC_CONFIG_OUT_CTR1		9
#define	SIO4_RXC_USC_CONFIG_OUT_DPLL		10
#define	SIO4_RXC_USC_CONFIG_READ			(-1)
#define	SIO4_RXC_USC_CONFIG_INVALID			(-2)
#define	SIO4_RXC_USC_CONFIG_UNKNOWN			(-3)

// ****************************************************************************
// SIO4_CTS_CABLE_CONFIG

#define	SIO4_CTS_CABLE_CONFIG_DISABLE		0
#define	SIO4_CTS_CABLE_CONFIG_CTS_IN		1
#define	SIO4_CTS_CABLE_CONFIG_DRV_LOW		2
#define	SIO4_CTS_CABLE_CONFIG_DRV_HI		3
#define	SIO4_CTS_CABLE_CONFIG_DCD_IN		4
#define	SIO4_CTS_CABLE_CONFIG_RTS_OUT		5
#define	SIO4_CTS_CABLE_CONFIG_READ			(-1)
#define	SIO4_CTS_CABLE_CONFIG_INVALID		(-2)
#define	SIO4_CTS_CABLE_CONFIG_UNKNOWN		(-3)

// ****************************************************************************
// SIO4_MOD_REGISTER

typedef struct RegisterModParams
{
	UINT32	u32RegisterNumber;
	UINT32	u32Value;
	UINT32	u32Mask;	// If a bit is set, a new value is applied.
} REGISTER_MOD_PARAMS;

// ****************************************************************************
// SIO4_RX_IO_MODE_CONFIG
// SIO4_TX_IO_MODE_CONFIG

#define	SIO4_IO_MODE_DEFAULT				SIO4_IO_MODE_PIO
#define	SIO4_IO_MODE_READ					(-1)
#define	SIO4_IO_MODE_PIO					0
#define	SIO4_IO_MODE_DMA					1
#define	SIO4_IO_MODE_DMDMA					2

// ****************************************************************************
// SIO4_TX_CABLE_DATA_CONFIG

#define	SIO4_TX_CABLE_DATA_CONFIG_USC_TXD	0
#define	SIO4_TX_CABLE_DATA_CONFIG_DRV_LOW	2
#define	SIO4_TX_CABLE_DATA_CONFIG_DRV_HI	3
#define	SIO4_TX_CABLE_DATA_CONFIG_READ		(-1)
#define	SIO4_TX_CABLE_DATA_CONFIG_INVALID	(-2)
#define	SIO4_TX_CABLE_DATA_CONFIG_UNKNOWN	(-3)

// ****************************************************************************
// SIO4_DCD_CABLE_CONFIG

#define	SIO4_DCD_CABLE_CONFIG_DISABLE		0
#define	SIO4_DCD_CABLE_CONFIG_DCD_IN		1
#define	SIO4_DCD_CABLE_CONFIG_DCD_IN_SYNC	2
#define	SIO4_DCD_CABLE_CONFIG_CTS_IN		3
#define	SIO4_DCD_CABLE_CONFIG_CTS_IN_SYNC	4
#define	SIO4_DCD_CABLE_CONFIG_RTS_OUT		5
#define	SIO4_DCD_CABLE_CONFIG_DRV_HI		6
#define	SIO4_DCD_CABLE_CONFIG_DRV_LOW		7
#define	SIO4_DCD_CABLE_CONFIG_READ			(-1)
#define	SIO4_DCD_CABLE_CONFIG_INVALID		(-2)
#define	SIO4_DCD_CABLE_CONFIG_UNKNOWN		(-3)

// ****************************************************************************
// SIO4_CABLE_CONFIG

#define	SIO4_CABLE_CONFIG__RXMASK_			0xC
#define	SIO4_CABLE_CONFIG__RXDIS_			0x0
#define	SIO4_CABLE_CONFIG__RXLWR_			0x8
#define	SIO4_CABLE_CONFIG__RXUPR_			0x4
#define	SIO4_CABLE_CONFIG__TXMASK_			0x3
#define	SIO4_CABLE_CONFIG__TXDIS_			0x0
#define	SIO4_CABLE_CONFIG__TXLWR_			0x2
#define	SIO4_CABLE_CONFIG__TXUPR_			0x1
#define	SIO4_CABLE_CONFIG__MASK_			( SIO4_CABLE_CONFIG__RXMASK_	\
											| SIO4_CABLE_CONFIG__TXMASK_	)
#define	SIO4_CABLE_CONFIG_TXDIS_RXDIS		( SIO4_CABLE_CONFIG__TXDIS_		\
											| SIO4_CABLE_CONFIG__RXDIS_		)
#define	SIO4_CABLE_CONFIG_TXDIS_RXLWR		( SIO4_CABLE_CONFIG__TXDIS_		\
											| SIO4_CABLE_CONFIG__RXLWR_		)
#define	SIO4_CABLE_CONFIG_TXDIS_RXUPR		( SIO4_CABLE_CONFIG__TXDIS_		\
											| SIO4_CABLE_CONFIG__RXUPR_		)
#define	SIO4_CABLE_CONFIG_TXLWR_RXDIS		( SIO4_CABLE_CONFIG__TXLWR_		\
											| SIO4_CABLE_CONFIG__RXDIS_		)
#define	SIO4_CABLE_CONFIG_TXLWR_RXLWR		( SIO4_CABLE_CONFIG__TXLWR_		\
											| SIO4_CABLE_CONFIG__RXLWR_		)
#define	SIO4_CABLE_CONFIG_TXLWR_RXUPR		( SIO4_CABLE_CONFIG__TXLWR_		\
											| SIO4_CABLE_CONFIG__RXUPR_		)
#define	SIO4_CABLE_CONFIG_TXUPR_RXDIS		( SIO4_CABLE_CONFIG__TXUPR_		\
											| SIO4_CABLE_CONFIG__RXDIS_		)
#define	SIO4_CABLE_CONFIG_TXUPR_RXLWR		( SIO4_CABLE_CONFIG__TXUPR_		\
											| SIO4_CABLE_CONFIG__RXLWR_		)
#define	SIO4_CABLE_CONFIG_TXUPR_RXUPR		( SIO4_CABLE_CONFIG__TXUPR_		\
											| SIO4_CABLE_CONFIG__RXUPR_		)

#define	SIO4_CABLE_CONFIG_DISABLE			SIO4_CABLE_CONFIG_TXDIS_RXDIS
#define	SIO4_CABLE_CONFIG_READ				(-1)
#define	SIO4_CABLE_CONFIG_INVALID			(-2)
#define	SIO4_CABLE_CONFIG_UNKNOWN			(-3)

// ****************************************************************************
// SIO4_MP_CONFIG
// SIO4_MP_INFO
// SIO4_MP_INIT
// SIO4_MP_RESET
// SIO4_MP_TEST

typedef enum
{
	SIO4_MP_CHIP_FIXED,
	SIO4_MP_CHIP_SP508,
	SIO4_MP_CHIP_UNKNOWN	= 999
} sio4_mp_chip_t;

typedef enum
{
	SIO4_MP_PROT_UNKNOWN		= -3,		// Queries only.
	SIO4_MP_PROT_INVALID		= -2,		// Queries only.
	SIO4_MP_PROT_READ			= -1,		// Queries only.
	SIO4_MP_PROT_DISABLE		= 0,
	SIO4_MP_PROT_RS_232			= 0x0001,
	SIO4_MP_PROT_RS_422_485		= 0x0002,
	SIO4_MP_PROT_RS_423			= 0x0004,
	SIO4_MP_PROT_RS_422_423_MM1	= 0x0008,	// Mixed Mode 1
	SIO4_MP_PROT_RS_422_423_MM2	= 0x0010,	// Moxed Mode 2
	SIO4_MP_PROT_RS_530_M1		= 0x0020,
	SIO4_MP_PROT_RS_530_M2		= 0x0040,
	SIO4_MP_PROT_V35_M1			= 0x0080,	// Mode 1
	SIO4_MP_PROT_V35_M2			= 0x0100	// Mode 2

} sio4_mp_prot_t;

typedef struct
{
	s32	chip;
	s32	prot_want;
	s32	prot_got;
} sio4_mp_t;

// ****************************************************************************
// SIO4_OSC_INFO
// SIO4_OSC_INIT
// SIO4_OSC_MEASURE
// SIO4_OSC_PROGRAM
// SIO4_OSC_REFERENCE
// SIO4_OSC_RESET
// SIO4_OSC_TEST

#define	SIO4_OSC_FREQ_REF_DEFAULT			20000000L

typedef enum
{
	SIO4_OSC_CHIP_FIXED,		// fixed
	SIO4_OSC_CHIP_IDC2053B,		// 1 x IDC2053B
	SIO4_OSC_CHIP_IDC2053B_4,	// 4 x IDC2053B
	SIO4_OSC_CHIP_CY22393,		// 1 x CY22393
	SIO4_OSC_CHIP_CY22393_2,	// 2 x CY22393
	SIO4_OSC_CHIP_UNKNOWN		= 999
} sio4_osc_chip_t;

typedef struct
{
	u32	chip;
	s32	freq_ref;	// Read by the reference set service only.
	s32	freq_want;
	s32	freq_got;
} sio4_osc_t;

// ****************************************************************************
// SIO4_TX_FIFO_STATUS						CSR DD8-D11
// SIO4_RX_FIFO_STATUS						CSR D12-D15
#define	SIO4_FIFO_STATUS_EMPTY				0
#define	SIO4_FIFO_STATUS_ALMOST_EMPTY		1
#define	SIO4_FIFO_STATUS_MEDIAN				2
#define	SIO4_FIFO_STATUS_ALMOST_FULL		3
#define	SIO4_FIFO_STATUS_FULL				4

// ****************************************************************************
// SIO4_FW_TYPE_CONFIG						FTR D0-D31 (when supported)

#define	SIO4_FW_TYPE_CONFIG_SYNC			0x04
#define	SIO4_FW_TYPE_CONFIG_Z16C30			0x01
#define	SIO4_FW_TYPE_CONFIG_READ			(-1)



#endif	// _ASMLANGUAGE

#endif // __SIO4_H__
